/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompactionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected String dataRegionId;
    protected String storageGroupName;
    protected long timePartition;
    protected final AtomicInteger currentTaskNum;
    protected final TsFileManager tsFileManager;
    protected ICompactionPerformer performer;
    protected int hashCode = -1;
    protected CompactionTaskSummary summary;
    protected long serialId;
    protected boolean crossTask;
    protected boolean innerSeqTask;
    protected long memoryCost = 0L;

    protected AbstractCompactionTask(String storageGroupName, String dataRegionId, long timePartition, TsFileManager tsFileManager, AtomicInteger currentTaskNum, long serialId) {
        this.storageGroupName = storageGroupName;
        this.dataRegionId = dataRegionId;
        this.timePartition = timePartition;
        this.tsFileManager = tsFileManager;
        this.currentTaskNum = currentTaskNum;
        this.serialId = serialId;
    }

    protected abstract List<TsFileResource> getAllSourceTsFiles();

    public boolean setSourceFilesToCompactionCandidate() {
        List<TsFileResource> files = this.getAllSourceTsFiles();
        for (int i = 0; i < files.size(); ++i) {
            if (files.get(i).setStatus(TsFileResourceStatus.COMPACTION_CANDIDATE)) continue;
            for (int j = 0; j < i; ++j) {
                files.get(j).setStatus(TsFileResourceStatus.NORMAL);
            }
            return false;
        }
        return true;
    }

    protected abstract boolean doCompaction();

    public boolean start() {
        this.currentTaskNum.incrementAndGet();
        boolean isSuccess = false;
        try {
            this.summary.start();
            isSuccess = this.doCompaction();
        }
        finally {
            this.currentTaskNum.decrementAndGet();
            this.summary.finish(isSuccess);
            CompactionTaskManager.getInstance().removeRunningTaskFuture(this);
            CompactionMetrics.getInstance().recordTaskFinishOrAbort(this.crossTask, this.innerSeqTask, this.summary.getTimeCost());
        }
        return isSuccess;
    }

    public String getStorageGroupName() {
        return this.storageGroupName;
    }

    public String getDataRegionId() {
        return this.dataRegionId;
    }

    public long getTimePartition() {
        return this.timePartition;
    }

    public abstract boolean equalsOtherTask(AbstractCompactionTask var1);

    public abstract boolean checkValidAndSetMerging();

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractCompactionTask) {
            return this.equalsOtherTask((AbstractCompactionTask)other);
        }
        return false;
    }

    public void resetCompactionCandidateStatusForAllSourceFiles() {
        List<TsFileResource> resources = this.getAllSourceTsFiles();
        resources.forEach(x -> x.setStatus(TsFileResourceStatus.NORMAL));
    }

    public long getTimeCost() {
        return this.summary.getTimeCost();
    }

    protected void checkInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException(String.format("%s-%s [Compaction] abort", this.storageGroupName, this.dataRegionId));
        }
    }

    public boolean isTaskRan() {
        return this.summary.isRan();
    }

    public void cancel() {
        this.summary.cancel();
    }

    public boolean isSuccess() {
        return this.summary.isSuccess();
    }

    public CompactionTaskSummary getSummary() {
        return this.summary;
    }

    public boolean isTaskFinished() {
        return this.summary.isFinished();
    }

    public long getSerialId() {
        return this.serialId;
    }

    protected abstract void createSummary();

    public boolean isCrossTask() {
        return this.crossTask;
    }

    public long getTemporalFileSize() {
        return this.summary.getTemporalFileSize();
    }

    public boolean isInnerSeqTask() {
        return this.innerSeqTask;
    }
}

