/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.recover;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogAnalyzer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.TsFileIdentifier;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.TsFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionRecoverTask {
    private final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private final File compactionLogFile;
    private final boolean isInnerSpace;
    private final String fullStorageGroupName;
    private final TsFileManager tsFileManager;

    public CompactionRecoverTask(String logicalStorageGroupName, String virtualStorageGroupName, TsFileManager tsFileManager, File logFile, boolean isInnerSpace) {
        this.compactionLogFile = logFile;
        this.isInnerSpace = isInnerSpace;
        this.fullStorageGroupName = logicalStorageGroupName + "-" + virtualStorageGroupName;
        this.tsFileManager = tsFileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doCompaction() {
        boolean recoverSuccess;
        block22: {
            List<TsFileIdentifier> deletedTargetFileIdentifiers;
            List<TsFileIdentifier> targetFileIdentifiers;
            List<TsFileIdentifier> sourceFileIdentifiers;
            CompactionRecoverFromOld compactionRecoverFromOld;
            CompactionLogAnalyzer logAnalyzer;
            block23: {
                block24: {
                    recoverSuccess = true;
                    this.logger.info("{} [Compaction][Recover] compaction log is {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    if (!this.compactionLogFile.exists()) break block22;
                    this.logger.info("{} [Compaction][Recover] compaction log file {} exists, start to recover it", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    logAnalyzer = new CompactionLogAnalyzer(this.compactionLogFile);
                    compactionRecoverFromOld = new CompactionRecoverFromOld();
                    if (this.isInnerSpace && compactionRecoverFromOld.isInnerCompactionLogBefore013()) {
                        logAnalyzer.analyzeOldInnerCompactionLog();
                    } else if (!this.isInnerSpace && compactionRecoverFromOld.isCrossCompactionLogBefore013()) {
                        logAnalyzer.analyzeOldCrossCompactionLog();
                    } else {
                        logAnalyzer.analyze();
                    }
                    sourceFileIdentifiers = logAnalyzer.getSourceFileInfos();
                    targetFileIdentifiers = logAnalyzer.getTargetFileInfos();
                    deletedTargetFileIdentifiers = logAnalyzer.getDeletedTargetFileInfos();
                    if (!targetFileIdentifiers.isEmpty() && !sourceFileIdentifiers.isEmpty()) break block23;
                    this.logger.info("{} [Compaction][Recover] incomplete log file, abort recover", (Object)this.fullStorageGroupName);
                    if (recoverSuccess) break block24;
                    this.logger.error("{} [Compaction][Recover] Failed to recover compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                    this.tsFileManager.setAllowCompaction(false);
                    return;
                }
                if (!this.compactionLogFile.exists()) return;
                try {
                    this.logger.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    FileUtils.delete((File)this.compactionLogFile);
                    return;
                }
                catch (IOException e) {
                    this.logger.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e});
                    this.tsFileManager.setAllowCompaction(false);
                }
                return;
            }
            try {
                boolean isAllSourcesFileExisted = true;
                for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
                    File sourceFile = sourceFileIdentifier.getFileFromDataDirs();
                    if (sourceFile != null) continue;
                    isAllSourcesFileExisted = false;
                    break;
                }
                if (isAllSourcesFileExisted) {
                    recoverSuccess = !this.isInnerSpace && logAnalyzer.isLogFromOld() ? compactionRecoverFromOld.handleCrossCompactionWithAllSourceFilesExistBefore013(targetFileIdentifiers) : this.handleWithAllSourceFilesExist(targetFileIdentifiers, sourceFileIdentifiers);
                    break block22;
                }
                recoverSuccess = !this.isInnerSpace && logAnalyzer.isLogFromOld() ? compactionRecoverFromOld.handleCrossCompactionWithSomeSourceFilesLostBefore013(targetFileIdentifiers, sourceFileIdentifiers) : this.handleWithSomeSourceFilesLost(targetFileIdentifiers, deletedTargetFileIdentifiers, sourceFileIdentifiers);
            }
            catch (IOException e) {
                block25: {
                    try {
                        this.logger.error("Recover compaction error", (Throwable)e);
                        if (recoverSuccess) break block25;
                    }
                    catch (Throwable throwable) {
                        if (!recoverSuccess) {
                            this.logger.error("{} [Compaction][Recover] Failed to recover compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                            this.tsFileManager.setAllowCompaction(false);
                            throw throwable;
                        }
                        if (!this.compactionLogFile.exists()) throw throwable;
                        try {
                            this.logger.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                            FileUtils.delete((File)this.compactionLogFile);
                            throw throwable;
                        }
                        catch (IOException e2) {
                            this.logger.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e2});
                            this.tsFileManager.setAllowCompaction(false);
                        }
                        throw throwable;
                    }
                    this.logger.error("{} [Compaction][Recover] Failed to recover compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
                    this.tsFileManager.setAllowCompaction(false);
                    return;
                }
                if (!this.compactionLogFile.exists()) return;
                try {
                    this.logger.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    FileUtils.delete((File)this.compactionLogFile);
                    return;
                }
                catch (IOException e3) {
                    this.logger.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e3});
                    this.tsFileManager.setAllowCompaction(false);
                }
                return;
            }
        }
        if (!recoverSuccess) {
            this.logger.error("{} [Compaction][Recover] Failed to recover compaction, set allowCompaction to false", (Object)this.fullStorageGroupName);
            this.tsFileManager.setAllowCompaction(false);
            return;
        } else {
            if (!this.compactionLogFile.exists()) return;
            try {
                this.logger.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                FileUtils.delete((File)this.compactionLogFile);
                return;
            }
            catch (IOException e) {
                this.logger.error("{} [Compaction][Recover] Exception occurs while deleting log file {}, set allowCompaction to false", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e});
                this.tsFileManager.setAllowCompaction(false);
            }
        }
        return;
    }

    private boolean handleWithAllSourceFilesExist(List<TsFileIdentifier> targetFileIdentifiers, List<TsFileIdentifier> sourceFileIdentifiers) {
        this.logger.info("{} [Compaction][Recover] all source files exists, delete all target files.", (Object)this.fullStorageGroupName);
        for (TsFileIdentifier tsFileIdentifier : targetFileIdentifiers) {
            File tmpTargetFile = tsFileIdentifier.getFileFromDataDirs();
            File targetFile = this.getFileFromDataDirs(tsFileIdentifier.getFilePath().replace(this.isInnerSpace ? ".inner" : ".cross", ".tsfile"));
            TsFileResource targetResource = null;
            if (tmpTargetFile != null) {
                targetResource = new TsFileResource(tmpTargetFile);
            } else if (targetFile != null) {
                targetResource = new TsFileResource(targetFile);
            }
            if (targetResource == null || targetResource.remove()) continue;
            this.logger.error("{} [Compaction][Recover] failed to remove target file {}", (Object)this.fullStorageGroupName, (Object)targetResource);
            return false;
        }
        ArrayList<TsFileResource> sourceTsFileResourceList = new ArrayList<TsFileResource>();
        for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
            sourceTsFileResourceList.add(new TsFileResource(sourceFileIdentifier.getFileFromDataDirs()));
        }
        try {
            CompactionUtils.deleteCompactionModsFile(sourceTsFileResourceList, Collections.emptyList());
        }
        catch (IOException iOException) {
            this.logger.error("{} [Compaction][Recover] Exception occurs while deleting compaction mods file, set allowCompaction to false", (Object)this.fullStorageGroupName, (Object)iOException);
            return false;
        }
        return true;
    }

    private boolean handleWithSomeSourceFilesLost(List<TsFileIdentifier> targetFileIdentifiers, List<TsFileIdentifier> deletedTargetFileIdentifiers, List<TsFileIdentifier> sourceFileIdentifiers) throws IOException {
        if (!this.checkIsTargetFilesComplete(targetFileIdentifiers, deletedTargetFileIdentifiers)) {
            return false;
        }
        boolean handleSuccess = true;
        for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
            if (this.deleteFile(sourceFileIdentifier)) continue;
            handleSuccess = false;
        }
        return handleSuccess;
    }

    private File getFileFromDataDirs(String filePath) {
        String[] dataDirs;
        for (String dataDir : dataDirs = IoTDBDescriptor.getInstance().getConfig().getLocalDataDirs()) {
            File f = new File(dataDir, filePath);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    private boolean checkIsTargetFilesComplete(List<TsFileIdentifier> targetFileIdentifiers, List<TsFileIdentifier> deletedTargetFileIdentifiers) throws IOException {
        for (TsFileIdentifier targetFileIdentifier : targetFileIdentifiers) {
            targetFileIdentifier.setFilename(targetFileIdentifier.getFilename().replace(this.isInnerSpace ? ".inner" : ".cross", ".tsfile"));
            boolean isTargetFileDeleted = deletedTargetFileIdentifiers.contains(targetFileIdentifier);
            if (isTargetFileDeleted) {
                if (this.deleteFile(targetFileIdentifier)) continue;
                return false;
            }
            File targetFile = this.getFileFromDataDirs(targetFileIdentifier.getFilePath());
            if (targetFile != null && TsFileUtils.isTsFileComplete((File)new TsFileResource(targetFile).getTsFile())) continue;
            this.logger.error("{} [Compaction][ExceptionHandler] target file {} is not complete, and some source files is lost, do nothing. Set allowCompaction to false", (Object)this.fullStorageGroupName, (Object)targetFileIdentifier.getFilePath());
            CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
            return false;
        }
        return true;
    }

    private boolean deleteFile(TsFileIdentifier tsFileIdentifier) {
        boolean success = true;
        File file = tsFileIdentifier.getFileFromDataDirs();
        if (!this.checkAndDeleteFile(file)) {
            success = false;
        }
        if (!this.checkAndDeleteFile(file = this.getFileFromDataDirs(tsFileIdentifier.getFilePath() + ".resource"))) {
            success = false;
        }
        if (!this.checkAndDeleteFile(file = this.getFileFromDataDirs(tsFileIdentifier.getFilePath() + ".mods"))) {
            success = false;
        }
        if (!this.checkAndDeleteFile(file = this.getFileFromDataDirs(tsFileIdentifier.getFilePath() + ".compaction.mods"))) {
            success = false;
        }
        return success;
    }

    private boolean checkAndDeleteFile(File file) {
        if (file == null || !file.exists()) {
            return true;
        }
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            this.logger.error("{} [Compaction][Recover] failed to remove file {}, exception: {}", new Object[]{this.fullStorageGroupName, file, e});
            return false;
        }
        return true;
    }

    private class CompactionRecoverFromOld {
        private CompactionRecoverFromOld() {
        }

        private boolean isCrossCompactionLogBefore013() {
            return CompactionRecoverTask.this.compactionLogFile.getName().equals("merge.log");
        }

        private boolean isInnerCompactionLogBefore013() {
            return CompactionRecoverTask.this.compactionLogFile.getName().startsWith(CompactionRecoverTask.this.tsFileManager.getStorageGroupName());
        }

        private boolean handleCrossCompactionWithAllSourceFilesExistBefore013(List<TsFileIdentifier> targetFileIdentifiers) {
            for (TsFileIdentifier targetFileIdentifier : targetFileIdentifiers) {
                File chunkMetadataTempFile;
                File tmpTargetFile = targetFileIdentifier.getFileFromDataDirs();
                if (tmpTargetFile == null) continue;
                try {
                    Files.delete(tmpTargetFile.toPath());
                }
                catch (IOException e) {
                    CompactionRecoverTask.this.logger.error("{} [Compaction][Recover] failed to remove file {}, exception: {}", new Object[]{CompactionRecoverTask.this.fullStorageGroupName, tmpTargetFile, e});
                }
                if (!(chunkMetadataTempFile = new File(tmpTargetFile.getAbsolutePath() + ".meta")).exists()) continue;
                try {
                    Files.delete(chunkMetadataTempFile.toPath());
                }
                catch (IOException e) {
                    CompactionRecoverTask.this.logger.error("{} [Compaction][Recover] failed to remove file {}, exception: {}", new Object[]{CompactionRecoverTask.this.fullStorageGroupName, chunkMetadataTempFile, e});
                }
            }
            File compactionModsFileFromOld = new File(CompactionRecoverTask.this.tsFileManager.getStorageGroupDir() + File.separator + "merge.mods");
            return CompactionRecoverTask.this.checkAndDeleteFile(compactionModsFileFromOld);
        }

        private boolean handleCrossCompactionWithSomeSourceFilesLostBefore013(List<TsFileIdentifier> targetFileIdentifiers, List<TsFileIdentifier> sourceFileIdentifiers) {
            try {
                File compactionModsFileFromOld = new File(CompactionRecoverTask.this.tsFileManager.getStorageGroupDir() + File.separator + "merge.mods");
                ArrayList<TsFileResource> targetFileResources = new ArrayList<TsFileResource>();
                for (int i = 0; i < sourceFileIdentifiers.size(); ++i) {
                    File sourceFile;
                    TsFileIdentifier sourceFileIdentifier = sourceFileIdentifiers.get(i);
                    if (sourceFileIdentifier.isSequence()) {
                        File tmpTargetFile = targetFileIdentifiers.get(i).getFileFromDataDirs();
                        File targetFile = null;
                        if (tmpTargetFile != null) {
                            String sourceFilePath = tmpTargetFile.getPath().replace(".tsfile.merge", ".tsfile");
                            targetFile = TsFileNameGenerator.increaseCrossCompactionCnt(new File(sourceFilePath));
                            FSFactoryProducer.getFSFactory().moveFile(tmpTargetFile, targetFile);
                        } else {
                            File file = TsFileNameGenerator.increaseCrossCompactionCnt(new File(targetFileIdentifiers.get(i).getFilePath().replace(".tsfile.merge", ".tsfile")));
                            targetFile = CompactionRecoverTask.this.getFileFromDataDirs(file.getPath());
                        }
                        if (targetFile == null) {
                            CompactionRecoverTask.this.logger.error("{} [Compaction][Recover] target file of source seq file {} does not exist (<0.13).", (Object)CompactionRecoverTask.this.fullStorageGroupName, (Object)sourceFileIdentifier.getFilePath());
                            return false;
                        }
                        TsFileResource targetResource = new TsFileResource(targetFile);
                        if (!targetResource.resourceFileExists()) {
                            try (TsFileSequenceReader reader = new TsFileSequenceReader(targetFile.getAbsolutePath());){
                                FileLoaderUtils.updateTsFileResource(reader, targetResource);
                            }
                            targetResource.serialize();
                        }
                        targetFileResources.add(targetResource);
                        if (compactionModsFileFromOld.exists()) {
                            ModificationFile compactionModsFile = new ModificationFile(compactionModsFileFromOld.getPath());
                            this.appendCompactionModificationsBefore013(targetResource, compactionModsFile);
                        }
                        if (!CompactionRecoverTask.this.checkAndDeleteFile(tmpTargetFile)) {
                            return false;
                        }
                    }
                    if (!CompactionRecoverTask.this.checkAndDeleteFile(sourceFile = sourceFileIdentifier.getFileFromDataDirs())) {
                        return false;
                    }
                    sourceFile = CompactionRecoverTask.this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".resource");
                    if (!CompactionRecoverTask.this.checkAndDeleteFile(sourceFile)) {
                        return false;
                    }
                    sourceFile = CompactionRecoverTask.this.getFileFromDataDirs(sourceFileIdentifier.getFilePath() + ".mods");
                    if (CompactionRecoverTask.this.checkAndDeleteFile(sourceFile)) continue;
                    return false;
                }
                if (!CompactionRecoverTask.this.checkAndDeleteFile(compactionModsFileFromOld)) {
                    return false;
                }
            }
            catch (IOException e) {
                CompactionRecoverTask.this.logger.error("{} [Compaction][Recover] fail to handle with some source files lost from old version.", (Object)CompactionRecoverTask.this.fullStorageGroupName, (Object)e);
                return false;
            }
            return true;
        }

        private void appendCompactionModificationsBefore013(TsFileResource resource, ModificationFile compactionModsFile) throws IOException {
            if (compactionModsFile != null) {
                for (Modification modification : compactionModsFile.getModifications()) {
                    modification.setFileOffset(Long.MAX_VALUE);
                    resource.getModFile().write(modification);
                }
                resource.getModFile().close();
            }
        }
    }
}

