/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.basic;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.Traverser;

public abstract class MeasurementTraverser<R, N extends IMNode<N>>
extends Traverser<R, N> {
    public MeasurementTraverser(N startNode, PartialPath path, IMTreeStore<N> store, boolean isPrefixMatch) throws MetadataException {
        super(startNode, path, store, isPrefixMatch);
    }

    protected boolean mayTargetNodeType(N node) {
        return node.isMeasurement();
    }

    protected boolean acceptFullMatchedNode(N node) {
        return node.isMeasurement();
    }

    protected boolean acceptInternalMatchedNode(N node) {
        return false;
    }

    protected boolean shouldVisitSubtreeOfFullMatchedNode(N node) {
        return !node.isMeasurement();
    }

    protected boolean shouldVisitSubtreeOfInternalMatchedNode(N node) {
        return !node.isMeasurement();
    }
}

