/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.SchemaPageOverflowException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.ICachedMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegmentedPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.RecordUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SegmentedPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.log.SchemaFileLogReader;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.log.SchemaFileLogWriter;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr.IPageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PageManager
implements IPageManager {
    protected static final Logger logger = LoggerFactory.getLogger(PageManager.class);
    protected final Map<Integer, ISchemaPage> pageInstCache;
    protected final Map<Integer, ISchemaPage> dirtyPages;
    protected final LinkedList<Integer>[] tieredDirtyPageIndex = new LinkedList[SchemaFileConfig.SEG_SIZE_LST.length];
    protected final ReentrantLock evictLock;
    protected final PageLocks pageLocks;
    protected final AtomicInteger lastPageIndex;
    protected int[] treeTrace;
    private final FileChannel channel;
    private File pmtFile;
    private FileChannel readChannel;
    private final AtomicInteger logCounter;
    private SchemaFileLogWriter logWriter;

    PageManager(FileChannel channel, File pmtFile, int lastPageIndex, String logPath) throws IOException, MetadataException {
        this.pageInstCache = Collections.synchronizedMap(new LinkedHashMap(SchemaFileConfig.PAGE_CACHE_SIZE, 1.0f, true));
        this.dirtyPages = new ConcurrentHashMap<Integer, ISchemaPage>();
        for (int i = 0; i < this.tieredDirtyPageIndex.length; ++i) {
            this.tieredDirtyPageIndex[i] = new LinkedList();
        }
        this.evictLock = new ReentrantLock();
        this.pageLocks = new PageLocks();
        this.lastPageIndex = lastPageIndex >= 0 ? new AtomicInteger(lastPageIndex) : new AtomicInteger(0);
        this.treeTrace = new int[16];
        this.channel = channel;
        this.pmtFile = pmtFile;
        this.readChannel = FileChannel.open(pmtFile.toPath(), StandardOpenOption.READ);
        int pageAcc = (int)this.recoverFromLog(logPath) / 16384;
        this.logWriter = new SchemaFileLogWriter(logPath);
        this.logCounter = new AtomicInteger(pageAcc);
        if (lastPageIndex < 0) {
            ISegmentedPage rootPage = ISchemaPage.initSegmentedPage(ByteBuffer.allocate(16384), 0);
            rootPage.allocNewSegment((short)16350);
            this.pageInstCache.put(rootPage.getPageIndex(), rootPage);
            this.markDirty(rootPage);
        }
    }

    private long recoverFromLog(String logPath) throws IOException, MetadataException {
        SchemaFileLogReader reader = new SchemaFileLogReader(logPath);
        List<byte[]> res = reader.collectUpdatedEntries();
        for (byte[] entry : res) {
            SchemaPage page = ISchemaPage.loadSchemaPage(ByteBuffer.wrap(entry));
            page.flushPageToChannel(this.channel);
        }
        reader.close();
        if (!res.isEmpty()) {
            try (FileOutputStream outputStream = new FileOutputStream(logPath, true);){
                long length;
                outputStream.write(new byte[]{-1});
                long l = length = outputStream.getChannel().size();
                return l;
            }
        }
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeNewChildren(ICachedMNode node) throws MetadataException, IOException {
        long curSegAddr = SchemaFile.getNodeAddress(node);
        for (Map.Entry entry : ICachedMNodeContainer.getCachedMNodeContainer(node).getNewChildBuffer().entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList())) {
            int subIndex;
            String alias;
            ICachedMNode child = (ICachedMNode)entry.getValue();
            if (!child.isMeasurement()) {
                alias = null;
                if (SchemaFile.getNodeAddress(child) >= 0L) throw new MetadataException("A child in newChildBuffer shall not have segmentAddress.");
                short estSegSize = PageManager.estimateSegmentSize(child);
                long glbIndex = this.preAllocateSegment(estSegSize);
                SchemaFile.setNodeAddress(child, glbIndex);
            } else {
                alias = child.getAsMeasurementMNode().getAlias() == null ? null : child.getAsMeasurementMNode().getAlias();
            }
            ByteBuffer childBuffer = RecordUtils.node2Buffer(child);
            long actualAddress = this.getTargetSegmentAddress(curSegAddr, (String)entry.getKey());
            ISchemaPage curPage = this.getPageInstance(SchemaFile.getPageIndex(actualAddress));
            try {
                curPage.getAsSegmentedPage().write(SchemaFile.getSegIndex(actualAddress), (String)entry.getKey(), childBuffer);
                this.markDirty(curPage);
                this.addPageToCache(curPage.getPageIndex(), curPage);
                subIndex = this.subIndexRootPage(curSegAddr);
                if (alias == null || subIndex < 0) continue;
                this.insertSubIndexEntry(subIndex, alias, (String)entry.getKey());
            }
            catch (SchemaPageOverflowException e) {
                if (curPage.getAsSegmentedPage().getSegmentSize(SchemaFile.getSegIndex(actualAddress)) == 16350) {
                    this.multiPageInsertOverflowOperation(curPage, (String)entry.getKey(), childBuffer);
                    subIndex = this.subIndexRootPage(curSegAddr);
                    if (node.isDevice() && subIndex < 0) {
                        this.buildSubIndex(node);
                        continue;
                    }
                    if (alias == null) continue;
                    this.insertSubIndexEntry(subIndex, alias, (String)entry.getKey());
                    continue;
                }
                short actSegId = SchemaFile.getSegIndex(actualAddress);
                short newSegSize = PageManager.reEstimateSegSize(curPage.getAsSegmentedPage().getSegmentSize(actSegId) + childBuffer.capacity(), ICachedMNodeContainer.getCachedMNodeContainer(node).getNewChildBuffer().entrySet().size());
                ISegmentedPage newPage = this.getMinApplSegmentedPageInMem(newSegSize);
                curSegAddr = newPage.transplantSegment(curPage.getAsSegmentedPage(), actSegId, newSegSize);
                newPage.write(SchemaFile.getSegIndex(curSegAddr), (String)entry.getKey(), childBuffer);
                curPage.getAsSegmentedPage().deleteSegment(actSegId);
                SchemaFile.setNodeAddress(node, curSegAddr);
                this.updateParentalRecord((ICachedMNode)node.getParent(), node.getName(), curSegAddr);
                this.markDirty(curPage);
                this.addPageToCache(curPage.getPageIndex(), curPage);
            }
        }
    }

    @Override
    public void writeUpdatedChildren(ICachedMNode node) throws MetadataException, IOException {
        boolean removeOldSubEntry = false;
        boolean insertNewSubEntry = false;
        long curSegAddr = SchemaFile.getNodeAddress(node);
        for (Map.Entry<String, ICachedMNode> entry : ICachedMNodeContainer.getCachedMNodeContainer(node).getUpdatedChildBuffer().entrySet()) {
            int subIndex;
            ICachedMNode oldChild;
            ICachedMNode child = entry.getValue();
            long actualAddress = this.getTargetSegmentAddress(curSegAddr, entry.getKey());
            ByteBuffer childBuffer = RecordUtils.node2Buffer(child);
            ISchemaPage curPage = this.getPageInstance(SchemaFile.getPageIndex(actualAddress));
            if (curPage.getAsSegmentedPage().read(SchemaFile.getSegIndex(actualAddress), entry.getKey()) == null) {
                throw new MetadataException(String.format("Node[%s] has no child[%s] in pbtree file.", node.getName(), entry.getKey()));
            }
            String alias = child.isMeasurement() && child.getAsMeasurementMNode().getAlias() != null ? child.getAsMeasurementMNode().getAlias() : null;
            String oldAlias = node.isDevice() ? ((oldChild = curPage.getAsSegmentedPage().read(SchemaFile.getSegIndex(actualAddress), entry.getKey())).isMeasurement() ? oldChild.getAsMeasurementMNode().getAlias() : null) : null;
            if (alias == null && oldAlias != null) {
                removeOldSubEntry = true;
                insertNewSubEntry = false;
            } else if (alias != null && oldAlias == null) {
                removeOldSubEntry = false;
                insertNewSubEntry = true;
            } else if (alias != null && alias.compareTo(oldAlias) != 0) {
                removeOldSubEntry = true;
                insertNewSubEntry = true;
            } else {
                removeOldSubEntry = false;
                insertNewSubEntry = false;
            }
            try {
                curPage.getAsSegmentedPage().update(SchemaFile.getSegIndex(actualAddress), entry.getKey(), childBuffer);
                this.markDirty(curPage);
                this.addPageToCache(curPage.getPageIndex(), curPage);
                subIndex = this.subIndexRootPage(curSegAddr);
                if (subIndex < 0) continue;
                if (removeOldSubEntry) {
                    this.removeSubIndexEntry(subIndex, oldAlias);
                }
                if (!insertNewSubEntry) continue;
                this.insertSubIndexEntry(subIndex, alias, entry.getKey());
            }
            catch (SchemaPageOverflowException e) {
                if (curPage.getAsSegmentedPage().getSegmentSize(SchemaFile.getSegIndex(actualAddress)) == 16350) {
                    this.multiPageUpdateOverflowOperation(curPage, entry.getKey(), childBuffer);
                    subIndex = this.subIndexRootPage(curSegAddr);
                    if (node.isDevice() && subIndex < 0) {
                        this.buildSubIndex(node);
                        continue;
                    }
                    if (!insertNewSubEntry && !removeOldSubEntry) continue;
                    if (removeOldSubEntry) {
                        this.removeSubIndexEntry(subIndex, oldAlias);
                    }
                    if (!insertNewSubEntry) continue;
                    this.insertSubIndexEntry(subIndex, alias, entry.getKey());
                    continue;
                }
                short actSegId = SchemaFile.getSegIndex(actualAddress);
                short newSegSiz = PageManager.reEstimateSegSize(curPage.getAsSegmentedPage().getSegmentSize(actSegId) + childBuffer.capacity());
                ISegmentedPage newPage = this.getMinApplSegmentedPageInMem(newSegSiz);
                curSegAddr = newPage.transplantSegment(curPage.getAsSegmentedPage(), actSegId, newSegSiz);
                curPage.getAsSegmentedPage().deleteSegment(actSegId);
                newPage.update(SchemaFile.getSegIndex(curSegAddr), entry.getKey(), childBuffer);
                SchemaFile.setNodeAddress(node, curSegAddr);
                this.updateParentalRecord((ICachedMNode)node.getParent(), node.getName(), curSegAddr);
                this.markDirty(curPage);
                this.addPageToCache(curPage.getPageIndex(), curPage);
            }
        }
    }

    protected abstract long getTargetSegmentAddress(long var1, String var3) throws IOException, MetadataException;

    protected abstract void multiPageInsertOverflowOperation(ISchemaPage var1, String var2, ByteBuffer var3) throws MetadataException, IOException;

    protected abstract void multiPageUpdateOverflowOperation(ISchemaPage var1, String var2, ByteBuffer var3) throws MetadataException, IOException;

    protected abstract void buildSubIndex(ICachedMNode var1) throws MetadataException, IOException;

    protected abstract void insertSubIndexEntry(int var1, String var2, String var3) throws MetadataException, IOException;

    protected abstract void removeSubIndexEntry(int var1, String var2) throws MetadataException, IOException;

    protected abstract String searchSubIndexAlias(int var1, String var2) throws MetadataException, IOException;

    @Override
    public int getLastPageIndex() {
        return this.lastPageIndex.get();
    }

    @Override
    public void flushDirtyPages() throws IOException {
        if (this.dirtyPages.size() == 0) {
            return;
        }
        if (this.logCounter.get() > SchemaFileConfig.SCHEMA_FILE_LOG_SIZE) {
            this.logWriter = this.logWriter.renew();
            this.logCounter.set(0);
        }
        this.logCounter.addAndGet(this.dirtyPages.size());
        for (ISchemaPage page : this.dirtyPages.values()) {
            page.syncPageBuffer();
            this.logWriter.write(page);
        }
        this.logWriter.prepare();
        for (ISchemaPage page : this.dirtyPages.values()) {
            page.flushPageToChannel(this.channel);
        }
        this.logWriter.commit();
        this.dirtyPages.clear();
        Arrays.stream(this.tieredDirtyPageIndex).forEach(LinkedList::clear);
    }

    @Override
    public void clear() throws IOException, MetadataException {
        this.dirtyPages.clear();
        Arrays.stream(this.tieredDirtyPageIndex).forEach(LinkedList::clear);
        this.pageInstCache.clear();
        this.lastPageIndex.set(0);
        this.logWriter = this.logWriter.renew();
    }

    @Override
    public void inspect(PrintWriter pw) throws IOException, MetadataException {
        for (int i = 0; i <= this.lastPageIndex.get(); ++i) {
            String pageContent = this.getPageInstance(i).inspect();
            pw.print("---------------------\n");
            pw.print(pageContent);
            pw.print("\n");
        }
    }

    @Override
    public void close() throws IOException {
        this.logWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISchemaPage getPageInstance(int pageIdx) throws IOException, MetadataException {
        if (pageIdx > this.lastPageIndex.get()) {
            throw new MetadataException(String.format("Page index %d out of range.", pageIdx));
        }
        this.pageLocks.readLock(pageIdx);
        try {
            if (this.dirtyPages.containsKey(pageIdx)) {
                ISchemaPage iSchemaPage = this.dirtyPages.get(pageIdx);
                return iSchemaPage;
            }
            if (this.pageInstCache.containsKey(pageIdx)) {
                ISchemaPage iSchemaPage = this.pageInstCache.get(pageIdx);
                return iSchemaPage;
            }
        }
        finally {
            this.pageLocks.readUnlock(pageIdx);
        }
        try {
            this.pageLocks.writeLock(pageIdx);
            ByteBuffer newBuf = ByteBuffer.allocate(16384);
            this.loadFromFile(newBuf, pageIdx);
            ISchemaPage iSchemaPage = this.addPageToCache(pageIdx, ISchemaPage.loadSchemaPage(newBuf));
            return iSchemaPage;
        }
        finally {
            this.pageLocks.writeUnlock(pageIdx);
        }
    }

    private long preAllocateSegment(short size) throws IOException, MetadataException {
        ISegmentedPage page = this.getMinApplSegmentedPageInMem(size);
        return SchemaFile.getGlobalIndex(page.getPageIndex(), page.allocNewSegment(size));
    }

    protected ISchemaPage replacePageInCache(ISchemaPage page) {
        this.markDirty(page);
        return this.addPageToCache(page.getPageIndex(), page);
    }

    protected ISegmentedPage getMinApplSegmentedPageInMem(short size) {
        ISchemaPage targetPage = null;
        int tierLoopCnt = 0;
        for (int i = 0; i < this.tieredDirtyPageIndex.length && this.dirtyPages.size() > 0; ++i) {
            for (tierLoopCnt = this.tieredDirtyPageIndex[i].size(); size < SchemaFileConfig.SEG_SIZE_LST[i] && tierLoopCnt > 0; --tierLoopCnt) {
                targetPage = this.dirtyPages.get(this.tieredDirtyPageIndex[i].pop());
                if (targetPage == null || targetPage.getAsSegmentedPage() == null) continue;
                if (!targetPage.getAsSegmentedPage().isCapableForSegSize(size)) continue;
                this.sortSegmentedIntoIndex(targetPage, size);
                return targetPage.getAsSegmentedPage();
            }
        }
        for (Map.Entry<Integer, ISchemaPage> entry : this.pageInstCache.entrySet()) {
            if (entry.getValue().getAsSegmentedPage() == null || !entry.getValue().getAsSegmentedPage().isCapableForSegSize(size)) continue;
            this.markDirty(entry.getValue());
            return this.pageInstCache.get(entry.getKey()).getAsSegmentedPage();
        }
        return this.allocateNewSegmentedPage().getAsSegmentedPage();
    }

    protected void sortSegmentedIntoIndex(ISchemaPage page, short newSegSize) {
        short availableSize;
        short s = availableSize = newSegSize < 0 ? (short)(page.getAsSegmentedPage().getSpareSize() - 2) : (short)(page.getAsSegmentedPage().getSpareSize() - newSegSize - 2);
        if (availableSize < 25) {
            return;
        }
        for (int i = 0; i < SchemaFileConfig.SEG_SIZE_LST.length; ++i) {
            if (availableSize >= SchemaFileConfig.SEG_SIZE_LST[i]) continue;
            this.tieredDirtyPageIndex[i].add(page.getPageIndex());
            return;
        }
    }

    protected synchronized ISchemaPage allocateNewSegmentedPage() {
        this.lastPageIndex.incrementAndGet();
        ISegmentedPage newPage = ISchemaPage.initSegmentedPage(ByteBuffer.allocate(16384), this.lastPageIndex.get());
        this.markDirty(newPage);
        return this.addPageToCache(newPage.getPageIndex(), newPage);
    }

    protected synchronized ISchemaPage registerAsNewPage(ISchemaPage page) {
        page.setPageIndex(this.lastPageIndex.incrementAndGet());
        this.markDirty(page);
        return this.addPageToCache(page.getPageIndex(), page);
    }

    protected void markDirty(ISchemaPage page) {
        page.markDirty();
        this.dirtyPages.put(page.getPageIndex(), page);
        if (page.getAsSegmentedPage() != null) {
            this.sortSegmentedIntoIndex(page, (short)-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISchemaPage addPageToCache(int pageIndex, ISchemaPage page) {
        this.pageInstCache.put(pageIndex, page);
        if (this.evictLock.tryLock()) {
            try {
                if (this.pageInstCache.size() > SchemaFileConfig.PAGE_CACHE_SIZE) {
                    int removeCnt = (int)(0.2 * (double)this.pageInstCache.size()) > 0 ? (int)(0.2 * (double)this.pageInstCache.size()) : 1;
                    List<Integer> rmvIds = new ArrayList<Integer>(this.pageInstCache.keySet()).subList(0, removeCnt);
                    for (Integer id : rmvIds) {
                        if (!this.pageLocks.findLock(id).writeLock().tryLock()) continue;
                        try {
                            this.pageInstCache.remove(id);
                        }
                        finally {
                            this.pageLocks.findLock(id).writeLock().unlock();
                        }
                    }
                }
            }
            finally {
                this.evictLock.unlock();
            }
        }
        return page;
    }

    private synchronized int loadFromFile(ByteBuffer dst, int pageIndex) throws IOException {
        dst.clear();
        if (!this.readChannel.isOpen()) {
            this.readChannel = FileChannel.open(this.pmtFile.toPath(), StandardOpenOption.READ);
        }
        return this.readChannel.read(dst, PageManager.getPageAddress(pageIndex));
    }

    private void updateParentalRecord(ICachedMNode parent, String key, long newSegAddr) throws IOException, MetadataException {
        if (parent == null || ((ICachedMNode)parent.getChild(key)).isDatabase()) {
            throw new MetadataException("Root page shall not be migrated.");
        }
        long parSegAddr = parent.getParent() == null ? 0L : SchemaFile.getNodeAddress(parent);
        parSegAddr = this.getTargetSegmentAddress(parSegAddr, key);
        ISchemaPage page = this.getPageInstance(SchemaFile.getPageIndex(parSegAddr));
        ((SegmentedPage)page).updateRecordSegAddr(SchemaFile.getSegIndex(parSegAddr), key, newSegAddr);
        this.markDirty(page);
    }

    private int subIndexRootPage(long addr) throws IOException, MetadataException {
        return this.getPageInstance(SchemaFile.getPageIndex(addr)).getSubIndex();
    }

    private static long getPageAddress(int pageIndex) {
        return (0xFFFFFFFFL & (long)pageIndex) * 16384L + (long)SchemaFileConfig.FILE_HEADER_SIZE;
    }

    private static short estimateSegmentSize(ICachedMNode node) {
        int childNum = node.getChildren().size();
        if (childNum < SchemaFileConfig.SEG_SIZE_METRIC[0]) {
            int totalSize = 25 + 6 * childNum;
            for (ICachedMNode child : node.getChildren().values()) {
                totalSize += child.getName().getBytes().length;
                if (child.isMeasurement()) {
                    totalSize += child.getAsMeasurementMNode().getAlias() == null ? 4 : child.getAsMeasurementMNode().getAlias().getBytes().length + 4;
                    totalSize += 24;
                    continue;
                }
                totalSize += 16;
            }
            return (short)totalSize > SchemaFileConfig.SEG_MIN_SIZ ? (short)totalSize : SchemaFileConfig.SEG_MIN_SIZ;
        }
        for (int tier = SchemaFileConfig.SEG_SIZE_LST.length - 1; tier > 0; --tier) {
            if (childNum <= SchemaFileConfig.SEG_SIZE_METRIC[tier]) continue;
            return SchemaFileConfig.SEG_SIZE_LST[tier];
        }
        return SchemaFileConfig.SEG_SIZE_LST[0];
    }

    private static short reEstimateSegSize(int expSize, int batchSize) throws MetadataException {
        if (batchSize < SchemaFileConfig.SEG_SIZE_METRIC[0]) {
            return PageManager.reEstimateSegSize(expSize);
        }
        int base_tier = 0;
        for (int i = 0; i < SchemaFileConfig.SEG_SIZE_LST.length; ++i) {
            if (SchemaFileConfig.SEG_SIZE_LST[i] < expSize) continue;
            base_tier = i;
            break;
        }
        for (int tier = SchemaFileConfig.SEG_SIZE_LST.length - 1; tier >= base_tier; --tier) {
            if (batchSize <= SchemaFileConfig.SEG_SIZE_METRIC[tier]) continue;
            return SchemaFileConfig.SEG_SIZE_LST[tier];
        }
        return SchemaFileConfig.SEG_SIZE_LST[base_tier];
    }

    private static short reEstimateSegSize(int expSize) throws MetadataException {
        if (expSize > 16350) {
            throw new MetadataException("Single record larger than half page is not supported in SchemaFile now.");
        }
        for (short size : SchemaFileConfig.SEG_SIZE_LST) {
            if (expSize >= size) continue;
            return size;
        }
        return 16350;
    }

    public long getTargetSegmentAddressOnTest(long curSegAddr, String recKey) throws IOException, MetadataException {
        return this.getTargetSegmentAddress(curSegAddr, recKey);
    }

    public ISchemaPage getPageInstanceOnTest(int pageIdx) throws IOException, MetadataException {
        return this.getPageInstance(pageIdx);
    }

    private static class PageLocks {
        private static final int NUM_OF_LOCKS = 1039;
        private final ReentrantReadWriteLock[] locks = new ReentrantReadWriteLock[1039];

        protected PageLocks() {
            for (int i = 0; i < 1039; ++i) {
                this.locks[i] = new ReentrantReadWriteLock();
            }
        }

        public void readLock(int hash) {
            this.findLock(hash).readLock().lock();
        }

        public void readUnlock(int hash) {
            this.findLock(hash).readLock().unlock();
        }

        public void writeLock(int hash) {
            this.findLock(hash).writeLock().lock();
        }

        public void writeUnlock(int hash) {
            this.findLock(hash).writeLock().unlock();
        }

        private ReentrantReadWriteLock findLock(int hash) {
            return this.locks[hash % 1039];
        }
    }
}

