/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure.tv;

import java.io.IOException;
import org.apache.iotdb.commons.udf.utils.UDFBinaryTransformer;
import org.apache.iotdb.db.queryengine.transformation.datastructure.SerializableList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.SerializableBinaryTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.type.Binary;

public class ElasticSerializableBinaryTVList
extends ElasticSerializableTVList {
    protected static final int MEMORY_CHECK_THRESHOLD = 1000;
    protected int byteArrayLengthForMemoryControl = SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL;
    protected long totalByteArrayLengthLimit = 0L;
    protected long totalByteArrayLength = 0L;

    public ElasticSerializableBinaryTVList(String queryId, float memoryLimitInMB, int cacheSize) {
        super(TSDataType.TEXT, queryId, memoryLimitInMB, cacheSize);
    }

    @Override
    public void putBinary(long timestamp, Binary value) throws IOException {
        super.putBinary(timestamp, value);
        this.totalByteArrayLengthLimit += (long)this.byteArrayLengthForMemoryControl;
        this.totalByteArrayLength += (long)value.getLength();
        this.checkMemoryUsage();
    }

    @Override
    public void putString(long timestamp, String value) throws IOException {
        org.apache.iotdb.tsfile.utils.Binary binary = org.apache.iotdb.tsfile.utils.Binary.valueOf((String)value);
        super.putBinary(timestamp, UDFBinaryTransformer.transformToUDFBinary((org.apache.iotdb.tsfile.utils.Binary)binary));
        this.totalByteArrayLengthLimit += (long)this.byteArrayLengthForMemoryControl;
        this.totalByteArrayLength += (long)binary.getLength();
        this.checkMemoryUsage();
    }

    protected void checkMemoryUsage() throws IOException {
        if (this.size % 1000 != 0 || this.totalByteArrayLength <= this.totalByteArrayLengthLimit) {
            return;
        }
        int newByteArrayLengthForMemoryControl = this.byteArrayLengthForMemoryControl;
        while ((long)newByteArrayLengthForMemoryControl * (long)this.size < this.totalByteArrayLength) {
            newByteArrayLengthForMemoryControl *= 2;
        }
        int newInternalTVListCapacity = SerializableBinaryTVList.calculateCapacity(this.memoryLimitInMB, newByteArrayLengthForMemoryControl) / this.cacheSize;
        if (0 < newInternalTVListCapacity) {
            this.applyNewMemoryControlParameters(newByteArrayLengthForMemoryControl, newInternalTVListCapacity);
            return;
        }
        int delta = (int)((this.totalByteArrayLength - this.totalByteArrayLengthLimit) / (long)this.size / (long)SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL);
        newByteArrayLengthForMemoryControl = this.byteArrayLengthForMemoryControl + 2 * (delta + 1) * SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL;
        newInternalTVListCapacity = SerializableBinaryTVList.calculateCapacity(this.memoryLimitInMB, newByteArrayLengthForMemoryControl) / this.cacheSize;
        if (0 < newInternalTVListCapacity) {
            this.applyNewMemoryControlParameters(newByteArrayLengthForMemoryControl, newInternalTVListCapacity);
            return;
        }
        throw new RuntimeException("Memory is not enough for current query.");
    }

    protected void applyNewMemoryControlParameters(int newByteArrayLengthForMemoryControl, int newInternalTVListCapacity) throws IOException {
        int i;
        ElasticSerializableTVList newElasticSerializableTVList = new ElasticSerializableTVList(TSDataType.TEXT, this.queryId, this.memoryLimitInMB, newInternalTVListCapacity, this.cacheSize);
        newElasticSerializableTVList.evictionUpperBound = this.evictionUpperBound;
        int internalListEvictionUpperBound = this.evictionUpperBound / newInternalTVListCapacity;
        for (int i2 = 0; i2 < internalListEvictionUpperBound; ++i2) {
            newElasticSerializableTVList.tvLists.add(null);
            newElasticSerializableTVList.bitMaps.add(null);
        }
        newElasticSerializableTVList.size = internalListEvictionUpperBound * newInternalTVListCapacity;
        org.apache.iotdb.tsfile.utils.Binary empty = org.apache.iotdb.tsfile.utils.Binary.valueOf((String)"");
        for (i = newElasticSerializableTVList.size; i < this.evictionUpperBound; ++i) {
            newElasticSerializableTVList.putBinary(i, UDFBinaryTransformer.transformToUDFBinary((org.apache.iotdb.tsfile.utils.Binary)empty));
        }
        for (i = this.evictionUpperBound; i < this.size; ++i) {
            if (this.isNull(i)) {
                newElasticSerializableTVList.putNull(this.getTime(i));
                continue;
            }
            newElasticSerializableTVList.putBinary(this.getTime(i), UDFBinaryTransformer.transformToUDFBinary((org.apache.iotdb.tsfile.utils.Binary)this.getBinary(i)));
        }
        this.internalTVListCapacity = newInternalTVListCapacity;
        this.cache = newElasticSerializableTVList.cache;
        this.tvLists = newElasticSerializableTVList.tvLists;
        this.bitMaps = newElasticSerializableTVList.bitMaps;
        this.byteArrayLengthForMemoryControl = newByteArrayLengthForMemoryControl;
        this.totalByteArrayLengthLimit = (long)this.size * (long)this.byteArrayLengthForMemoryControl;
    }
}

