/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.literal;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.statement.literal.Literal;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LongLiteral
extends Literal {
    private final long value;

    public LongLiteral(String value) {
        this.value = Long.parseLong(value);
    }

    public LongLiteral(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)Literal.LiteralType.LONG.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.value, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)Literal.LiteralType.LONG.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.value, (OutputStream)stream);
    }

    @Override
    public boolean isDataTypeConsistency(TSDataType dataType) {
        if (dataType == TSDataType.INT32) {
            try {
                Math.toIntExact(this.value);
                return true;
            }
            catch (ArithmeticException e) {
                return false;
            }
        }
        return dataType == TSDataType.INT64 || dataType == TSDataType.FLOAT || dataType == TSDataType.DOUBLE || dataType == TSDataType.TEXT;
    }

    @Override
    public String getDataTypeString() {
        return TSDataType.INT64.toString();
    }

    @Override
    public int getInt() {
        return Math.toIntExact(this.value);
    }

    @Override
    public long getLong() {
        return this.getValue();
    }

    @Override
    public float getFloat() {
        return this.getValue();
    }

    @Override
    public double getDouble() {
        return this.getValue();
    }

    @Override
    public Binary getBinary() {
        return new Binary(String.valueOf(this.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongLiteral that = (LongLiteral)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

