/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.component;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.analyze.SelectIntoUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.IntoItem;

public class IntoComponent
extends StatementNode {
    public static final String PLACEHOLDER_MISMATCH_ERROR_MSG = "select into: the correspondence between the placeholder and the raw time series could not be established.";
    public static final String FORBID_PLACEHOLDER_ERROR_MSG = "select into: placeholders can only be used in raw time series data queries.";
    public static final String DEVICE_NUM_MISMATCH_ERROR_MSG = "select into: the number of source devices and the number of target devices should be the same.";
    public static final String PATH_NUM_MISMATCH_ERROR_MSG = "select into: the number of source columns and the number of target paths should be the same.";
    public static final String DUPLICATE_TARGET_PATH_ERROR_MSG = "select into: target paths in into clause should be different.";
    public static final String DEVICE_ALIGNMENT_INCONSISTENT_ERROR_MSG = "select into: alignment property must be the same for the same device.";
    private final List<IntoItem> intoItems;

    public IntoComponent(List<IntoItem> intoItems) {
        this.intoItems = intoItems;
    }

    public boolean isDeviceExistPlaceholder() {
        for (IntoItem intoItem : this.intoItems) {
            if (!intoItem.isDeviceExistPlaceholder()) continue;
            return true;
        }
        return false;
    }

    public boolean isMeasurementsExistPlaceholder() {
        for (IntoItem intoItem : this.intoItems) {
            if (!intoItem.isMeasurementsExistPlaceholder()) continue;
            return true;
        }
        return false;
    }

    public void validate(List<Expression> sourceColumns) {
        boolean isAllRawSeriesQuery = SelectIntoUtils.checkIsAllRawSeriesQuery(sourceColumns);
        if (!isAllRawSeriesQuery && (this.isDeviceExistPlaceholder() || this.isMeasurementsExistPlaceholder())) {
            throw new SemanticException(FORBID_PLACEHOLDER_ERROR_MSG);
        }
        if (this.isMeasurementsExistPlaceholder()) {
            for (IntoItem intoItem : this.intoItems) {
                if (intoItem.getIntoMeasurements().size() == 1) continue;
                throw new SemanticException(PLACEHOLDER_MISMATCH_ERROR_MSG);
            }
            if (this.isDeviceExistPlaceholder() ? this.intoItems.size() != 1 : this.intoItems.size() != 1 && this.intoItems.size() != sourceColumns.size()) {
                throw new SemanticException(PLACEHOLDER_MISMATCH_ERROR_MSG);
            }
        } else {
            int intoPathsNum = this.intoItems.stream().mapToInt(item -> item.getIntoMeasurements().size()).sum();
            if (intoPathsNum != sourceColumns.size()) {
                throw new SemanticException(PATH_NUM_MISMATCH_ERROR_MSG);
            }
        }
    }

    public IntoPathIterator getIntoPathIterator() {
        return new IntoPathIterator(this.intoItems, this.isDeviceExistPlaceholder(), this.isMeasurementsExistPlaceholder());
    }

    public void validate(List<PartialPath> sourceDevices, List<Expression> sourceColumns) {
        boolean isAllRawSeriesQuery = SelectIntoUtils.checkIsAllRawSeriesQuery(sourceColumns);
        if (!isAllRawSeriesQuery && this.isMeasurementsExistPlaceholder()) {
            throw new SemanticException(FORBID_PLACEHOLDER_ERROR_MSG);
        }
        if (this.isDeviceExistPlaceholder()) {
            if (this.intoItems.size() != 1) {
                throw new SemanticException(PLACEHOLDER_MISMATCH_ERROR_MSG);
            }
        } else if (this.intoItems.size() != sourceDevices.size()) {
            throw new SemanticException(DEVICE_NUM_MISMATCH_ERROR_MSG);
        }
        for (IntoItem intoItem : this.intoItems) {
            List<String> intoMeasurements = intoItem.getIntoMeasurements();
            if (intoItem.isMeasurementsExistPlaceholder()) {
                if (intoMeasurements.size() == 1) continue;
                throw new SemanticException(PLACEHOLDER_MISMATCH_ERROR_MSG);
            }
            if (intoMeasurements.size() == sourceColumns.size()) continue;
            throw new SemanticException(PATH_NUM_MISMATCH_ERROR_MSG);
        }
    }

    public IntoDeviceMeasurementIterator getIntoDeviceMeasurementIterator() {
        return new IntoDeviceMeasurementIterator(this.intoItems, this.isDeviceExistPlaceholder(), this.isMeasurementsExistPlaceholder());
    }

    public String toSQLString() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("INTO ");
        for (int i = 0; i < this.intoItems.size(); ++i) {
            sqlBuilder.append(this.intoItems.get(i).toSQLString());
            if (i >= this.intoItems.size() - 1) continue;
            sqlBuilder.append(", ");
        }
        return sqlBuilder.toString();
    }

    public static abstract class AbstractIntoIterator {
        protected final List<IntoItem> intoItems;
        protected final boolean isDeviceExistPlaceholder;
        protected final boolean isMeasurementsExistPlaceholder;
        protected int deviceIndex;
        protected int measurementIndex;

        protected AbstractIntoIterator(List<IntoItem> intoItems, boolean isDeviceExistPlaceholder, boolean isMeasurementsExistPlaceholder) {
            this.intoItems = intoItems;
            this.isDeviceExistPlaceholder = isDeviceExistPlaceholder;
            this.isMeasurementsExistPlaceholder = isMeasurementsExistPlaceholder;
            this.deviceIndex = 0;
            this.measurementIndex = 0;
        }

        public PartialPath getDeviceTemplate() {
            return this.intoItems.get(this.deviceIndex).getIntoDevice();
        }

        public String getMeasurementTemplate() {
            return this.intoItems.get(this.deviceIndex).getIntoMeasurements().get(this.measurementIndex);
        }

        public boolean isAlignedDevice() {
            return this.intoItems.get(this.deviceIndex).isAligned();
        }
    }

    public static class IntoDeviceMeasurementIterator
    extends AbstractIntoIterator {
        public IntoDeviceMeasurementIterator(List<IntoItem> intoItems, boolean isDeviceExistPlaceholder, boolean isMeasurementsExistPlaceholder) {
            super(intoItems, isDeviceExistPlaceholder, isMeasurementsExistPlaceholder);
        }

        public void nextDevice() {
            if (!this.isDeviceExistPlaceholder) {
                ++this.deviceIndex;
                this.measurementIndex = 0;
            }
        }

        public void nextMeasurement() {
            if (!((IntoItem)this.intoItems.get(this.deviceIndex)).isMeasurementsExistPlaceholder()) {
                ++this.measurementIndex;
                if (this.measurementIndex == ((IntoItem)this.intoItems.get(this.deviceIndex)).getIntoMeasurements().size()) {
                    this.measurementIndex = 0;
                }
            }
        }
    }

    public static class IntoPathIterator
    extends AbstractIntoIterator {
        public IntoPathIterator(List<IntoItem> intoItems, boolean isDeviceExistPlaceholder, boolean isMeasurementsExistPlaceholder) {
            super(intoItems, isDeviceExistPlaceholder, isMeasurementsExistPlaceholder);
        }

        public void next() {
            if (this.isMeasurementsExistPlaceholder) {
                if (!this.isDeviceExistPlaceholder && this.intoItems.size() > 1) {
                    ++this.deviceIndex;
                }
            } else {
                ++this.measurementIndex;
                if (this.measurementIndex == ((IntoItem)this.intoItems.get(this.deviceIndex)).getIntoMeasurements().size()) {
                    ++this.deviceIndex;
                    this.measurementIndex = 0;
                }
            }
        }
    }
}

