/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.AlignedDescPriorityMergeReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.AlignedPriorityMergeReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.DescPriorityMergeReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.PriorityMergeReader;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class AlignedSeriesScanUtil
extends SeriesScanUtil {
    private final List<TSDataType> dataTypes;

    public AlignedSeriesScanUtil(PartialPath seriesPath, Ordering scanOrder, SeriesScanOptions scanOptions, FragmentInstanceContext context) {
        super(seriesPath, scanOrder, scanOptions, context);
        this.dataTypes = ((AlignedPath)seriesPath).getSchemaList().stream().map(IMeasurementSchema::getType).collect(Collectors.toList());
        this.isAligned = true;
    }

    @Override
    protected Statistics currentFileStatistics(int index) {
        return ((AlignedTimeSeriesMetadata)this.firstTimeSeriesMetadata).getStatistics(index);
    }

    @Override
    protected Statistics currentFileTimeStatistics() {
        return ((AlignedTimeSeriesMetadata)this.firstTimeSeriesMetadata).getTimeStatistics();
    }

    @Override
    protected Statistics currentChunkStatistics(int index) {
        return ((AlignedChunkMetadata)this.firstChunkMetadata).getStatistics(index);
    }

    @Override
    protected Statistics currentChunkTimeStatistics() {
        return ((AlignedChunkMetadata)this.firstChunkMetadata).getTimeStatistics();
    }

    @Override
    protected Statistics currentPageStatistics(int index) throws IOException {
        if (this.firstPageReader == null) {
            return null;
        }
        return this.firstPageReader.getStatistics(index);
    }

    @Override
    protected Statistics currentPageTimeStatistics() throws IOException {
        if (this.firstPageReader == null) {
            return null;
        }
        return this.firstPageReader.getTimeStatistics();
    }

    @Override
    protected PriorityMergeReader getPriorityMergeReader() {
        return new AlignedPriorityMergeReader();
    }

    @Override
    protected DescPriorityMergeReader getDescPriorityMergeReader() {
        return new AlignedDescPriorityMergeReader();
    }

    protected AlignedTimeSeriesMetadata loadTimeSeriesMetadata(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter filter, Set<String> allSensors) throws IOException {
        return FileLoaderUtils.loadTimeSeriesMetadata(resource, (AlignedPath)seriesPath, context, filter);
    }

    @Override
    protected List<TSDataType> getTsDataTypeList() {
        return this.dataTypes;
    }

    @Override
    protected IPointReader getPointReader(TsBlock tsBlock) {
        return tsBlock.getTsBlockAlignedRowIterator();
    }

    @Override
    protected void filterFirstTimeSeriesMetadata() throws IOException {
        if (this.firstTimeSeriesMetadata != null && !this.isFileOverlapped() && !this.firstTimeSeriesMetadata.isModified()) {
            Filter queryFilter = this.scanOptions.getQueryFilter();
            if (queryFilter != null) {
                if (!queryFilter.satisfy(this.firstTimeSeriesMetadata.getStatistics())) {
                    this.skipCurrentFile();
                }
            } else {
                this.skipOffsetByTimeSeriesMetadata();
            }
        }
    }

    private void skipOffsetByTimeSeriesMetadata() {
        long rowCount = ((AlignedTimeSeriesMetadata)this.firstTimeSeriesMetadata).getTimeStatistics().getCount();
        for (Statistics statistics : ((AlignedTimeSeriesMetadata)this.firstTimeSeriesMetadata).getValueStatisticsList()) {
            if (statistics != null && !statistics.hasNullValue(rowCount)) continue;
            return;
        }
        if (this.paginationController.hasCurOffset(rowCount)) {
            this.skipCurrentFile();
            this.paginationController.consumeOffset(rowCount);
        }
    }

    @Override
    protected void filterFirstChunkMetadata() throws IOException {
        if (this.firstChunkMetadata != null && !this.isChunkOverlapped() && !this.firstChunkMetadata.isModified()) {
            Filter queryFilter = this.scanOptions.getQueryFilter();
            if (queryFilter != null) {
                if (!queryFilter.satisfy(this.firstChunkMetadata.getStatistics())) {
                    this.skipCurrentChunk();
                }
            } else {
                this.skipOffsetByChunkMetadata();
            }
        }
    }

    private void skipOffsetByChunkMetadata() {
        long rowCount = this.firstChunkMetadata.getStatistics().getCount();
        for (Statistics statistics : ((AlignedChunkMetadata)this.firstChunkMetadata).getValueStatisticsList()) {
            if (statistics != null && !statistics.hasNullValue(rowCount)) continue;
            return;
        }
        if (this.paginationController.hasCurOffset(rowCount)) {
            this.skipCurrentChunk();
            this.paginationController.consumeOffset(rowCount);
        }
    }
}

