/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async;

import java.util.Comparator;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferHandshakeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletReq;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.IoTDBThriftConnector;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferInsertNodeTabletInsertionEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferRawTabletInsertionEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTsFileInsertionEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.sync.IoTDBThriftSyncConnector;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBThriftAsyncConnector
extends IoTDBThriftConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBThriftAsyncConnector.class);
    private static final String FAILED_TO_BORROW_CLIENT_FORMATTER = "Failed to borrow client from client pool for receiver %s:%s.";
    private static final AtomicReference<IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient>> ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER = new AtomicReference();
    private final IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient> asyncPipeDataTransferClientManager;
    private static final AtomicReference<ScheduledExecutorService> RETRY_TRIGGER = new AtomicReference();
    private static final int RETRY_TRIGGER_INTERVAL_MINUTES = 1;
    private final AtomicReference<Future<?>> retryTriggerFuture = new AtomicReference();
    private final IoTDBThriftSyncConnector retryConnector = new IoTDBThriftSyncConnector();
    private final PriorityQueue<Pair<Long, Event>> retryEventQueue = new PriorityQueue<Pair>(Comparator.comparing(o -> (Long)o.left));
    private final AtomicLong commitIdGenerator = new AtomicLong(0L);
    private final AtomicLong lastCommitId = new AtomicLong(0L);
    private final PriorityQueue<Pair<Long, Runnable>> commitQueue = new PriorityQueue<Pair>(Comparator.comparing(o -> (Long)o.left));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public IoTDBThriftAsyncConnector() {
        if (ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.get() == null) {
            Class<IoTDBThriftAsyncConnector> clazz = IoTDBThriftAsyncConnector.class;
            // MONITORENTER : org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBThriftAsyncConnector.class
            if (ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.get() == null) {
                ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.set((IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient>)new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.AsyncPipeDataTransferServiceClientPoolFactory()));
            }
            // MONITOREXIT : clazz
        }
        this.asyncPipeDataTransferClientManager = ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.get();
    }

    @Override
    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        this.retryConnector.validate(validator);
    }

    @Override
    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        this.retryConnector.customize(parameters, configuration);
    }

    public synchronized void handshake() throws Exception {
        this.retryConnector.handshake();
    }

    public void heartbeat() {
        this.retryConnector.heartbeat();
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        this.transferQueuedEventsIfNecessary();
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Current event: {}.", (Object)tabletInsertionEvent);
            return;
        }
        long requestCommitId = this.commitIdGenerator.incrementAndGet();
        if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent;
            PipeTransferInsertNodeReq pipeTransferInsertNodeReq = PipeTransferInsertNodeReq.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getInsertNode());
            PipeTransferInsertNodeTabletInsertionEventHandler pipeTransferInsertNodeReqHandler = new PipeTransferInsertNodeTabletInsertionEventHandler(requestCommitId, pipeInsertNodeTabletInsertionEvent, (TPipeTransferReq)pipeTransferInsertNodeReq, this);
            this.transfer(requestCommitId, pipeTransferInsertNodeReqHandler);
        } else {
            PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent = (PipeRawTabletInsertionEvent)tabletInsertionEvent;
            PipeTransferTabletReq pipeTransferTabletReq = PipeTransferTabletReq.toTPipeTransferReq(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned());
            PipeTransferRawTabletInsertionEventHandler pipeTransferTabletReqHandler = new PipeTransferRawTabletInsertionEventHandler(requestCommitId, pipeRawTabletInsertionEvent, (TPipeTransferReq)pipeTransferTabletReq, this);
            this.transfer(requestCommitId, pipeTransferTabletReqHandler);
        }
    }

    private void transfer(long requestCommitId, PipeTransferInsertNodeTabletInsertionEventHandler pipeTransferInsertNodeReqHandler) {
        TEndPoint targetNodeUrl = (TEndPoint)this.nodeUrls.get((int)(requestCommitId % (long)this.nodeUrls.size()));
        try {
            AsyncPipeDataTransferServiceClient client = this.borrowClient(targetNodeUrl);
            try {
                pipeTransferInsertNodeReqHandler.transfer(client);
            }
            catch (TException e) {
                LOGGER.warn(String.format("Transfer insert node to receiver %s:%s error, retrying...", targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)e);
            }
        }
        catch (Exception ex) {
            pipeTransferInsertNodeReqHandler.onError(ex);
            LOGGER.warn(String.format(FAILED_TO_BORROW_CLIENT_FORMATTER, targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)ex);
        }
    }

    private void transfer(long requestCommitId, PipeTransferRawTabletInsertionEventHandler pipeTransferTabletReqHandler) {
        TEndPoint targetNodeUrl = (TEndPoint)this.nodeUrls.get((int)(requestCommitId % (long)this.nodeUrls.size()));
        try {
            AsyncPipeDataTransferServiceClient client = this.borrowClient(targetNodeUrl);
            try {
                pipeTransferTabletReqHandler.transfer(client);
            }
            catch (TException e) {
                LOGGER.warn(String.format("Transfer tablet to receiver %s:%s error, retrying...", targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)e);
            }
        }
        catch (Exception ex) {
            pipeTransferTabletReqHandler.onError(ex);
            LOGGER.warn(String.format(FAILED_TO_BORROW_CLIENT_FORMATTER, targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)ex);
        }
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        this.transferQueuedEventsIfNecessary();
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector only support PipeTsFileInsertionEvent. Current event: {}.", (Object)tsFileInsertionEvent);
            return;
        }
        long requestCommitId = this.commitIdGenerator.incrementAndGet();
        PipeTsFileInsertionEvent pipeTsFileInsertionEvent = (PipeTsFileInsertionEvent)tsFileInsertionEvent;
        PipeTransferTsFileInsertionEventHandler pipeTransferTsFileInsertionEventHandler = new PipeTransferTsFileInsertionEventHandler(requestCommitId, pipeTsFileInsertionEvent, this);
        pipeTsFileInsertionEvent.waitForTsFileClose();
        this.transfer(requestCommitId, pipeTransferTsFileInsertionEventHandler);
    }

    private void transfer(long requestCommitId, PipeTransferTsFileInsertionEventHandler pipeTransferTsFileInsertionEventHandler) {
        TEndPoint targetNodeUrl = (TEndPoint)this.nodeUrls.get((int)(requestCommitId % (long)this.nodeUrls.size()));
        try {
            AsyncPipeDataTransferServiceClient client = this.borrowClient(targetNodeUrl);
            try {
                pipeTransferTsFileInsertionEventHandler.transfer(client);
            }
            catch (TException e) {
                LOGGER.warn(String.format("Transfer tsfile to receiver %s:%s error, retrying...", targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)e);
            }
        }
        catch (Exception ex) {
            pipeTransferTsFileInsertionEventHandler.onError(ex);
            LOGGER.warn(String.format(FAILED_TO_BORROW_CLIENT_FORMATTER, targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)ex);
        }
    }

    public void transfer(Event event) throws Exception {
        this.transferQueuedEventsIfNecessary();
        LOGGER.warn("IoTDBThriftAsyncConnector does not support transfer generic event: {}.", (Object)event);
    }

    private AsyncPipeDataTransferServiceClient borrowClient(TEndPoint targetNodeUrl) throws PipeConnectionException {
        try {
            AsyncPipeDataTransferServiceClient client;
            while (!this.handshakeIfNecessary(targetNodeUrl, client = (AsyncPipeDataTransferServiceClient)this.asyncPipeDataTransferClientManager.borrowClient((Object)targetNodeUrl))) {
            }
            return client;
        }
        catch (Exception e) {
            throw new PipeConnectionException(String.format(FAILED_TO_BORROW_CLIENT_FORMATTER, targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)e);
        }
    }

    private boolean handshakeIfNecessary(final TEndPoint targetNodeUrl, final AsyncPipeDataTransferServiceClient client) throws Exception {
        if (client.isHandshakeFinished()) {
            return true;
        }
        final AtomicBoolean isHandshakeFinished = new AtomicBoolean(false);
        final AtomicReference exception = new AtomicReference();
        client.pipeTransfer((TPipeTransferReq)PipeTransferHandshakeReq.toTPipeTransferReq(CommonDescriptor.getInstance().getConfig().getTimestampPrecision()), (AsyncMethodCallback)new AsyncMethodCallback<TPipeTransferResp>(){

            public void onComplete(TPipeTransferResp response) {
                if (response.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    LOGGER.warn("Handshake error with receiver {}:{}, code: {}, message: {}.", new Object[]{targetNodeUrl.getIp(), targetNodeUrl.getPort(), response.getStatus().getCode(), response.getStatus().getMessage()});
                    exception.set(new PipeConnectionException(String.format("Handshake error with receiver %s:%s, code: %d, message: %s.", targetNodeUrl.getIp(), targetNodeUrl.getPort(), response.getStatus().getCode(), response.getStatus().getMessage())));
                } else {
                    LOGGER.info("Handshake successfully with receiver {}:{}.", (Object)targetNodeUrl.getIp(), (Object)targetNodeUrl.getPort());
                    client.markHandshakeFinished();
                }
                isHandshakeFinished.set(true);
            }

            public void onError(Exception e) {
                LOGGER.warn("Handshake error with receiver {}:{}.", new Object[]{targetNodeUrl.getIp(), targetNodeUrl.getPort(), e});
                exception.set(e);
                isHandshakeFinished.set(true);
            }
        });
        try {
            while (!isHandshakeFinished.get()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PipeException("Interrupted while waiting for handshake response.", (Throwable)e);
        }
        if (exception.get() != null) {
            throw new PipeConnectionException("Failed to handshake.", (Throwable)exception.get());
        }
        return false;
    }

    private synchronized void transferQueuedEventsIfNecessary() throws Exception {
        while (!this.retryEventQueue.isEmpty()) {
            Pair<Long, Event> queuedEventPair = this.retryEventQueue.peek();
            long requestCommitId = (Long)queuedEventPair.getLeft();
            Event event = (Event)queuedEventPair.getRight();
            if (event instanceof PipeInsertNodeTabletInsertionEvent) {
                this.retryConnector.transfer((PipeInsertNodeTabletInsertionEvent)event);
            } else if (event instanceof PipeRawTabletInsertionEvent) {
                this.retryConnector.transfer((PipeRawTabletInsertionEvent)event);
            } else if (event instanceof PipeTsFileInsertionEvent) {
                this.retryConnector.transfer((PipeTsFileInsertionEvent)event);
            } else {
                LOGGER.warn("IoTDBThriftAsyncConnector does not support transfer generic event: {}.", (Object)event);
            }
            if (event instanceof EnrichedEvent) {
                this.commit(requestCommitId, (EnrichedEvent)event);
            }
            this.retryEventQueue.poll();
        }
    }

    public synchronized void commit(long requestCommitId, @Nullable EnrichedEvent enrichedEvent) {
        this.commitQueue.offer((Pair<Long, Runnable>)new Pair((Object)requestCommitId, () -> Optional.ofNullable(enrichedEvent).ifPresent(event -> event.decreaseReferenceCount(IoTDBThriftAsyncConnector.class.getName()))));
        while (!this.commitQueue.isEmpty()) {
            Pair<Long, Runnable> committer = this.commitQueue.peek();
            if (this.lastCommitId.get() + 1L != (Long)committer.left) break;
            ((Runnable)committer.right).run();
            this.lastCommitId.incrementAndGet();
            this.commitQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addFailureEventToRetryQueue(long requestCommitId, Event event) {
        Class<IoTDBThriftAsyncConnector> clazz;
        if (RETRY_TRIGGER.get() == null) {
            clazz = IoTDBThriftAsyncConnector.class;
            // MONITORENTER : org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBThriftAsyncConnector.class
            if (RETRY_TRIGGER.get() == null) {
                RETRY_TRIGGER.set(IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.PIPE_ASYNC_CONNECTOR_RETRY_TRIGGER.getName()));
            }
            // MONITOREXIT : clazz
        }
        if (this.retryTriggerFuture.get() == null) {
            clazz = IoTDBThriftAsyncConnector.class;
            // MONITORENTER : org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBThriftAsyncConnector.class
            if (this.retryTriggerFuture.get() == null) {
                this.retryTriggerFuture.set(ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)RETRY_TRIGGER.get(), () -> {
                    try {
                        this.transferQueuedEventsIfNecessary();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to trigger retry.", (Throwable)e);
                    }
                }, (long)1L, (long)1L, (TimeUnit)TimeUnit.MINUTES));
            }
            // MONITOREXIT : clazz
        }
        this.retryEventQueue.offer((Pair<Long, Event>)new Pair((Object)requestCommitId, (Object)event));
    }

    public synchronized void close() throws Exception {
        if (this.retryTriggerFuture.get() != null) {
            this.retryTriggerFuture.get().cancel(false);
        }
        this.retryConnector.close();
    }
}

