/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.PipeRequestType;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.IoTDBThriftConnectorRequestVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferHandshakeReq
extends TPipeTransferReq {
    private String timestampPrecision;

    private PipeTransferHandshakeReq() {
    }

    public String getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public static PipeTransferHandshakeReq toTPipeTransferReq(String timestampPrecision) throws IOException {
        PipeTransferHandshakeReq handshakeReq = new PipeTransferHandshakeReq();
        handshakeReq.timestampPrecision = timestampPrecision;
        handshakeReq.version = IoTDBThriftConnectorRequestVersion.VERSION_1.getVersion();
        handshakeReq.type = PipeRequestType.HANDSHAKE.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((String)timestampPrecision, (OutputStream)outputStream);
            handshakeReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return handshakeReq;
    }

    public static PipeTransferHandshakeReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferHandshakeReq handshakeReq = new PipeTransferHandshakeReq();
        handshakeReq.timestampPrecision = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
        handshakeReq.version = transferReq.version;
        handshakeReq.type = transferReq.type;
        handshakeReq.body = transferReq.body;
        return handshakeReq;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferHandshakeReq that = (PipeTransferHandshakeReq)((Object)obj);
        return this.timestampPrecision.equals(that.timestampPrecision) && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.timestampPrecision, this.version, this.type, this.body);
    }
}

