/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.logdispatcher;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.consensus.iot.logdispatcher.LogDispatcher;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class LogDispatcherThreadMetrics
implements IMetricSet {
    private final LogDispatcher.LogDispatcherThread logDispatcherThread;
    private final String peerGroupId;
    private Histogram constructBatchHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram syncLogTimePerRequestHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;

    public LogDispatcherThreadMetrics(LogDispatcher.LogDispatcherThread logDispatcherThread) {
        this.logDispatcherThread = logDispatcherThread;
        this.peerGroupId = logDispatcherThread.getPeer().getGroupId().toString();
    }

    public void recordConstructBatchTime(long time) {
        this.constructBatchHistogram.update(time);
    }

    public void recordSyncLogTimePerRequest(long time) {
        this.syncLogTimePerRequestHistogram.update(time);
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindAutoGauge(metricService);
        this.bindStageHistogram(metricService);
    }

    private void bindAutoGauge(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.logDispatcherThread, LogDispatcher.LogDispatcherThread::getCurrentSyncIndex, new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "currentSyncIndex"});
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.logDispatcherThread, x -> x.getSyncStatus().getPendingBatches().size(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "pipelineNum"});
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.logDispatcherThread, x -> x.getPendingEntriesSize() + x.getBufferRequestSize(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "cachedRequestInMemoryQueue"});
    }

    private void bindStageHistogram(AbstractMetricService metricService) {
        this.constructBatchHistogram = metricService.getOrCreateHistogram(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "constructBatch", Tag.REGION.toString(), this.peerGroupId});
        this.syncLogTimePerRequestHistogram = metricService.getOrCreateHistogram(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "syncLogTimePerRequest", Tag.REGION.toString(), this.peerGroupId});
    }

    private void unbindStageHistogram(AbstractMetricService metricService) {
        metricService.remove(MetricType.HISTOGRAM, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "constructBatch", Tag.REGION.toString(), this.peerGroupId});
        metricService.remove(MetricType.HISTOGRAM, Metric.STAGE.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "syncLogTimePerRequest", Tag.REGION.toString(), this.peerGroupId});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindAutoGauge(metricService);
        this.unbindStageHistogram(metricService);
    }

    private void unbindAutoGauge(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "currentSyncIndex"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "pipelineNum"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "cachedRequestInMemoryQueue"});
    }

    private String formatName() {
        return String.format("logDispatcher-%s:%s", this.logDispatcherThread.getPeer().getEndpoint().getIp(), this.logDispatcherThread.getPeer().getEndpoint().getPort());
    }
}

