/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.ISubscriptionsRepository;
import io.moquette.broker.subscriptions.Subscription;
import java.util.HashSet;
import java.util.Set;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2SubscriptionsRepository
implements ISubscriptionsRepository {
    private static final Logger LOG = LoggerFactory.getLogger(H2SubscriptionsRepository.class);
    private static final String SUBSCRIPTIONS_MAP = "subscriptions";
    private MVMap<String, Subscription> subscriptions;

    H2SubscriptionsRepository(MVStore mvStore) {
        this.subscriptions = mvStore.openMap(SUBSCRIPTIONS_MAP);
    }

    @Override
    public Set<Subscription> listAllSubscriptions() {
        LOG.debug("Retrieving existing subscriptions");
        HashSet<Subscription> results = new HashSet<Subscription>();
        Cursor mapCursor = this.subscriptions.cursor(null);
        while (mapCursor.hasNext()) {
            String subscriptionStr = (String)mapCursor.next();
            results.add((Subscription)mapCursor.getValue());
        }
        LOG.debug("Loaded {} subscriptions", (Object)results.size());
        return results;
    }

    @Override
    public void addNewSubscription(Subscription subscription) {
        this.subscriptions.put((Object)(subscription.getTopicFilter() + "-" + subscription.getClientId()), (Object)subscription);
    }

    @Override
    public void removeSubscription(String topicFilter, String clientID) {
        this.subscriptions.remove((Object)(topicFilter + "-" + clientID));
    }
}

