/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TagFilter
extends SchemaFilter {
    private final String key;
    private final String value;
    private final boolean isContains;

    public TagFilter(String key, String value, boolean isContains) {
        this.key = key;
        this.value = value;
        this.isContains = isContains;
    }

    public TagFilter(ByteBuffer byteBuffer) {
        this.key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.isContains = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isContains() {
        return this.isContains;
    }

    @Override
    public <C> boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitTagFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.TAGS_FILTER;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.key, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.value, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isContains, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.key, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.value, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isContains, (OutputStream)stream);
    }
}

