/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SimpleProgressIndex
implements ProgressIndex {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final int rebootTimes;
    private final long memtableFlushOrderId;

    public SimpleProgressIndex(int rebootTimes, long memtableFlushOrderId) {
        this.rebootTimes = rebootTimes;
        this.memtableFlushOrderId = memtableFlushOrderId;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.SIMPLE_PROGRESS_INDEX.serialize(byteBuffer);
            ReadWriteIOUtils.write((int)this.rebootTimes, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((long)this.memtableFlushOrderId, (ByteBuffer)byteBuffer);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void serialize(OutputStream stream) throws IOException {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.SIMPLE_PROGRESS_INDEX.serialize(stream);
            ReadWriteIOUtils.write((int)this.rebootTimes, (OutputStream)stream);
            ReadWriteIOUtils.write((long)this.memtableFlushOrderId, (OutputStream)stream);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfter(ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (progressIndex instanceof MinimumProgressIndex) {
                boolean bl = true;
                return bl;
            }
            if (progressIndex instanceof HybridProgressIndex) {
                boolean bl = ((HybridProgressIndex)progressIndex).isGivenProgressIndexAfterSelf(this);
                return bl;
            }
            if (!(progressIndex instanceof SimpleProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            SimpleProgressIndex thisSimpleProgressIndex = this;
            SimpleProgressIndex thatSimpleProgressIndex = (SimpleProgressIndex)progressIndex;
            if (thisSimpleProgressIndex.rebootTimes > thatSimpleProgressIndex.rebootTimes) {
                boolean bl = true;
                return bl;
            }
            if (thisSimpleProgressIndex.rebootTimes < thatSimpleProgressIndex.rebootTimes) {
                boolean bl = false;
                return bl;
            }
            boolean bl = thisSimpleProgressIndex.memtableFlushOrderId > thatSimpleProgressIndex.memtableFlushOrderId;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (!(progressIndex instanceof SimpleProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            SimpleProgressIndex thisSimpleProgressIndex = this;
            SimpleProgressIndex thatSimpleProgressIndex = (SimpleProgressIndex)progressIndex;
            boolean bl = thisSimpleProgressIndex.rebootTimes == thatSimpleProgressIndex.rebootTimes && thisSimpleProgressIndex.memtableFlushOrderId == thatSimpleProgressIndex.memtableFlushOrderId;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleProgressIndex)) {
            return false;
        }
        return this.equals((SimpleProgressIndex)obj);
    }

    public int hashCode() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgressIndex updateToMinimumIsAfterProgressIndex(ProgressIndex progressIndex) {
        this.lock.writeLock().lock();
        try {
            if (!(progressIndex instanceof SimpleProgressIndex)) {
                ProgressIndex progressIndex2 = ProgressIndex.blendProgressIndex(this, progressIndex);
                return progressIndex2;
            }
            SimpleProgressIndex thisSimpleProgressIndex = this;
            SimpleProgressIndex thatSimpleProgressIndex = (SimpleProgressIndex)progressIndex;
            if (thisSimpleProgressIndex.rebootTimes > thatSimpleProgressIndex.rebootTimes) {
                SimpleProgressIndex simpleProgressIndex = this;
                return simpleProgressIndex;
            }
            if (thisSimpleProgressIndex.rebootTimes < thatSimpleProgressIndex.rebootTimes) {
                ProgressIndex progressIndex3 = progressIndex;
                return progressIndex3;
            }
            if (thisSimpleProgressIndex.memtableFlushOrderId > thatSimpleProgressIndex.memtableFlushOrderId) {
                SimpleProgressIndex simpleProgressIndex = this;
                return simpleProgressIndex;
            }
            if (thisSimpleProgressIndex.memtableFlushOrderId < thatSimpleProgressIndex.memtableFlushOrderId) {
                ProgressIndex progressIndex4 = progressIndex;
                return progressIndex4;
            }
            SimpleProgressIndex simpleProgressIndex = this;
            return simpleProgressIndex;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ProgressIndexType getType() {
        return ProgressIndexType.SIMPLE_PROGRESS_INDEX;
    }

    public static SimpleProgressIndex deserializeFrom(ByteBuffer byteBuffer) {
        int rebootTimes = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        long memtableFlushOrderId = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        return new SimpleProgressIndex(rebootTimes, memtableFlushOrderId);
    }

    public static SimpleProgressIndex deserializeFrom(InputStream stream) throws IOException {
        int rebootTimes = ReadWriteIOUtils.readInt((InputStream)stream);
        long memtableFlushOrderId = ReadWriteIOUtils.readLong((InputStream)stream);
        return new SimpleProgressIndex(rebootTimes, memtableFlushOrderId);
    }

    public String toString() {
        return "SimpleProgressIndex{rebootTimes=" + this.rebootTimes + ", memtableFlushOrderId=" + this.memtableFlushOrderId + '}';
    }
}

