/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.BitSet;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RegularDataEncoder
extends Encoder {
    protected static final int BLOCK_DEFAULT_SIZE = 128;
    private static final Logger LOGGER = LoggerFactory.getLogger(RegularDataEncoder.class);
    protected ByteArrayOutputStream out;
    protected int blockSize;
    protected boolean isMissingPoint;
    protected int writeIndex = -1;
    protected int dataTotal;

    protected RegularDataEncoder(int size) {
        super(TSEncoding.REGULAR);
        this.blockSize = size;
    }

    protected abstract void writeHeader() throws IOException;

    protected abstract void reset();

    protected abstract void checkMissingPoint(ByteArrayOutputStream var1) throws IOException;

    protected abstract void writeBitmap(ByteArrayOutputStream var1) throws IOException;

    protected void writeHeaderToBytes() throws IOException {
        this.out.write(BytesUtils.intToBytes(this.writeIndex));
        this.writeHeader();
    }

    protected void flushBlockBuffer(ByteArrayOutputStream out) throws IOException {
        if (this.writeIndex == -1) {
            return;
        }
        this.out = out;
        this.checkMissingPoint(out);
        out.write(BytesUtils.boolToBytes(this.isMissingPoint));
        if (this.isMissingPoint) {
            this.writeBitmap(out);
        }
        this.writeHeaderToBytes();
        this.reset();
        this.writeIndex = -1;
    }

    @Override
    public void flush(ByteArrayOutputStream out) {
        try {
            this.flushBlockBuffer(out);
        }
        catch (IOException e) {
            LOGGER.error("flush data to stream failed!", (Throwable)e);
        }
    }

    public static class LongRegularEncoder
    extends RegularDataEncoder {
        private long[] data;
        private long firstValue;
        private long previousValue;
        private long minDeltaBase;
        private int newBlockSize;
        private BitSet bitmap;

        public LongRegularEncoder() {
            this(128);
        }

        public LongRegularEncoder(int size) {
            super(size);
            this.reset();
        }

        @Override
        protected void reset() {
            this.minDeltaBase = Long.MAX_VALUE;
            this.isMissingPoint = false;
            this.firstValue = 0L;
            this.previousValue = 0L;
        }

        @Override
        protected void writeHeader() throws IOException {
            this.out.write(BytesUtils.longToBytes(this.minDeltaBase));
            this.out.write(BytesUtils.longToBytes(this.firstValue));
        }

        @Override
        public void encode(long value, ByteArrayOutputStream out) {
            try {
                this.encodeValue(value, out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int getOneItemMaxSize() {
            return 8;
        }

        @Override
        public long getMaxByteSize() {
            return 28L + (long)(this.writeIndex * 2 / 8) + (long)(this.writeIndex * 8);
        }

        @Override
        protected void checkMissingPoint(ByteArrayOutputStream out) throws IOException {
            if (this.writeIndex > 1) {
                this.previousValue = this.data[0];
                this.minDeltaBase = this.data[1] - this.data[0];
                for (int i = 1; i < this.writeIndex; ++i) {
                    long delta = this.data[i] - this.previousValue;
                    if (delta != this.minDeltaBase) {
                        this.isMissingPoint = true;
                    }
                    if (delta < this.minDeltaBase) {
                        this.minDeltaBase = delta;
                    }
                    this.previousValue = this.data[i];
                }
            }
            this.firstValue = this.data[0];
            if (this.isMissingPoint) {
                this.dataTotal = this.writeIndex;
                this.writeIndex = this.newBlockSize = (int)((this.data[this.writeIndex - 1] - this.data[0]) / this.minDeltaBase + 1L);
            }
        }

        @Override
        protected void writeBitmap(ByteArrayOutputStream out) throws IOException {
            this.data2Diff(this.data);
            byte[] bsArr = this.bitmap.toByteArray();
            out.write(BytesUtils.intToBytes(bsArr.length));
            out.write(bsArr);
        }

        public void encodeValue(long value, ByteArrayOutputStream out) throws IOException {
            if (this.writeIndex == -1) {
                this.data = new long[this.blockSize];
                this.writeIndex = 0;
            }
            this.data[this.writeIndex++] = value;
            if (this.writeIndex == this.blockSize) {
                this.flush(out);
            }
        }

        private void data2Diff(long[] missingPointData) {
            this.bitmap = new BitSet(this.newBlockSize);
            this.bitmap.flip(0, this.newBlockSize);
            int offset = 0;
            for (int i = 1; i < this.dataTotal; ++i) {
                long delta = missingPointData[i] - missingPointData[i - 1];
                if (delta == this.minDeltaBase) continue;
                int missingPointNum = (int)(delta / this.minDeltaBase) - 1;
                for (int j = 0; j < missingPointNum; ++j) {
                    this.bitmap.set(i + offset++, false);
                }
            }
        }
    }

    public static class IntRegularEncoder
    extends RegularDataEncoder {
        private int[] data;
        private int firstValue;
        private int previousValue;
        private int minDeltaBase;
        private int newBlockSize;
        private BitSet bitmap;

        public IntRegularEncoder() {
            this(128);
        }

        public IntRegularEncoder(int size) {
            super(size);
            this.reset();
        }

        @Override
        protected void reset() {
            this.minDeltaBase = Integer.MAX_VALUE;
            this.isMissingPoint = false;
            this.firstValue = 0;
            this.previousValue = 0;
        }

        @Override
        protected void writeHeader() throws IOException {
            this.out.write(BytesUtils.intToBytes(this.minDeltaBase));
            this.out.write(BytesUtils.intToBytes(this.firstValue));
        }

        @Override
        public void encode(int value, ByteArrayOutputStream out) {
            try {
                this.encodeValue(value, out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int getOneItemMaxSize() {
            return 4;
        }

        @Override
        public long getMaxByteSize() {
            return 20L + (long)(this.writeIndex * 2 / 8) + (long)(this.writeIndex * 4);
        }

        @Override
        protected void checkMissingPoint(ByteArrayOutputStream out) throws IOException {
            if (this.writeIndex > 1) {
                this.previousValue = this.data[0];
                this.minDeltaBase = this.data[1] - this.data[0];
                for (int i = 1; i < this.writeIndex; ++i) {
                    int delta = this.data[i] - this.previousValue;
                    if (delta != this.minDeltaBase) {
                        this.isMissingPoint = true;
                    }
                    if (delta < this.minDeltaBase) {
                        this.minDeltaBase = delta;
                    }
                    this.previousValue = this.data[i];
                }
            }
            this.firstValue = this.data[0];
            if (this.isMissingPoint) {
                this.dataTotal = this.writeIndex;
                this.writeIndex = this.newBlockSize = (this.data[this.writeIndex - 1] - this.data[0]) / this.minDeltaBase + 1;
            }
        }

        @Override
        protected void writeBitmap(ByteArrayOutputStream out) throws IOException {
            this.data2Diff(this.data);
            byte[] bsArr = this.bitmap.toByteArray();
            out.write(BytesUtils.intToBytes(bsArr.length));
            out.write(bsArr);
        }

        public void encodeValue(int value, ByteArrayOutputStream out) throws IOException {
            if (this.writeIndex == -1) {
                this.data = new int[this.blockSize];
                this.writeIndex = 0;
            }
            this.data[this.writeIndex++] = value;
            if (this.writeIndex == this.blockSize) {
                this.flush(out);
            }
        }

        private void data2Diff(int[] missingPointData) {
            this.bitmap = new BitSet(this.newBlockSize);
            this.bitmap.flip(0, this.newBlockSize);
            int offset = 0;
            for (int i = 1; i < this.dataTotal; ++i) {
                int delta = missingPointData[i] - missingPointData[i - 1];
                if (delta == this.minDeltaBase) continue;
                int missingPointNum = delta / this.minDeltaBase - 1;
                for (int j = 0; j < missingPointNum; ++j) {
                    this.bitmap.set(i + offset++, false);
                }
            }
        }
    }
}

