/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.frequency;

import java.util.ArrayList;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFDeconv
implements UDTF {
    private final ArrayList<Double> list1 = new ArrayList();
    private final ArrayList<Double> list2 = new ArrayList();
    private String result;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(2).validateInputSeriesDataType(0, Type.DOUBLE, Type.FLOAT, Type.INT32, Type.INT64).validateInputSeriesDataType(1, Type.DOUBLE, Type.FLOAT, Type.INT32, Type.INT64).validate(x -> ((String)x).equalsIgnoreCase("quotient") || ((String)x).equalsIgnoreCase("remainder"), "Result should be 'quotient' or 'remainder'.", (Object)validator.getParameters().getStringOrDefault("result", "quotient"));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.list1.clear();
        this.list2.clear();
        this.result = parameters.getStringOrDefault("result", "quotient");
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        if (!row.isNull(0) && Double.isFinite(Util.getValueAsDouble(row, 0))) {
            this.list1.add(Util.getValueAsDouble(row, 0));
        }
        if (!row.isNull(1) && Double.isFinite(Util.getValueAsDouble(row, 1))) {
            this.list2.add(Util.getValueAsDouble(row, 1));
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        if (this.list2.size() == 0) {
            throw new Exception("Divided by zero.");
        }
        if (this.list2.size() > this.list1.size()) {
            if (this.result.equalsIgnoreCase("quotient")) {
                collector.putDouble(0L, 0.0);
            } else {
                for (int i = 0; i < this.list1.size(); ++i) {
                    collector.putDouble(i, this.list1.get(i));
                }
            }
        } else {
            int i;
            double[] q = new double[this.list1.size() - this.list2.size() + 1];
            Double[] r = this.list1.toArray(new Double[0]);
            int m4 = this.list2.size() - 1;
            for (i = q.length - 1; i >= 0; --i) {
                q[i] = r[i + m4] / this.list2.get(m4);
                r[i + m4] = 0.0;
                for (int j = 0; j < m4; ++j) {
                    Double[] doubleArray = r;
                    int n = i + j;
                    Double.valueOf(doubleArray[n] - q[i] * this.list2.get(j));
                }
            }
            if (this.result.equalsIgnoreCase("quotient")) {
                for (i = 0; i < q.length; ++i) {
                    collector.putDouble(i, q[i]);
                }
            } else {
                for (i = 0; i < r.length; ++i) {
                    collector.putDouble(i, r[i]);
                }
            }
        }
    }
}

