/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair.util;

import org.apache.iotdb.library.drepair.util.ValueFill;
import org.apache.iotdb.udf.api.access.RowIterator;
import org.apache.iotdb.udf.api.exception.UDFException;

public class ARFill
extends ValueFill {
    private int order = 1;
    private double theta = 1.0E10;

    public ARFill(RowIterator dataIterator) throws Exception {
        super(dataIterator);
        this.calMeanAndVar();
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public void fill() throws UDFException {
        int i;
        double acf = 0.0;
        double factor = 0.0;
        int acf_cnt = 0;
        for (int i2 = 0; i2 < this.original.length - 1; ++i2) {
            double left = this.original[i2];
            double right = this.original[i2 + 1];
            if (Double.isNaN(left)) {
                left = 0.0;
            }
            if (Double.isNaN(right)) {
                right = 0.0;
            }
            acf += left * right;
            factor += left * left;
            ++acf_cnt;
        }
        if (factor == 0.0 || this.theta >= 1.0) {
            this.time = new long[]{0L};
            this.repaired = new double[]{0.0};
            throw new UDFException("Cannot fit AR(1) model. Please try another method.");
        }
        this.theta = acf / factor;
        double mean_epsilon = 0.0;
        double var_epsilon = 0.0;
        double cnt_epsilon = 0.0;
        for (i = 0; i < this.original.length - 1; ++i) {
            double left = this.original[i];
            double right = this.original[i + 1];
            if (Double.isNaN(left) || Double.isNaN(right)) continue;
            cnt_epsilon += 1.0;
            double epsilon = right - left * this.theta;
            mean_epsilon += epsilon;
            var_epsilon += epsilon * epsilon;
        }
        if (cnt_epsilon == 0.0) {
            this.time = new long[]{0L};
            this.repaired = new double[]{0.0};
            throw new UDFException("Cannot fit AR(1) model. Please try another method.");
        }
        mean_epsilon /= cnt_epsilon;
        var_epsilon /= cnt_epsilon;
        for (i = 0; i < this.original.length; ++i) {
            double yt = this.original[i];
            this.repaired[i] = !Double.isNaN(yt) ? yt : (i != 0 ? this.theta * this.repaired[i - 1] + mean_epsilon : this.mean);
        }
    }
}

