/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dquality;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.iotdb.library.dquality.UDTFCompleteness;
import org.apache.iotdb.library.dquality.util.TimeSeriesQuality;
import org.apache.iotdb.library.util.NoNumberException;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFValidity
implements UDTF {
    @Override
    public void beforeStart(UDFParameters udfp, UDTFConfigurations udtfc) throws Exception {
        boolean isTime = false;
        long window = Integer.MAX_VALUE;
        if (udfp.hasAttribute("window")) {
            String s2 = udfp.getString("window");
            window = Util.parseTime(s2);
            if (window > 0L) {
                isTime = true;
            } else {
                window = Long.parseLong(s2);
            }
        }
        if (isTime) {
            udtfc.setAccessStrategy(new SlidingTimeWindowAccessStrategy(window));
        } else {
            udtfc.setAccessStrategy(new SlidingSizeWindowAccessStrategy((int)window));
        }
        udtfc.setOutputDataType(Type.DOUBLE);
    }

    @Override
    public void transform(RowWindow rowWindow, PointCollector collector) throws Exception {
        try {
            if (rowWindow.windowSize() > 10) {
                TimeSeriesQuality tsq = new TimeSeriesQuality(rowWindow.getRowIterator());
                tsq.valueDetect();
                collector.putDouble(rowWindow.getRow(0).getTime(), tsq.getValidity());
            }
        }
        catch (IOException | NoNumberException ex) {
            Logger.getLogger(UDTFCompleteness.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

