/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import org.apache.iotdb.library.util.CircularQueue;
import org.apache.iotdb.library.util.DoubleCircularQueue;
import org.apache.iotdb.library.util.LongCircularQueue;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;

public class Resampler {
    private final LongArrayList timeWindow = new LongArrayList();
    private final DoubleArrayList valueWindow = new DoubleArrayList();
    private final LongCircularQueue waitList = new LongCircularQueue();
    private final CircularQueue<SourceDataPoint> source = new CircularQueue();
    private final LongCircularQueue timeBuffer = new LongCircularQueue();
    private final DoubleCircularQueue valueBuffer = new DoubleCircularQueue();
    private final long newPeriod;
    private final String aggregator;
    private final String interpolator;
    private long currentTime;
    private long startTime;
    private long endTime;
    private boolean outer = true;

    public Resampler(long newPeriod, String aggregator, String interpolator) {
        this(newPeriod, aggregator, interpolator, -1L, -1L);
    }

    public Resampler(long newPeriod, String aggregator, String interpolator, long startTime, long endTime) {
        this.newPeriod = newPeriod;
        this.aggregator = aggregator;
        this.interpolator = interpolator;
        this.startTime = startTime;
        this.endTime = endTime;
        this.currentTime = this.startTime;
    }

    public void insert(long time, double value) {
        if (Double.isNaN(value) || this.startTime > 0L && time < this.startTime || this.endTime > 0L && time >= this.endTime) {
            return;
        }
        if (this.currentTime < 0L) {
            this.currentTime = time;
        }
        while (time >= this.currentTime + this.newPeriod) {
            this.downSample();
            this.upSample();
            this.currentTime += this.newPeriod;
        }
        this.timeWindow.add(time);
        this.valueWindow.add(value);
    }

    public void flush() {
        do {
            this.downSample();
            this.currentTime += this.newPeriod;
        } while (this.endTime >= this.currentTime);
        this.outer = true;
        this.upSample();
    }

    private void upSample() {
        if (this.source.getSize() > 2 || this.outer && this.source.getSize() == 2) {
            if (this.source.getSize() > 2) {
                this.source.pop();
            }
            while (!this.waitList.isEmpty()) {
                long t2 = this.waitList.getHead();
                if (!this.outer && this.source.get((int)1).time < t2) break;
                if (this.endTime < 0L || t2 < this.endTime) {
                    this.timeBuffer.push(t2);
                    this.valueBuffer.push(this.interpolate(t2));
                }
                this.waitList.pop();
            }
            this.outer = false;
        }
    }

    private void downSample() {
        if (this.timeWindow.size() >= 2) {
            double result = this.aggregate();
            this.source.push(new SourceDataPoint(this.currentTime, result));
        } else if (this.timeWindow.size() == 1) {
            this.source.push(new SourceDataPoint(this.timeWindow.get(0), this.valueWindow.get(0)));
        }
        this.timeWindow.clear();
        this.valueWindow.clear();
        this.waitList.push(this.currentTime);
    }

    private double aggregate() {
        double ret;
        switch (this.aggregator) {
            case "min": {
                ret = this.valueWindow.min();
                break;
            }
            case "max": {
                ret = this.valueWindow.max();
                break;
            }
            case "mean": {
                ret = this.valueWindow.average();
                break;
            }
            case "median": {
                ret = this.valueWindow.median();
                break;
            }
            case "first": {
                ret = this.valueWindow.get(0);
                break;
            }
            case "last": {
                ret = this.valueWindow.get(this.valueWindow.size() - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Error: Illegal Aggregation Algorithm.");
            }
        }
        return ret;
    }

    private double interpolate(long t2) {
        if (t2 == this.source.get((int)1).time) {
            return this.source.get((int)1).value;
        }
        if (t2 == this.source.get((int)0).time) {
            return this.source.get((int)0).value;
        }
        double ret = Double.NaN;
        switch (this.interpolator) {
            case "nan": {
                ret = Double.NaN;
                break;
            }
            case "ffill": {
                if (t2 >= this.source.get((int)1).time) {
                    ret = this.source.get((int)1).value;
                    break;
                }
                if (t2 < this.source.get((int)0).time) break;
                ret = this.source.get((int)0).value;
                break;
            }
            case "bfill": {
                if (t2 <= this.source.get((int)0).time) {
                    ret = this.source.get((int)0).value;
                    break;
                }
                if (t2 > this.source.get((int)1).time) break;
                ret = this.source.get((int)1).value;
                break;
            }
            case "linear": {
                ret = this.source.get((int)0).value * (double)(this.source.get((int)1).time - t2) + this.source.get((int)1).value * (double)(t2 - this.source.get((int)0).time);
                ret /= (double)(this.source.get((int)1).time - this.source.get((int)0).time);
                break;
            }
            default: {
                throw new IllegalArgumentException("Error: Illegal Interpolation Algorithm.");
            }
        }
        return ret;
    }

    public boolean hasNext() {
        return !this.timeBuffer.isEmpty();
    }

    public long getOutTime() {
        return this.timeBuffer.getHead();
    }

    public double getOutValue() {
        return this.valueBuffer.getHead();
    }

    public void next() {
        this.timeBuffer.pop();
        this.valueBuffer.pop();
    }

    private class SourceDataPoint {
        long time;
        double value;

        public SourceDataPoint(long time, double value) {
            this.time = time;
            this.value = value;
        }
    }
}

