/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.iotdb.library.dprofile.util.Mad;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MADSketch {
    private long zero_count;
    private double beta;
    private final double[] valid_range;
    private final double alpha;
    private final double gamma;
    private final double multiplier;
    private final UnifiedMap<Integer, Long> positive_buckets;
    private final UnifiedMap<Integer, Long> negative_buckets;
    private static final double MIN_POSITIVE_VALUE = 1.0E-6;
    private static final Logger logger = LoggerFactory.getLogger(MADSketch.class);

    public MADSketch(double alpha) {
        this.alpha = alpha;
        this.gamma = 2.0 * alpha / (1.0 - alpha) + 1.0;
        this.multiplier = Math.log(Math.E) / Math.log1p(this.gamma - 1.0);
        this.beta = 1.0;
        this.positive_buckets = new UnifiedMap();
        this.negative_buckets = new UnifiedMap();
        this.zero_count = 0L;
        this.valid_range = new double[6];
    }

    public void insert(double v) {
        if (Double.isFinite(v)) {
            if (v > 1.0E-6) {
                int i = (int)Math.ceil(Math.log(v) * this.multiplier);
                this.positive_buckets.put(i, this.positive_buckets.getOrDefault(i, 0L) + 1L);
            } else if (v < -1.0E-6) {
                int i = (int)Math.ceil(Math.log(-v) * this.multiplier);
                this.negative_buckets.put(i, this.negative_buckets.getOrDefault(i, 0L) + 1L);
            } else {
                ++this.zero_count;
            }
        }
    }

    public void insert(double v, double[] bounds) {
        if (v < bounds[0]) {
            v = bounds[0];
        } else if (v > bounds[1] && v < bounds[2]) {
            v = bounds[2];
        } else if (v > bounds[3] && v < bounds[4]) {
            v = bounds[4];
        } else if (v > bounds[5]) {
            v = bounds[5];
        }
        this.insert(v);
    }

    private Bucket[] union_buckets() {
        Bucket[] buckets = new Bucket[this.sketch_size()];
        int i = 0;
        for (Map.Entry<Integer, Long> e : this.positive_buckets.entrySet()) {
            buckets[i++] = new Bucket(e.getKey(), Math.pow(this.gamma, (double)e.getKey().intValue() - 1.0), Math.pow(this.gamma, e.getKey().intValue()), e.getValue());
        }
        for (Map.Entry<Integer, Long> e : this.negative_buckets.entrySet()) {
            buckets[i++] = new Bucket(e.getKey(), -Math.pow(this.gamma, e.getKey().intValue()), -Math.pow(this.gamma, (double)e.getKey().intValue() - 1.0), e.getValue());
        }
        if (this.zero_count > 0L) {
            buckets[i] = new Bucket(0, 0.0, 0.0, this.zero_count);
        }
        Arrays.sort(buckets, Comparator.comparingDouble(o -> o.lower_bound));
        return buckets;
    }

    public long total_count() {
        return this.positive_buckets.values().stream().mapToLong(l -> l).sum() + this.negative_buckets.values().stream().mapToLong(l -> l).sum() + this.zero_count;
    }

    private int find_p_index(Bucket[] buckets, long total_count) {
        long count = 0L;
        double rank = 0.5 * (double)(total_count - 1L);
        for (int i = 0; i < buckets.length; ++i) {
            if (!((double)(count += buckets[i].count) > rank)) continue;
            return i;
        }
        return -1;
    }

    private int find_q_index(int p, Bucket[] buckets, long total_count) {
        int q = p;
        long count = buckets[p].count;
        double rank = 0.5 * (double)(total_count - 1L);
        int l = p - 1;
        int r = p + 1;
        while ((double)count <= rank && l >= 0 && r < buckets.length) {
            q = buckets[p].lower_bound - buckets[l].upper_bound < buckets[r].lower_bound - buckets[p].upper_bound ? l-- : r++;
            count += buckets[q].count;
        }
        while ((double)count <= rank && l >= 0) {
            q = l--;
            count += buckets[q].count;
        }
        while ((double)count <= rank && r < buckets.length) {
            q = r++;
            count += buckets[q].count;
        }
        double m_lower_bound = buckets[p].lower_bound + buckets[p].upper_bound - buckets[q].upper_bound;
        double m_upper_bound = buckets[p].lower_bound + buckets[p].upper_bound - buckets[q].lower_bound;
        if (p > q) {
            --r;
            if (buckets[r].lower_bound <= m_lower_bound && buckets[r].upper_bound >= m_upper_bound) {
                q = r;
            }
        } else if (p < q) {
            ++l;
            if (buckets[l].lower_bound <= m_lower_bound && buckets[l].upper_bound >= m_upper_bound) {
                q = l;
            }
        }
        return q;
    }

    private void setValid_range(Bucket p, Bucket q) {
        this.valid_range[0] = p.lower_bound;
        this.valid_range[1] = p.upper_bound;
        this.valid_range[2] = p.lower_bound + q.lower_bound - p.upper_bound;
        this.valid_range[3] = p.upper_bound + q.upper_bound - p.lower_bound;
        this.valid_range[4] = 2.0 * p.lower_bound - q.upper_bound;
        this.valid_range[5] = 2.0 * p.upper_bound - q.lower_bound;
        Arrays.sort(this.valid_range);
    }

    private double minDelta(double delta1, double delta2) {
        double delta = delta1 < 0.0 && delta2 < 0.0 ? 0.0 : (delta1 < 0.0 ? delta2 : (delta2 < 0.0 ? delta1 : Math.min(delta1, delta2)));
        return delta;
    }

    public Mad getMad() {
        long total_count;
        this.beta = 1.0;
        Bucket[] buckets = this.union_buckets();
        int p_index = this.find_p_index(buckets, total_count = this.total_count());
        if (p_index == -1) {
            throw new NoSuchElementException("No values in the time series");
        }
        int q_index = this.find_q_index(p_index, buckets, total_count);
        Bucket p = buckets[p_index];
        Bucket q = buckets[q_index];
        if (p.lower_bound * q.lower_bound > 0.0) {
            if (p.lower_bound == q.lower_bound) {
                return new Mad(0.0, Double.MAX_VALUE);
            }
            double mad = 2.0 * (p.upper_bound - q.lower_bound) * (p.lower_bound - q.upper_bound) / ((this.gamma + 1.0) * Math.abs(p.lower_bound - q.lower_bound));
            double gamma_p_q = Math.max(p.upper_bound / q.upper_bound, q.upper_bound / p.upper_bound);
            double delta = Math.abs(p.lower_bound) < Math.abs(q.lower_bound) ? this.minDelta(gamma_p_q / Math.pow(this.gamma, 2.0) - 1.0 / this.gamma + Math.pow(this.gamma, -3.0), 1.0 / (Math.pow(this.gamma, 3.0) - gamma_p_q * this.gamma + Math.pow(this.gamma, 2.0))) : this.minDelta(Math.pow(this.gamma, -2.0) + Math.pow(this.gamma, -3.0) - 1.0 / (gamma_p_q * this.gamma), 1.0 / (Math.pow(this.gamma, 2.0) / gamma_p_q + Math.pow(this.gamma, 3.0) - this.gamma));
            this.beta = 1.0 - 2.0 / (1.0 + delta);
            if (this.need_two_pass()) {
                this.setValid_range(p, q);
                return new Mad(mad, (1.0 + 2.0 / (gamma_p_q - 1.0)) * this.alpha);
            }
            return new Mad(0.0, Double.MAX_VALUE);
        }
        double mad = 2.0 * Math.max(Math.abs(p.upper_bound - q.lower_bound), Math.abs(q.upper_bound - p.lower_bound)) / (this.gamma + 1.0);
        return new Mad(mad, this.alpha);
    }

    public int sketch_size() {
        return this.positive_buckets.size() + this.negative_buckets.size() + (this.zero_count == 0L ? 0 : 1);
    }

    public boolean need_two_pass() {
        return this.beta > 0.0 && this.beta < 1.0;
    }

    public double getBeta() {
        return this.beta;
    }

    public double[] getValid_range() {
        return this.valid_range;
    }

    public void show(Bucket[] buckets) {
        for (Bucket bucket : buckets) {
            if (!logger.isDebugEnabled()) continue;
            logger.debug(bucket.index + ": " + bucket.count);
        }
    }

    public double getAlpha() {
        return this.alpha;
    }

    private static class Bucket {
        int index;
        double lower_bound;
        double upper_bound;
        long count;

        Bucket(int index, double lower_bound, double upper_bound, long count) {
            this.index = index;
            this.lower_bound = lower_bound;
            this.upper_bound = upper_bound;
            this.count = count;
        }
    }
}

