/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import java.util.Arrays;
import java.util.Random;

public abstract class KLLSketchForQuantile {
    long N;
    int maxMemoryNum;
    long[] num;
    boolean level0Sorted;
    int cntLevel;
    int[] levelPos;
    int[] levelMaxSize;
    long XORSHIFT = new Random().nextInt();

    protected abstract int calcMaxMemoryNum(int var1);

    protected abstract void calcLevelMaxSize(int var1);

    public int getLevelSize(int level) {
        return this.levelPos[level + 1] - this.levelPos[level];
    }

    public void show() {
        for (int i = 0; i < this.cntLevel; ++i) {
            System.out.print("\t");
            System.out.print("[" + (this.levelPos[i + 1] - this.levelPos[i]) + "]");
            System.out.print("\t");
        }
        System.out.println();
    }

    public void showNum() {
        for (int i = 0; i < this.cntLevel; ++i) {
            System.out.print("\t|");
            for (int j = this.levelPos[i]; j < this.levelPos[i + 1]; ++j) {
                System.out.print(this.num[j] + ",");
            }
            System.out.print("|\t");
        }
        System.out.println();
    }

    public void update(long x) {
        if (this.levelPos[0] == 0) {
            this.compact();
        }
        this.levelPos[0] = this.levelPos[0] - 1;
        this.num[this.levelPos[0]] = x;
        ++this.N;
        this.level0Sorted = false;
    }

    protected abstract void compact();

    protected int getNextRand01() {
        this.XORSHIFT ^= this.XORSHIFT >>> 12;
        this.XORSHIFT ^= this.XORSHIFT << 25;
        this.XORSHIFT ^= this.XORSHIFT >>> 27;
        return (int)(this.XORSHIFT * 2685821657736338717L & 1L);
    }

    protected void randomlyHalveDownToLeft(int L, int R) {
        int delta = this.getNextRand01();
        int mid = L + R >>> 1;
        int i = L;
        int j = L;
        while (i < mid) {
            this.num[i] = this.num[j + delta];
            ++i;
            j += 2;
        }
    }

    protected void mergeSortWithoutSpace(int L1, int mid, int L2, int R2) {
        int p1 = L1;
        int p2 = L2;
        int cntPos = mid;
        while (p1 < mid || p2 < R2) {
            if (p1 < mid && (p2 == R2 || this.num[p1] < this.num[p2])) {
                this.num[cntPos++] = this.num[p1++];
                continue;
            }
            this.num[cntPos++] = this.num[p2++];
        }
    }

    protected int findRankInLevel(int level, long v) {
        int L = this.levelPos[level];
        int R = this.levelPos[level + 1];
        if (level == 0 && !this.level0Sorted) {
            Arrays.sort(this.num, L, R);
            this.level0Sorted = true;
        }
        if (L > --R || this.num[L] >= v) {
            return 0;
        }
        while (L < R) {
            int mid = L + R + 1 >> 1;
            if (this.num[mid] < v) {
                L = mid;
                continue;
            }
            R = mid - 1;
        }
        return (L - this.levelPos[level] + 1) * (1 << level);
    }

    public int getApproxRank(long v) {
        int approxRank = 0;
        for (int i = 0; i < this.cntLevel; ++i) {
            approxRank += this.findRankInLevel(i, v);
        }
        return approxRank;
    }

    public long findMaxValueWithRank(long K2) {
        long L = Long.MIN_VALUE;
        long R = Long.MAX_VALUE;
        while (L < R) {
            long mid = L + (R - L >>> 1);
            if (mid == L) {
                ++mid;
            }
            if ((long)this.getApproxRank(mid) <= K2) {
                L = mid;
                continue;
            }
            R = mid - 1L;
        }
        return L;
    }

    public long findMinValueWithRank(long K2) {
        long L = Long.MIN_VALUE;
        long R = Long.MAX_VALUE;
        while (L < R) {
            long mid = L + (R - L >>> 1);
            if (mid == R) {
                --mid;
            }
            if ((long)this.getApproxRank(mid) >= K2) {
                R = mid;
                continue;
            }
            L = mid + 1L;
        }
        return L;
    }

    public long getN() {
        return this.N;
    }

    public int getMaxMemoryNum() {
        return this.maxMemoryNum;
    }

    public int getNumLen() {
        return this.levelPos[this.cntLevel] - this.levelPos[0];
    }

    public boolean exactResult() {
        return this.N == (long)this.getNumLen();
    }

    public long getExactResult(int K2) {
        int L = this.levelPos[0];
        int R = this.levelPos[1];
        if (!this.level0Sorted) {
            Arrays.sort(this.num, L, R);
            this.level0Sorted = true;
        }
        return this.num[L + K2];
    }
}

