/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.iotdb.library.dprofile.util.Segment;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFSegment
implements UDTF {
    private int windowSize;
    private double maxError;
    private String method;
    private String output;
    private static final ArrayList<Long> timestamp = new ArrayList();
    private static final ArrayList<Double> value = new ArrayList();

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validate(x -> (Integer)x > 0, "Window size should be a positive integer.", (Object)validator.getParameters().getIntOrDefault("window", 10)).validate(x -> (Double)x >= 0.0, "Error bound should be no less than 0.", (Object)validator.getParameters().getDoubleOrDefault("error", 0.1)).validate(x -> ((String)x).equalsIgnoreCase("bottom-up") || ((String)x).equalsIgnoreCase("swab"), "Method is illegal.", (Object)validator.getParameters().getStringOrDefault("method", "bottom-up")).validate(x -> ((String)x).equalsIgnoreCase("first") || ((String)x).equalsIgnoreCase("all"), "Output type is invalid.", (Object)validator.getParameters().getStringOrDefault("output", "first"));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        timestamp.clear();
        value.clear();
        this.windowSize = parameters.getIntOrDefault("window", 10);
        this.maxError = parameters.getDoubleOrDefault("error", 0.1);
        this.method = parameters.getStringOrDefault("method", "bottom-up");
        this.method = this.method.toLowerCase();
        this.output = parameters.getStringOrDefault("output", "first");
        this.output = this.output.toLowerCase();
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        double v = Util.getValueAsDouble(row);
        if (Double.isFinite(v)) {
            timestamp.add(row.getTime());
            value.add(Util.getValueAsDouble(row));
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        block8: {
            int index;
            ArrayList<double[]> res;
            long[] ts;
            block7: {
                ts = timestamp.stream().mapToLong(Long::valueOf).toArray();
                double[] v = value.stream().mapToDouble(Double::valueOf).toArray();
                ArrayList<double[]> seg = new ArrayList<double[]>();
                if (this.method.equals("bottom-up")) {
                    ArrayList<double[]> temp = Segment.bottom_up(v, this.maxError);
                    seg.addAll(temp);
                } else if (this.method.equals("swab")) {
                    seg = Segment.swab_alg(v, ts, this.maxError, this.windowSize);
                }
                res = new ArrayList<double[]>();
                for (double[] doubles : seg) {
                    res.add(Segment.approximated_segment(doubles));
                }
                index = 0;
                if (!this.output.equals("first")) break block7;
                for (double[] doubles : res) {
                    collector.putDouble(ts[index], doubles[0]);
                    index += doubles.length;
                }
                break block8;
            }
            if (!this.output.equals("all")) break block8;
            Iterator iterator = res.iterator();
            while (iterator.hasNext()) {
                double[] doubles;
                for (double aDouble : doubles = (double[])iterator.next()) {
                    collector.putDouble(ts[index], aDouble);
                    ++index;
                }
            }
        }
    }
}

