/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import com.github.ggalmazor.ltdownsampling.LTThreeBuckets;
import com.github.ggalmazor.ltdownsampling.Point;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.iotdb.library.util.NoNumberException;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowIterator;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFSample
implements UDTF {
    private int k;
    private Method method;
    private Pair<Long, Object>[] samples;
    private int num = 0;
    private Random random;
    private Type dataType;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validate(k -> (Integer)k > 0, "k should be a positive integer.", (Object)validator.getParameters().getIntOrDefault("k", 1)).validate(method -> "isometric".equalsIgnoreCase((String)method) || "reservoir".equalsIgnoreCase((String)method) || "triangle".equalsIgnoreCase((String)method), "Illegal sampling method.", (Object)validator.getParameters().getStringOrDefault("method", "reservoir"));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        this.k = parameters.getIntOrDefault("k", 1);
        this.dataType = parameters.getDataType(0);
        String method = parameters.getStringOrDefault("method", "reservoir");
        this.method = "triangle".equalsIgnoreCase(method) ? Method.TRIANGLE : ("isometric".equalsIgnoreCase(method) ? Method.ISOMETRIC : Method.RESERVOIR);
        if (this.method == Method.ISOMETRIC || this.method == Method.TRIANGLE) {
            configurations.setAccessStrategy(new SlidingSizeWindowAccessStrategy(Integer.MAX_VALUE)).setOutputDataType(parameters.getDataType(0));
        } else {
            configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(parameters.getDataType(0));
            this.samples = new Pair[this.k];
            this.random = new Random();
        }
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        int x = this.num < this.k ? this.num : this.random.nextInt(this.num + 1);
        if (x < this.k) {
            Object v = Util.getValueAsObject(row);
            Long t2 = row.getTime();
            this.samples[x] = Pair.of(t2, v);
        }
        ++this.num;
    }

    @Override
    public void transform(RowWindow rowWindow, PointCollector collector) throws Exception {
        block13: {
            block10: {
                int n;
                block11: {
                    block12: {
                        n = rowWindow.windowSize();
                        if (this.k >= n) break block10;
                        if (this.method != Method.TRIANGLE) break block11;
                        LinkedList<Point> input = new LinkedList<Point>();
                        for (int i = 0; i < n; ++i) {
                            Row row = rowWindow.getRow(i);
                            BigDecimal time = BigDecimal.valueOf(row.getTime());
                            BigDecimal data = BigDecimal.valueOf(Util.getValueAsDouble(row));
                            input.add(new Point(time, data));
                        }
                        if (this.k <= 2) break block12;
                        List<Point> output = LTThreeBuckets.sorted(input, this.k - 2);
                        block7: for (Point p : output) {
                            switch (this.dataType) {
                                case INT32: {
                                    Util.putValue(collector, this.dataType, p.getX().longValue(), p.getY().intValue());
                                    continue block7;
                                }
                                case INT64: {
                                    Util.putValue(collector, this.dataType, p.getX().longValue(), p.getY().longValue());
                                    continue block7;
                                }
                                case FLOAT: {
                                    Util.putValue(collector, this.dataType, p.getX().longValue(), Float.valueOf(p.getY().floatValue()));
                                    continue block7;
                                }
                                case DOUBLE: {
                                    Util.putValue(collector, this.dataType, p.getX().longValue(), p.getY().doubleValue());
                                    continue block7;
                                }
                            }
                            throw new NoNumberException();
                        }
                        break block13;
                    }
                    Row row = rowWindow.getRow(0);
                    Util.putValue(collector, this.dataType, row.getTime(), Util.getValueAsObject(row));
                    if (this.k != 2) break block13;
                    row = rowWindow.getRow(n - 1);
                    Util.putValue(collector, this.dataType, row.getTime(), Util.getValueAsObject(row));
                    break block13;
                }
                for (long i = 0L; i < (long)this.k; ++i) {
                    long j = Math.floorDiv(i * (long)n, (long)this.k);
                    Row row = rowWindow.getRow((int)j);
                    Util.putValue(collector, this.dataType, row.getTime(), Util.getValueAsObject(row));
                }
                break block13;
            }
            RowIterator iterator = rowWindow.getRowIterator();
            while (iterator.hasNextRow()) {
                Row row = iterator.next();
                Util.putValue(collector, this.dataType, row.getTime(), Util.getValueAsObject(row));
            }
        }
    }

    @Override
    public void terminate(PointCollector pc) throws Exception {
        if (this.samples != null) {
            int m4 = Math.min(this.num, this.k);
            Arrays.sort(this.samples, 0, m4);
            for (int i = 0; i < m4; ++i) {
                Pair<Long, Object> p = this.samples[i];
                Util.putValue(pc, this.dataType, p.getLeft(), p.getRight());
            }
        }
    }

    static enum Method {
        ISOMETRIC,
        RESERVOIR,
        TRIANGLE;

    }
}

