/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dmatch;

import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDAFPearson
implements UDTF {
    private long count = 0L;
    private double sum_x = 0.0;
    private double sum_y = 0.0;
    private double sum_xy = 0.0;
    private double sum_xx = 0.0;
    private double sum_yy = 0.0;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(2).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validateInputSeriesDataType(1, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.count = 0L;
        this.sum_x = 0.0;
        this.sum_y = 0.0;
        this.sum_xy = 0.0;
        this.sum_xx = 0.0;
        this.sum_yy = 0.0;
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        if (row.isNull(0) || row.isNull(1)) {
            return;
        }
        double x = Util.getValueAsDouble(row, 0);
        double y = Util.getValueAsDouble(row, 1);
        if (Double.isFinite(x) && Double.isFinite(y)) {
            ++this.count;
            this.sum_x += x;
            this.sum_y += y;
            this.sum_xy += x * y;
            this.sum_xx += x * x;
            this.sum_yy += y * y;
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        if (this.count > 0L) {
            double pearson = ((double)this.count * this.sum_xy - this.sum_x * this.sum_y) / Math.sqrt((double)this.count * this.sum_xx - this.sum_x * this.sum_x) / Math.sqrt((double)this.count * this.sum_yy - this.sum_y * this.sum_y);
            collector.putDouble(0L, pearson);
        } else {
            collector.putDouble(0L, Double.NaN);
        }
    }
}

