/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.anomaly.util;

import java.util.ArrayList;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowIterator;

public class WindowDetect {
    protected int timeLength;
    protected double len;
    protected double threshold;
    protected long[] time;
    protected double[] original;
    protected double[] repaired;

    public WindowDetect(RowIterator dataIterator, double l, double t2) throws Exception {
        this.len = l;
        this.threshold = t2;
        ArrayList<Long> timeList = new ArrayList<Long>();
        ArrayList<Double> originList = new ArrayList<Double>();
        while (dataIterator.hasNextRow()) {
            Row row = dataIterator.next();
            Double v = Util.getValueAsDouble(row);
            timeList.add(row.getTime());
            if (v == null || !Double.isFinite(v)) {
                originList.add(Double.NaN);
                continue;
            }
            originList.add(v);
        }
        this.time = Util.toLongArray(timeList);
        this.original = Util.toDoubleArray(originList);
        this.timeLength = this.time.length;
        this.repair();
    }

    private void repair() throws Exception {
        ArrayList<Double> repairedList = new ArrayList<Double>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (int i = 0; i < this.timeLength; ++i) {
            long curTime = this.time[i];
            double curValue = this.original[i];
            double valueBefore = 0.0;
            double valueAfter = 0.0;
            int j = (int)Math.max(0.0, (double)i - this.len);
            while ((double)j <= Math.min((double)(this.timeLength - 1), (double)i + this.len)) {
                if (j < i && (double)Math.abs(this.time[j] - curTime) <= this.len * 1000.0) {
                    valueBefore += this.original[j];
                }
                if (j > i && (double)Math.abs(this.time[j] - curTime) <= this.len * 1000.0) {
                    valueAfter += this.original[j];
                }
                ++j;
            }
            double p1 = Math.abs((valueBefore /= this.len) - curValue) / (Math.max(valueBefore, curValue) + 1.0);
            double p2 = Math.abs((valueAfter /= this.len) - curValue) / (Math.max(valueAfter, curValue) + 1.0);
            if (!(p1 < this.threshold) && !(p2 < this.threshold)) continue;
            repairedList.add(curValue);
            timeList.add(curTime);
        }
        this.time = Util.toLongArray(timeList);
        this.repaired = Util.toDoubleArray(repairedList);
    }

    public long[] getTime() {
        return this.time;
    }

    public double[] getRepaired() {
        return this.repaired;
    }
}

