/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.anomaly.util;

import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.apache.iotdb.library.util.BooleanCircularQueue;
import org.apache.iotdb.library.util.DoubleCircularQueue;
import org.apache.iotdb.library.util.LongCircularQueue;

public class StreamMissDetector {
    private final LongCircularQueue timeWindow = new LongCircularQueue();
    private final DoubleCircularQueue valueWindow = new DoubleCircularQueue();
    private final LongCircularQueue timeBuffer = new LongCircularQueue();
    private final BooleanCircularQueue labelBuffer = new BooleanCircularQueue();
    private final SimpleRegression regression = new SimpleRegression();
    private final double threshold = 0.9999;
    private int minLength;
    private int state = 0;
    private long startTime = -1L;
    private int missingStartIndex;
    private boolean horizon;
    private double standard;

    public StreamMissDetector(int minLength) {
        this.minLength = minLength;
    }

    public void insert(long time, double value) {
        this.timeWindow.push(time);
        this.valueWindow.push(value);
        if (this.startTime < 0L) {
            this.startTime = time;
        }
        switch (this.state) {
            case 0: {
                if (this.timeWindow.getSize() < this.getWindowSize()) break;
                this.linearRegress(0, this.getWindowSize());
                double alpha = this.regression.getRSquare();
                if (Double.isNaN(alpha) || alpha > 0.9999) {
                    this.missingStartIndex = 0;
                    this.state = 2;
                    break;
                }
                this.regression.clear();
                this.state = 1;
                break;
            }
            case 1: {
                if (this.timeWindow.getSize() < this.getWindowSize() * 2) break;
                this.linearRegress(this.getWindowSize(), this.getWindowSize() * 2);
                double alpha = this.regression.getRSquare();
                if (Double.isNaN(alpha) || alpha > 0.9999) {
                    this.missingStartIndex = this.backExtend();
                    this.state = 2;
                    break;
                }
                for (int i = 0; i < this.getWindowSize(); ++i) {
                    this.timeBuffer.push(this.timeWindow.pop());
                    this.labelBuffer.push(false);
                    this.valueWindow.pop();
                }
                this.regression.clear();
                this.state = 1;
                break;
            }
            case 2: {
                this.regression.addData(time - this.startTime, value);
                double alpha = this.regression.getRSquare();
                if ((!this.horizon || value == this.standard) && (this.horizon || !(alpha < 0.9999))) break;
                int missingEndIndex = this.timeWindow.getSize() - 1;
                for (int i = 0; i < this.missingStartIndex; ++i) {
                    this.timeBuffer.push(this.timeWindow.pop());
                    this.labelBuffer.push(false);
                    this.valueWindow.pop();
                }
                boolean label = missingEndIndex - this.missingStartIndex > this.minLength;
                for (int i = this.missingStartIndex; i < missingEndIndex; ++i) {
                    this.timeBuffer.push(this.timeWindow.pop());
                    this.labelBuffer.push(label);
                    this.valueWindow.pop();
                }
                this.regression.clear();
                this.state = 0;
            }
        }
    }

    public void flush() {
        switch (this.state) {
            case 0: 
            case 1: {
                while (!this.timeWindow.isEmpty()) {
                    this.timeBuffer.push(this.timeWindow.pop());
                    this.labelBuffer.push(false);
                    this.valueWindow.pop();
                }
                break;
            }
            case 2: {
                boolean label = this.timeWindow.getSize() - this.missingStartIndex > this.minLength;
                for (int i = 0; i < this.missingStartIndex; ++i) {
                    this.timeBuffer.push(this.timeWindow.pop());
                    this.labelBuffer.push(false);
                    this.valueWindow.pop();
                }
                while (!this.timeWindow.isEmpty()) {
                    this.timeBuffer.push(this.timeWindow.pop());
                    this.labelBuffer.push(label);
                    this.valueWindow.pop();
                }
                break;
            }
        }
    }

    private int backExtend() {
        this.horizon = Double.isNaN(this.regression.getRSquare());
        this.standard = this.regression.getIntercept();
        int bindex = this.getWindowSize();
        while (bindex > 0) {
            this.regression.addData(this.timeWindow.get(--bindex) - this.startTime, this.valueWindow.get(bindex));
            double alpha = this.regression.getRSquare();
            if ((!this.horizon || this.valueWindow.get(bindex) == this.standard) && (this.horizon || !(alpha < 0.9999))) continue;
            break;
        }
        this.regression.removeData(this.timeWindow.get(bindex) - this.startTime, this.valueWindow.get(bindex));
        return bindex + 1;
    }

    private void linearRegress(int start, int end) {
        double[][] data = new double[this.getWindowSize()][2];
        for (int i = start; i < end; ++i) {
            data[i - start][0] = this.timeWindow.get(i) - this.startTime;
            data[i - start][1] = this.valueWindow.get(i);
        }
        this.regression.addData(data);
    }

    public boolean hasNext() {
        return !this.timeBuffer.isEmpty();
    }

    public long getOutTime() {
        return this.timeBuffer.getHead();
    }

    public boolean getOutValue() {
        return this.labelBuffer.getHead();
    }

    public void next() {
        this.timeBuffer.pop();
        this.labelBuffer.pop();
    }

    private int getWindowSize() {
        return this.minLength / 2;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }
}

