/*
 * Decompiled with CFR 0.152.
 */
package com.github.ggalmazor.ltdownsampling;

import com.github.ggalmazor.ltdownsampling.OnePassBucketizer;
import com.github.ggalmazor.ltdownsampling.Point;
import com.github.ggalmazor.ltdownsampling.Triangle;
import com.github.ggalmazor.ltdownsampling.tools.CustomCollectors;
import java.util.ArrayList;
import java.util.List;

public final class LTThreeBuckets {
    public static <T extends Point> List<T> sorted(List<T> input, int desiredBuckets) {
        return LTThreeBuckets.sorted(input, input.size(), desiredBuckets);
    }

    public static <T extends Point> List<T> sorted(List<T> input, int inputSize, int desiredBuckets) {
        ArrayList results = new ArrayList();
        OnePassBucketizer.bucketize(input, inputSize, desiredBuckets).stream().collect(CustomCollectors.sliding(3, 1)).stream().map(Triangle::of).forEach(triangle -> {
            if (results.size() == 0) {
                results.add(triangle.getFirst());
            }
            results.add(triangle.getResult());
            if (results.size() == desiredBuckets + 1) {
                results.add(triangle.getLast());
            }
        });
        return results;
    }
}

