/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.quotas;

import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TTimedQuota;
import org.apache.iotdb.common.rpc.thrift.ThrottleType;
import org.apache.iotdb.commons.exception.RpcThrottlingException;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.quotas.AverageIntervalRateLimiter;
import org.apache.iotdb.db.quotas.FixedIntervalRateLimiter;
import org.apache.iotdb.db.quotas.RateLimiter;
import org.apache.iotdb.rpc.TSStatusCode;

public class QuotaLimiter {
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private RateLimiter reqsLimiter = null;
    private RateLimiter reqSizeLimiter = null;
    private RateLimiter writeReqsLimiter = null;
    private RateLimiter writeSizeLimiter = null;
    private RateLimiter readReqsLimiter = null;
    private RateLimiter readSizeLimiter = null;

    private QuotaLimiter() {
        if (RateLimiterType.FixedIntervalRateLimiter.name().equals(this.config.getRateLimiterType())) {
            this.reqsLimiter = new FixedIntervalRateLimiter();
            this.reqSizeLimiter = new FixedIntervalRateLimiter();
            this.writeReqsLimiter = new FixedIntervalRateLimiter();
            this.writeSizeLimiter = new FixedIntervalRateLimiter();
            this.readReqsLimiter = new FixedIntervalRateLimiter();
            this.readSizeLimiter = new FixedIntervalRateLimiter();
        } else {
            this.reqsLimiter = new AverageIntervalRateLimiter();
            this.reqSizeLimiter = new AverageIntervalRateLimiter();
            this.writeReqsLimiter = new AverageIntervalRateLimiter();
            this.writeSizeLimiter = new AverageIntervalRateLimiter();
            this.readReqsLimiter = new AverageIntervalRateLimiter();
            this.readSizeLimiter = new AverageIntervalRateLimiter();
        }
    }

    public static QuotaLimiter fromThrottle(Map<ThrottleType, TTimedQuota> throttleLimit) {
        TTimedQuota timedQuota;
        QuotaLimiter limiter = new QuotaLimiter();
        if (throttleLimit.containsKey(ThrottleType.REQUEST_NUMBER)) {
            timedQuota = throttleLimit.get(ThrottleType.REQUEST_NUMBER);
            limiter.reqsLimiter.set(timedQuota.getSoftLimit(), timedQuota.getTimeUnit());
        }
        if (throttleLimit.containsKey(ThrottleType.REQUEST_SIZE)) {
            timedQuota = throttleLimit.get(ThrottleType.REQUEST_SIZE);
            limiter.reqSizeLimiter.set(timedQuota.getSoftLimit(), timedQuota.getTimeUnit());
        }
        if (throttleLimit.containsKey(ThrottleType.WRITE_NUMBER)) {
            timedQuota = throttleLimit.get(ThrottleType.WRITE_NUMBER);
            limiter.writeReqsLimiter.set(timedQuota.getSoftLimit(), timedQuota.getTimeUnit());
        }
        if (throttleLimit.containsKey(ThrottleType.WRITE_SIZE)) {
            timedQuota = throttleLimit.get(ThrottleType.WRITE_SIZE);
            limiter.writeSizeLimiter.set(timedQuota.getSoftLimit(), timedQuota.getTimeUnit());
        }
        if (throttleLimit.containsKey(ThrottleType.READ_NUMBER)) {
            timedQuota = throttleLimit.get(ThrottleType.READ_NUMBER);
            limiter.readReqsLimiter.set(timedQuota.getSoftLimit(), timedQuota.getTimeUnit());
        }
        if (throttleLimit.containsKey(ThrottleType.READ_SIZE)) {
            timedQuota = throttleLimit.get(ThrottleType.READ_SIZE);
            limiter.readSizeLimiter.set(timedQuota.getSoftLimit(), timedQuota.getTimeUnit());
        }
        return limiter;
    }

    public void checkQuota(long writeReqs, long estimateWriteSize, long readReqs, long estimateReadSize) throws RpcThrottlingException {
        if (!this.reqsLimiter.canExecute(writeReqs + readReqs)) {
            throw new RpcThrottlingException("number of requests exceeded - wait " + this.reqsLimiter.waitInterval() + "ms", TSStatusCode.NUM_REQUESTS_EXCEEDED.getStatusCode());
        }
        if (!this.reqSizeLimiter.canExecute(estimateWriteSize + estimateReadSize)) {
            throw new RpcThrottlingException("request size limit exceeded - wait " + this.reqSizeLimiter.waitInterval() + "ms", TSStatusCode.REQUEST_SIZE_EXCEEDED.getStatusCode());
        }
        if (estimateWriteSize > 0L) {
            if (!this.writeReqsLimiter.canExecute(writeReqs)) {
                throw new RpcThrottlingException("number of write requests exceeded - wait " + this.writeReqsLimiter.waitInterval() + "ms", TSStatusCode.NUM_WRITE_REQUESTS_EXCEEDED.getStatusCode());
            }
            if (!this.writeSizeLimiter.canExecute(estimateWriteSize)) {
                throw new RpcThrottlingException("write size limit exceeded - wait " + this.writeSizeLimiter.waitInterval() + "ms", TSStatusCode.WRITE_SIZE_EXCEEDED.getStatusCode());
            }
        }
        if (estimateReadSize > 0L) {
            if (!this.readReqsLimiter.canExecute(readReqs)) {
                throw new RpcThrottlingException("number of read requests exceeded - wait " + this.readReqsLimiter.waitInterval() + "ms", TSStatusCode.NUM_READ_REQUESTS_EXCEEDED.getStatusCode());
            }
            if (!this.readSizeLimiter.canExecute(estimateReadSize)) {
                throw new RpcThrottlingException("read size limit exceeded - wait " + this.readSizeLimiter.waitInterval() + "ms", TSStatusCode.READ_SIZE_EXCEEDED.getStatusCode());
            }
        }
    }

    public void grabQuota(long writeReqs, long writeSize, long readReqs, long readSize) {
        this.reqsLimiter.consume(writeReqs + readReqs);
        this.reqSizeLimiter.consume(writeSize + readSize);
        if (writeSize > 0L) {
            this.writeReqsLimiter.consume(writeReqs);
            this.writeSizeLimiter.consume(writeSize);
        }
        if (readSize > 0L) {
            this.readReqsLimiter.consume(readReqs);
            this.readSizeLimiter.consume(readSize);
        }
    }

    public long getReadAvailable() {
        return this.readSizeLimiter.getAvailable();
    }

    public void consumeWrite(long size) {
        this.reqSizeLimiter.consume(size);
        this.writeSizeLimiter.consume(size);
    }

    public void consumeRead(long size) {
        this.reqSizeLimiter.consume(size);
        this.readSizeLimiter.consume(size);
    }

    public static enum RateLimiterType {
        FixedIntervalRateLimiter,
        AverageIntervalRateLimiter;

    }
}

