/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.metadata.path.PatternTreeMapFactory;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Path;

public class QueryContext {
    private final Map<String, Map<String, List<Modification>>> filePathModCache = new ConcurrentHashMap<String, Map<String, List<Modification>>>();
    private final Map<String, PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>> fileModCache = new HashMap<String, PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>>();
    protected long queryId;
    private long queryTimeLowerBound = Long.MIN_VALUE;
    private boolean debug;
    private static final int MAX_STATEMENT_LENGTH = 64;
    private long startTime;
    private String statement;
    private long timeout;
    private volatile boolean isInterrupted = false;

    public QueryContext() {
    }

    public QueryContext(long queryId) {
        this(queryId, false, System.currentTimeMillis(), "", 0L);
    }

    public QueryContext(long queryId, boolean debug, long startTime, String statement, long timeout) {
        this.queryId = queryId;
        this.debug = debug;
        this.startTime = startTime;
        this.statement = statement;
        this.timeout = timeout;
    }

    public List<Modification> getPathModifications(ModificationFile modFile, PartialPath path) {
        if (!modFile.exists()) {
            return Collections.emptyList();
        }
        Map fileModifications = this.filePathModCache.computeIfAbsent(modFile.getFilePath(), k -> new ConcurrentHashMap());
        return fileModifications.computeIfAbsent(path.getFullPath(), k -> {
            PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> allModifications = this.fileModCache.get(modFile.getFilePath());
            if (allModifications == null) {
                allModifications = PatternTreeMapFactory.getModsPatternTreeMap();
                for (Modification modification : modFile.getModifications()) {
                    allModifications.append(modification.getPath(), (Object)modification);
                }
                this.fileModCache.put(modFile.getFilePath(), allModifications);
            }
            return this.sortAndMerge(allModifications.getOverlapped(path));
        });
    }

    private List<Modification> sortAndMerge(List<Modification> modifications) {
        modifications.sort((o1, o2) -> {
            if (!o1.getType().equals((Object)o2.getType())) {
                return o1.getType().compareTo(o2.getType());
            }
            if (!o1.getPath().equals((Object)o2.getPath())) {
                return o1.getPath().compareTo((Path)o2.getPath());
            }
            if (o1.getFileOffset() != o2.getFileOffset()) {
                return (int)(o1.getFileOffset() - o2.getFileOffset());
            }
            if (o1.getType() == Modification.Type.DELETION) {
                Deletion del1 = (Deletion)o1;
                Deletion del2 = (Deletion)o2;
                return del1.getTimeRange().compareTo(del2.getTimeRange());
            }
            throw new IllegalArgumentException();
        });
        ArrayList<Modification> result = new ArrayList<Modification>();
        if (!modifications.isEmpty()) {
            Deletion current = ((Deletion)modifications.get(0)).clone();
            for (int i = 1; i < modifications.size(); ++i) {
                Deletion del = (Deletion)modifications.get(i);
                if (current.intersects(del)) {
                    current.merge(del);
                    continue;
                }
                result.add(current);
                current = del.clone();
            }
            result.add(current);
        }
        return result;
    }

    public List<List<Modification>> getPathModifications(ModificationFile modFile, AlignedPath path) {
        int n = path.getMeasurementList().size();
        ArrayList<List<Modification>> ans = new ArrayList<List<Modification>>(n);
        for (int i = 0; i < n; ++i) {
            ans.add(this.getPathModifications(modFile, path.getPathWithMeasurement(i)));
        }
        return ans;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public long getQueryTimeLowerBound() {
        return this.queryTimeLowerBound;
    }

    public void setQueryTimeLowerBound(long queryTimeLowerBound) {
        this.queryTimeLowerBound = queryTimeLowerBound;
    }

    public boolean chunkNotSatisfy(IChunkMetadata chunkMetaData) {
        return chunkMetaData.getEndTime() < this.queryTimeLowerBound;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getStatement() {
        return this.statement;
    }

    public QueryContext setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public void getStatement(String statement) {
        this.statement = statement;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public QueryContext setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public QueryContext setStatement(String statement) {
        this.statement = statement.length() <= 64 ? statement : statement.substring(0, 32) + "..." + statement.substring(statement.length() - 32);
        return this;
    }

    public void setInterrupted(boolean interrupted) {
        this.isInterrupted = interrupted;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }
}

