/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.function.aggregator;

import java.util.List;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxAggregator;

public class InfluxSpreadFunction
extends InfluxAggregator {
    private Double maxNum = null;
    private Double minNum = null;

    public InfluxSpreadFunction(List<Expression> expressionList) {
        super(expressionList);
    }

    @Override
    public InfluxFunctionValue calculateBruteForce() {
        if (this.maxNum == null || this.minNum == null) {
            return new InfluxFunctionValue(null, 0L);
        }
        return new InfluxFunctionValue(this.maxNum - this.minNum, 0L);
    }

    @Override
    public InfluxFunctionValue calculateByIoTDBFunc() {
        if (this.maxNum == null || this.minNum == null) {
            return new InfluxFunctionValue(null, null);
        }
        return new InfluxFunctionValue(this.maxNum - this.minNum, 0L);
    }

    @Override
    public String getFunctionName() {
        return "spread";
    }

    @Override
    public void updateValueBruteForce(InfluxFunctionValue functionValue) {
        Object value = functionValue.getValue();
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("not support this type");
        }
        double tmpValue = ((Number)value).doubleValue();
        if (this.maxNum == null || tmpValue > this.maxNum) {
            this.maxNum = tmpValue;
        }
        if (this.minNum == null || tmpValue < this.minNum) {
            this.minNum = tmpValue;
        }
    }

    @Override
    public void updateValueIoTDBFunc(InfluxFunctionValue ... functionValues) {
        if (functionValues.length == 1) {
            double tmpValue = ((Number)functionValues[0].getValue()).doubleValue();
            if (this.maxNum == null) {
                this.maxNum = tmpValue;
            } else if (tmpValue > this.maxNum) {
                this.maxNum = tmpValue;
            }
        } else if (functionValues.length == 2) {
            double tmpValue = ((Number)functionValues[1].getValue()).doubleValue();
            if (this.minNum == null) {
                this.minNum = tmpValue;
            } else if (tmpValue < this.minNum) {
                this.minNum = tmpValue;
            }
        }
    }
}

