/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.v2;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.commons.lang.NotImplementedException;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.connector.v1.IoTDBThriftConnectorClient;
import org.apache.iotdb.db.pipe.connector.v1.request.PipeTransferHandshakeReq;
import org.apache.iotdb.db.pipe.connector.v1.request.PipeTransferInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.v1.request.PipeTransferTabletReq;
import org.apache.iotdb.db.pipe.connector.v2.handler.PipeTransferInsertNodeTabletInsertionEventHandler;
import org.apache.iotdb.db.pipe.connector.v2.handler.PipeTransferRawTabletInsertionEventHandler;
import org.apache.iotdb.db.pipe.connector.v2.handler.PipeTransferTsFileInsertionEventHandler;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.session.util.SessionUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBThriftConnectorV2
implements PipeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBThriftConnectorV2.class);
    private static final String FAILED_TO_BORROW_CLIENT_FORMATTER = "Failed to borrow client from client pool for receiver %s:%s.";
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final IoTDBConfig IOTDB_CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static volatile IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient> asyncPipeDataTransferClientManagerHolder;
    private final IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient> asyncPipeDataTransferClientManager;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicLong commitIdGenerator = new AtomicLong(0L);
    private final AtomicLong lastCommitId = new AtomicLong(0L);
    private final PriorityQueue<Pair<Long, Runnable>> commitQueue = new PriorityQueue<Pair>(Comparator.comparing(o -> (Long)o.left));
    private List<TEndPoint> nodeUrls;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public IoTDBThriftConnectorV2() {
        if (asyncPipeDataTransferClientManagerHolder == null) {
            Class<IoTDBThriftConnectorV2> clazz = IoTDBThriftConnectorV2.class;
            // MONITORENTER : org.apache.iotdb.db.pipe.connector.v2.IoTDBThriftConnectorV2.class
            if (asyncPipeDataTransferClientManagerHolder == null) {
                asyncPipeDataTransferClientManagerHolder = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.AsyncPipeDataTransferServiceClientPoolFactory());
            }
            // MONITOREXIT : clazz
        }
        this.asyncPipeDataTransferClientManager = asyncPipeDataTransferClientManagerHolder;
    }

    public synchronized void commit(long requestCommitId, @Nullable EnrichedEvent enrichedEvent) {
        this.commitQueue.offer((Pair<Long, Runnable>)new Pair((Object)requestCommitId, () -> Optional.ofNullable(enrichedEvent).ifPresent(event -> event.decreaseReferenceCount(IoTDBThriftConnectorV2.class.getName()))));
        while (!this.commitQueue.isEmpty()) {
            Pair<Long, Runnable> committer = this.commitQueue.peek();
            if (this.lastCommitId.get() + 1L != (Long)committer.left) break;
            ((Runnable)committer.right).run();
            this.lastCommitId.incrementAndGet();
            this.commitQueue.poll();
        }
    }

    public void validate(PipeParameterValidator validator) throws Exception {
        validator.validateRequiredAttribute("connector.node-urls");
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        this.nodeUrls = SessionUtils.parseSeedNodeUrls(Arrays.asList(parameters.getString("connector.node-urls").split(",")));
        if (this.nodeUrls.isEmpty()) {
            throw new PipeException("Node urls is empty.");
        }
    }

    public void handshake() throws Exception {
        TEndPoint firstNodeUrl = this.nodeUrls.get(0);
        try (IoTDBThriftConnectorClient client = new IoTDBThriftConnectorClient(new ThriftClientProperty.Builder().setConnectionTimeoutMs(COMMON_CONFIG.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(COMMON_CONFIG.isRpcThriftCompressionEnabled()).build(), firstNodeUrl.getIp(), firstNodeUrl.getPort());){
            TPipeTransferResp resp = client.pipeTransfer(PipeTransferHandshakeReq.toTPipeTransferReq(CommonDescriptor.getInstance().getConfig().getTimestampPrecision()));
            if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new PipeException(String.format("Handshake error, result status %s.", resp.status));
            }
        }
        catch (TException e) {
            throw new PipeConnectionException(String.format("Connect to receiver %s:%s error: %s", e.getMessage(), firstNodeUrl.getIp(), firstNodeUrl.getPort()), (Throwable)e);
        }
    }

    public void heartbeat() {
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            long requestCommitId = this.commitIdGenerator.incrementAndGet();
            PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent;
            PipeTransferInsertNodeReq pipeTransferInsertNodeReq = PipeTransferInsertNodeReq.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getInsertNode());
            PipeTransferInsertNodeTabletInsertionEventHandler pipeTransferInsertNodeReqHandler = new PipeTransferInsertNodeTabletInsertionEventHandler(requestCommitId, pipeInsertNodeTabletInsertionEvent, pipeTransferInsertNodeReq, this);
            this.transfer(requestCommitId, pipeTransferInsertNodeReqHandler);
        } else if (tabletInsertionEvent instanceof PipeRawTabletInsertionEvent) {
            long requestCommitId = this.commitIdGenerator.incrementAndGet();
            PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent = (PipeRawTabletInsertionEvent)tabletInsertionEvent;
            PipeTransferTabletReq pipeTransferTabletReq = PipeTransferTabletReq.toTPipeTransferReq(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned());
            PipeTransferRawTabletInsertionEventHandler pipeTransferTabletReqHandler = new PipeTransferRawTabletInsertionEventHandler(requestCommitId, pipeTransferTabletReq, this);
            this.transfer(requestCommitId, pipeTransferTabletReqHandler);
        } else {
            throw new NotImplementedException("IoTDBThriftConnectorV2 only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent.");
        }
    }

    public void transfer(long requestCommitId, PipeTransferInsertNodeTabletInsertionEventHandler pipeTransferInsertNodeReqHandler) {
        TEndPoint targetNodeUrl = this.nodeUrls.get((int)(requestCommitId % (long)this.nodeUrls.size()));
        try {
            AsyncPipeDataTransferServiceClient client = (AsyncPipeDataTransferServiceClient)this.asyncPipeDataTransferClientManager.borrowClient((Object)targetNodeUrl);
            try {
                pipeTransferInsertNodeReqHandler.transfer(client);
            }
            catch (TException e) {
                LOGGER.warn(String.format("Transfer insert node to receiver %s:%s error, retrying...", targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)e);
            }
        }
        catch (Exception ex) {
            pipeTransferInsertNodeReqHandler.onError(ex);
            LOGGER.warn(String.format(FAILED_TO_BORROW_CLIENT_FORMATTER, targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)ex);
        }
    }

    public void transfer(long requestCommitId, PipeTransferRawTabletInsertionEventHandler pipeTransferTabletReqHandler) {
        TEndPoint targetNodeUrl = this.nodeUrls.get((int)(requestCommitId % (long)this.nodeUrls.size()));
        try {
            AsyncPipeDataTransferServiceClient client = (AsyncPipeDataTransferServiceClient)this.asyncPipeDataTransferClientManager.borrowClient((Object)targetNodeUrl);
            try {
                pipeTransferTabletReqHandler.transfer(client);
            }
            catch (TException e) {
                LOGGER.warn(String.format("Transfer tablet to receiver %s:%s error, retrying...", targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)e);
            }
        }
        catch (Exception ex) {
            pipeTransferTabletReqHandler.onError(ex);
            LOGGER.warn(String.format(FAILED_TO_BORROW_CLIENT_FORMATTER, targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)ex);
        }
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            throw new NotImplementedException("IoTDBThriftConnectorV2 only support PipeTsFileInsertionEvent.");
        }
        long requestCommitId = this.commitIdGenerator.incrementAndGet();
        PipeTsFileInsertionEvent pipeTsFileInsertionEvent = (PipeTsFileInsertionEvent)tsFileInsertionEvent;
        PipeTransferTsFileInsertionEventHandler pipeTransferTsFileInsertionEventHandler = new PipeTransferTsFileInsertionEventHandler(requestCommitId, pipeTsFileInsertionEvent, this);
        pipeTsFileInsertionEvent.waitForTsFileClose();
        this.transfer(requestCommitId, pipeTransferTsFileInsertionEventHandler);
    }

    public void transfer(long requestCommitId, PipeTransferTsFileInsertionEventHandler pipeTransferTsFileInsertionEventHandler) {
        TEndPoint targetNodeUrl = this.nodeUrls.get((int)(requestCommitId % (long)this.nodeUrls.size()));
        try {
            AsyncPipeDataTransferServiceClient client = (AsyncPipeDataTransferServiceClient)this.asyncPipeDataTransferClientManager.borrowClient((Object)targetNodeUrl);
            try {
                pipeTransferTsFileInsertionEventHandler.transfer(client);
            }
            catch (TException e) {
                LOGGER.warn(String.format("Transfer tsfile to receiver %s:%s error, retrying...", targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)e);
            }
        }
        catch (Exception ex) {
            pipeTransferTsFileInsertionEventHandler.onError(ex);
            LOGGER.warn(String.format(FAILED_TO_BORROW_CLIENT_FORMATTER, targetNodeUrl.getIp(), targetNodeUrl.getPort()), (Throwable)ex);
        }
    }

    public void transfer(Event event) {
        LOGGER.warn("IoTDBThriftConnectorV2 does not support transfer generic event: {}.", (Object)event);
    }

    public void close() {
        this.isClosed.set(true);
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }
}

