/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.v1.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.pipe.connector.IoTDBThriftConnectorRequestVersion;
import org.apache.iotdb.db.pipe.connector.v1.PipeRequestType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferHandshakeReq
extends TPipeTransferReq {
    private String timestampPrecision;

    private PipeTransferHandshakeReq() {
    }

    public String getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public static PipeTransferHandshakeReq toTPipeTransferReq(String timestampPrecision) throws IOException {
        PipeTransferHandshakeReq handshakeReq = new PipeTransferHandshakeReq();
        handshakeReq.timestampPrecision = timestampPrecision;
        handshakeReq.version = IoTDBThriftConnectorRequestVersion.VERSION_1.getVersion();
        handshakeReq.type = PipeRequestType.HANDSHAKE.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((String)timestampPrecision, (OutputStream)outputStream);
            handshakeReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return handshakeReq;
    }

    public static PipeTransferHandshakeReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferHandshakeReq handshakeReq = new PipeTransferHandshakeReq();
        handshakeReq.timestampPrecision = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
        handshakeReq.version = transferReq.version;
        handshakeReq.type = transferReq.type;
        handshakeReq.body = transferReq.body;
        return handshakeReq;
    }
}

