/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.runtime;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginClassLoaderManager;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginExecutableManager;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListResp;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.client.ConfigNodeClientManager;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.service.ResourcesInformationHolder;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipeAgentLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeAgentLauncher.class);
    private static final IoTDBConfig IOTDB_CONFIG = IoTDBDescriptor.getInstance().getConfig();

    private PipeAgentLauncher() {
    }

    public static synchronized void launchPipePluginAgent(ResourcesInformationHolder resourcesInformationHolder) throws StartupException {
        int offset;
        PipeAgentLauncher.initPipePluginRelatedInstances();
        if (resourcesInformationHolder.getPipePluginMetaList() == null || resourcesInformationHolder.getPipePluginMetaList().isEmpty()) {
            return;
        }
        List<PipePluginMeta> uninstalledOrConflictedPipePluginMetaList = PipeAgentLauncher.getUninstalledOrConflictedPipePluginMetaList(resourcesInformationHolder);
        for (int index = 0; index < uninstalledOrConflictedPipePluginMetaList.size(); index += offset + 1) {
            ArrayList curList = new ArrayList();
            for (offset = 0; offset < ResourcesInformationHolder.getJarNumOfOneRpc() && index + offset < uninstalledOrConflictedPipePluginMetaList.size(); ++offset) {
                curList.add(uninstalledOrConflictedPipePluginMetaList.get(index + offset));
            }
            PipeAgentLauncher.fetchAndSavePipePluginJars(curList);
        }
        try {
            for (PipePluginMeta meta : resourcesInformationHolder.getPipePluginMetaList()) {
                if (meta.isBuiltin()) continue;
                PipeAgent.plugin().doRegister(meta);
            }
        }
        catch (Exception e) {
            throw new StartupException((Throwable)e);
        }
    }

    private static void initPipePluginRelatedInstances() throws StartupException {
        try {
            PipePluginExecutableManager.setupAndGetInstance((String)IOTDB_CONFIG.getPipeTemporaryLibDir(), (String)IOTDB_CONFIG.getPipeLibDir());
            PipePluginClassLoaderManager.setupAndGetInstance((String)IOTDB_CONFIG.getPipeLibDir());
        }
        catch (IOException e) {
            throw new StartupException((Throwable)e);
        }
    }

    private static List<PipePluginMeta> getUninstalledOrConflictedPipePluginMetaList(ResourcesInformationHolder resourcesInformationHolder) {
        ArrayList<PipePluginMeta> pipePluginMetaList = new ArrayList<PipePluginMeta>();
        for (PipePluginMeta pipePluginMeta : resourcesInformationHolder.getPipePluginMetaList()) {
            if (pipePluginMeta.isBuiltin()) continue;
            if (!PipePluginExecutableManager.getInstance().hasFileUnderInstallDir(pipePluginMeta.getJarName())) {
                pipePluginMetaList.add(pipePluginMeta);
                continue;
            }
            try {
                if (PipePluginExecutableManager.getInstance().isLocalJarMatched(pipePluginMeta)) continue;
                pipePluginMetaList.add(pipePluginMeta);
            }
            catch (PipeException e) {
                pipePluginMetaList.add(pipePluginMeta);
            }
        }
        return pipePluginMetaList;
    }

    private static void fetchAndSavePipePluginJars(List<PipePluginMeta> pipePluginMetaList) throws StartupException {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            List jarNameList = pipePluginMetaList.stream().map(PipePluginMeta::getJarName).collect(Collectors.toList());
            TGetJarInListResp resp = configNodeClient.getPipePluginJar(new TGetJarInListReq(jarNameList));
            if (resp.getStatus().getCode() == TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()) {
                throw new StartupException("Failed to get pipe plugin jar from config node.");
            }
            List jarList = resp.getJarList();
            for (int i = 0; i < pipePluginMetaList.size(); ++i) {
                PipePluginExecutableManager.getInstance().saveToInstallDir((ByteBuffer)jarList.get(i), pipePluginMetaList.get(i).getJarName());
            }
        }
        catch (IOException | ClientManagerException | TException e) {
            throw new StartupException(e);
        }
    }

    public static synchronized void launchPipeTaskAgent() {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetAllPipeInfoResp getAllPipeInfoResp = configNodeClient.getAllPipeInfo();
            if (getAllPipeInfoResp.getStatus().getCode() == TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()) {
                throw new StartupException("Failed to get pipe task meta from config node.");
            }
            PipeAgent.task().handlePipeMetaChanges(getAllPipeInfoResp.getAllPipeInfo().stream().map(byteBuffer -> {
                PipeMeta pipeMeta = PipeMeta.deserialize((ByteBuffer)byteBuffer);
                LOGGER.info("Pulled pipe meta from config node: {}, recovering ...", (Object)pipeMeta);
                return pipeMeta;
            }).collect(Collectors.toList()));
        }
        catch (Exception e) {
            LOGGER.info("Failed to get pipe task meta from config node. Ignore the exception, because config node may not be ready yet, and meta will be pushed by config node later.", (Throwable)e);
        }
    }
}

