/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SingleDeviceViewNode
extends SingleChildProcessNode {
    private final String device;
    private final List<String> outputColumnNames;
    private final List<Integer> deviceToMeasurementIndexes;
    private boolean cacheOutputColumnNames = false;

    public SingleDeviceViewNode(PlanNodeId id, List<String> outputColumnNames, String device, List<Integer> deviceToMeasurementIndexes) {
        super(id);
        this.device = device;
        this.outputColumnNames = outputColumnNames;
        this.deviceToMeasurementIndexes = deviceToMeasurementIndexes;
    }

    public SingleDeviceViewNode(PlanNodeId id, boolean cacheOutputColumnNames, List<String> outputColumnNames, String device, List<Integer> deviceToMeasurementIndexes) {
        super(id);
        this.device = device;
        this.cacheOutputColumnNames = cacheOutputColumnNames;
        this.outputColumnNames = outputColumnNames;
        this.deviceToMeasurementIndexes = deviceToMeasurementIndexes;
    }

    @Override
    public PlanNode clone() {
        return new SingleDeviceViewNode(this.getPlanNodeId(), this.cacheOutputColumnNames, this.outputColumnNames, this.device, this.deviceToMeasurementIndexes);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setCacheOutputColumnNames(boolean cacheOutputColumnNames) {
        this.cacheOutputColumnNames = cacheOutputColumnNames;
    }

    public String getDevice() {
        return this.device;
    }

    public boolean isCacheOutputColumnNames() {
        return this.cacheOutputColumnNames;
    }

    public List<Integer> getDeviceToMeasurementIndexes() {
        return this.deviceToMeasurementIndexes;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSingleDeviceView(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.SINGLE_DEVICE_VIEW.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.device, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.cacheOutputColumnNames, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.deviceToMeasurementIndexes.size(), (ByteBuffer)byteBuffer);
        for (Integer index : this.deviceToMeasurementIndexes) {
            ReadWriteIOUtils.write((int)index, (ByteBuffer)byteBuffer);
        }
        if (this.cacheOutputColumnNames) {
            ReadWriteIOUtils.write((int)this.outputColumnNames.size(), (ByteBuffer)byteBuffer);
            for (String column : this.outputColumnNames) {
                ReadWriteIOUtils.write((String)column, (ByteBuffer)byteBuffer);
            }
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.SINGLE_DEVICE_VIEW.serialize(stream);
        ReadWriteIOUtils.write((String)this.device, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.cacheOutputColumnNames, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.deviceToMeasurementIndexes.size(), (OutputStream)stream);
        for (Integer index : this.deviceToMeasurementIndexes) {
            ReadWriteIOUtils.write((int)index, (OutputStream)stream);
        }
        if (this.cacheOutputColumnNames) {
            ReadWriteIOUtils.write((int)this.outputColumnNames.size(), (OutputStream)stream);
            for (String column : this.outputColumnNames) {
                ReadWriteIOUtils.write((String)column, (OutputStream)stream);
            }
        }
    }

    public static SingleDeviceViewNode deserialize(ByteBuffer byteBuffer) {
        int listSize;
        String device = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        boolean cacheOutputColumnNames = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        ArrayList<Integer> deviceToMeasurementIndexes = new ArrayList<Integer>(listSize);
        for (listSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); listSize > 0; --listSize) {
            deviceToMeasurementIndexes.add(ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        }
        ArrayList<String> outputColumnNames = null;
        if (cacheOutputColumnNames) {
            outputColumnNames = new ArrayList<String>();
            for (int columnSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); columnSize > 0; --columnSize) {
                outputColumnNames.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
            }
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SingleDeviceViewNode(planNodeId, cacheOutputColumnNames, outputColumnNames, device, deviceToMeasurementIndexes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SingleDeviceViewNode that = (SingleDeviceViewNode)o;
        return this.device.equals(that.device) && this.outputColumnNames.equals(that.outputColumnNames) && this.deviceToMeasurementIndexes.equals(that.deviceToMeasurementIndexes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.device, this.outputColumnNames, this.deviceToMeasurementIndexes);
    }

    public String toString() {
        return "SingleDeviceView-" + this.getPlanNodeId();
    }
}

