/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.visitor;

import java.util.ArrayList;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ReconstructVisitor;

public class RemoveAliasFromExpressionVisitor
extends ReconstructVisitor<Void> {
    @Override
    public Expression process(Expression expression, Void context) {
        Expression resultExpression = expression.accept(this, context);
        resultExpression.setViewPath(null);
        return resultExpression;
    }

    @Override
    public Expression visitFunctionExpression(FunctionExpression functionExpression, Void context) {
        ArrayList<Expression> childResult = new ArrayList<Expression>();
        functionExpression.getExpressions().forEach(child -> childResult.add(this.process((Expression)child, null)));
        return new FunctionExpression(functionExpression.getFunctionName().toLowerCase(), functionExpression.getFunctionAttributes(), childResult);
    }

    @Override
    public Expression visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Void context) {
        PartialPath rawPath = timeSeriesOperand.getPath();
        PartialPath newPath = rawPath.copy();
        if (newPath.isMeasurementAliasExists()) {
            ((MeasurementPath)newPath).removeMeasurementAlias();
        }
        return new TimeSeriesOperand(newPath);
    }
}

