/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.visitor;

import java.util.ArrayList;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ReconstructVisitor;

public class GetMeasurementExpressionVisitor
extends ReconstructVisitor<Void> {
    @Override
    public Expression process(Expression expression, Void context) {
        Expression newExpression = expression.accept(this, context);
        if (expression.getViewPath() != null) {
            PartialPath viewPath = expression.getViewPath();
            newExpression.setViewPath(new PartialPath(viewPath.getMeasurement(), false));
        }
        return newExpression;
    }

    @Override
    public Expression visitFunctionExpression(FunctionExpression functionExpression, Void context) {
        ArrayList<Expression> childExpressions = new ArrayList<Expression>();
        for (Expression suffixExpression : functionExpression.getExpressions()) {
            childExpressions.add(this.process(suffixExpression, null));
        }
        return new FunctionExpression(functionExpression.getFunctionName(), functionExpression.getFunctionAttributes(), childExpressions);
    }

    @Override
    public Expression visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Void context) {
        MeasurementPath rawPath = (MeasurementPath)timeSeriesOperand.getPath();
        PartialPath measurement = new PartialPath(rawPath.getMeasurement(), false);
        MeasurementPath measurementWithSchema = new MeasurementPath(measurement, rawPath.getMeasurementSchema());
        if (rawPath.isMeasurementAliasExists()) {
            measurementWithSchema.setMeasurementAlias(rawPath.getMeasurementAlias());
        }
        measurementWithSchema.setTagMap(rawPath.getTagMap());
        return new TimeSeriesOperand((PartialPath)measurementWithSchema);
    }
}

