/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.sys.quota;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSpaceQuota;
import org.apache.iotdb.commons.quotas.SpaceQuotaType;
import org.apache.iotdb.confignode.rpc.thrift.TSpaceQuotaResp;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.sys.quota.ShowSpaceQuotaStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowSpaceQuotaTask
implements IConfigTask {
    private final ShowSpaceQuotaStatement showSpaceQuotaStatement;

    public ShowSpaceQuotaTask(ShowSpaceQuotaStatement showSpaceQuotaStatement) {
        this.showSpaceQuotaStatement = showSpaceQuotaStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showSpaceQuota(this.showSpaceQuotaStatement);
    }

    public static void buildTSBlock(TSpaceQuotaResp resp, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showSpaceQuotaColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        if (resp.getSpaceQuota() != null) {
            for (Map.Entry spaceQuotaEntry : resp.getSpaceQuota().entrySet()) {
                if (((TSpaceQuota)spaceQuotaEntry.getValue()).getDiskSize() != -1L) {
                    builder.getTimeColumnBuilder().writeLong(0L);
                    builder.getColumnBuilder(0).writeBinary(Binary.valueOf((String)((String)spaceQuotaEntry.getKey())));
                    builder.getColumnBuilder(1).writeBinary(Binary.valueOf((String)SpaceQuotaType.diskSize.name()));
                    builder.getColumnBuilder(2).writeBinary(Binary.valueOf((String)(((TSpaceQuota)spaceQuotaEntry.getValue()).getDiskSize() == 0L ? "unlimited" : (float)((TSpaceQuota)spaceQuotaEntry.getValue()).getDiskSize() / 1024.0f + "G")));
                    builder.getColumnBuilder(3).writeBinary(Binary.valueOf((String)((float)((TSpaceQuota)resp.getSpaceQuotaUsage().get(spaceQuotaEntry.getKey())).getDiskSize() / 1024.0f + "G")));
                    builder.declarePosition();
                }
                if (((TSpaceQuota)spaceQuotaEntry.getValue()).getDeviceNum() != -1L) {
                    builder.getTimeColumnBuilder().writeLong(0L);
                    builder.getColumnBuilder(0).writeBinary(Binary.valueOf((String)((String)spaceQuotaEntry.getKey())));
                    builder.getColumnBuilder(1).writeBinary(Binary.valueOf((String)SpaceQuotaType.deviceNum.name()));
                    builder.getColumnBuilder(2).writeBinary(Binary.valueOf((String)(((TSpaceQuota)spaceQuotaEntry.getValue()).getDeviceNum() == 0L ? "unlimited" : ((TSpaceQuota)spaceQuotaEntry.getValue()).getDeviceNum() + "")));
                    builder.getColumnBuilder(3).writeBinary(Binary.valueOf((String)(((TSpaceQuota)resp.getSpaceQuotaUsage().get(spaceQuotaEntry.getKey())).getDeviceNum() + "")));
                    builder.declarePosition();
                }
                if (((TSpaceQuota)spaceQuotaEntry.getValue()).getTimeserieNum() == -1L) continue;
                builder.getTimeColumnBuilder().writeLong(0L);
                builder.getColumnBuilder(0).writeBinary(Binary.valueOf((String)((String)spaceQuotaEntry.getKey())));
                builder.getColumnBuilder(1).writeBinary(Binary.valueOf((String)SpaceQuotaType.timeSeriesNum.name()));
                builder.getColumnBuilder(2).writeBinary(Binary.valueOf((String)(((TSpaceQuota)spaceQuotaEntry.getValue()).getTimeserieNum() == 0L ? "unlimited" : ((TSpaceQuota)spaceQuotaEntry.getValue()).getTimeserieNum() + "")));
                builder.getColumnBuilder(3).writeBinary(Binary.valueOf((String)(((TSpaceQuota)resp.getSpaceQuotaUsage().get(spaceQuotaEntry.getKey())).getTimeserieNum() + "")));
                builder.declarePosition();
            }
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowSpaceQuotaHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

