/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DatabaseSchemaStatement;

public class DatabaseSchemaTask
implements IConfigTask {
    private final DatabaseSchemaStatement databaseSchemaStatement;

    public DatabaseSchemaTask(DatabaseSchemaStatement databaseSchemaStatement) {
        this.databaseSchemaStatement = databaseSchemaStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) {
        switch (this.databaseSchemaStatement.getSubType()) {
            case CREATE: {
                return configTaskExecutor.setDatabase(this.databaseSchemaStatement);
            }
        }
        return configTaskExecutor.alterDatabase(this.databaseSchemaStatement);
    }

    public static TDatabaseSchema constructDatabaseSchema(DatabaseSchemaStatement databaseSchemaStatement) {
        TDatabaseSchema databaseSchema = new TDatabaseSchema();
        databaseSchema.setName(databaseSchemaStatement.getDatabasePath().getFullPath());
        if (databaseSchemaStatement.getTTL() != null) {
            databaseSchema.setTTL(databaseSchemaStatement.getTTL().longValue());
        }
        if (databaseSchemaStatement.getSchemaReplicationFactor() != null) {
            databaseSchema.setSchemaReplicationFactor(databaseSchemaStatement.getSchemaReplicationFactor().intValue());
        }
        if (databaseSchemaStatement.getDataReplicationFactor() != null) {
            databaseSchema.setDataReplicationFactor(databaseSchemaStatement.getDataReplicationFactor().intValue());
        }
        if (databaseSchemaStatement.getTimePartitionInterval() != null) {
            databaseSchema.setTimePartitionInterval(databaseSchemaStatement.getTimePartitionInterval().longValue());
        }
        if (databaseSchemaStatement.getSchemaRegionGroupNum() != null) {
            databaseSchema.setMinSchemaRegionGroupNum(databaseSchemaStatement.getSchemaRegionGroupNum().intValue());
        }
        if (databaseSchemaStatement.getDataRegionGroupNum() != null) {
            databaseSchema.setMinDataRegionGroupNum(databaseSchemaStatement.getDataRegionGroupNum().intValue());
        }
        return databaseSchema;
    }
}

