/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.metric;

import java.util.Arrays;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class SeriesScanCostMetricSet
implements IMetricSet {
    private static final SeriesScanCostMetricSet INSTANCE = new SeriesScanCostMetricSet();
    private static final String LOAD_TIMESERIES_METADATA = "load_timeseries_metadata";
    private static final String ALIGNED = "aligned";
    private static final String NON_ALIGNED = "non_aligned";
    private static final String MEM = "mem";
    private static final String DISK = "disk";
    public static final String LOAD_TIMESERIES_METADATA_ALIGNED_MEM = "load_timeseries_metadata_aligned_mem";
    public static final String LOAD_TIMESERIES_METADATA_ALIGNED_DISK = "load_timeseries_metadata_aligned_disk";
    public static final String LOAD_TIMESERIES_METADATA_NONALIGNED_MEM = "load_timeseries_metadata_non_aligned_mem";
    public static final String LOAD_TIMESERIES_METADATA_NONALIGNED_DISK = "load_timeseries_metadata_non_aligned_disk";
    private Timer loadTimeseriesMetadataAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadTimeseriesMetadataAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadTimeseriesMetadataNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadTimeseriesMetadataNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String READ_TIMESERIES_METADATA = "read_timeseries_metadata";
    private static final String CACHE = "cache";
    private static final String FILE = "file";
    private static final String NULL = "null";
    public static final String READ_TIMESERIES_METADATA_CACHE = "read_timeseries_metadata_cache";
    public static final String READ_TIMESERIES_METADATA_FILE = "read_timeseries_metadata_file";
    private Timer readTimeseriesMetadataCacheTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer readTimeseriesMetadataFileTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String TIMESERIES_METADATA_MODIFICATION = "timeseries_metadata_modification";
    public static final String TIMESERIES_METADATA_MODIFICATION_ALIGNED = "timeseries_metadata_modification_aligned";
    public static final String TIMESERIES_METADATA_MODIFICATION_NONALIGNED = "timeseries_metadata_modification_non_aligned";
    private Timer timeseriesMetadataModificationAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer timeseriesMetadataModificationNonAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String LOAD_CHUNK_METADATA_LIST = "load_chunk_metadata_list";
    public static final String LOAD_CHUNK_METADATA_LIST_ALIGNED_MEM = "load_chunk_metadata_list_aligned_mem";
    public static final String LOAD_CHUNK_METADATA_LIST_ALIGNED_DISK = "load_chunk_metadata_list_aligned_disk";
    public static final String LOAD_CHUNK_METADATA_LIST_NONALIGNED_MEM = "load_chunk_metadata_list_non_aligned_mem";
    public static final String LOAD_CHUNK_METADATA_LIST_NONALIGNED_DISK = "load_chunk_metadata_list_non_aligned_disk";
    private Timer loadChunkMetadataListAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadChunkMetadataListAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadChunkMetadataListNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer loadChunkMetadataListNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String CHUNK_METADATA_MODIFICATION = "chunk_metadata_modification";
    public static final String CHUNK_METADATA_MODIFICATION_ALIGNED_MEM = "chunk_metadata_modification_aligned_mem";
    public static final String CHUNK_METADATA_MODIFICATION_ALIGNED_DISK = "chunk_metadata_modification_aligned_disk";
    public static final String CHUNK_METADATA_MODIFICATION_NONALIGNED_MEM = "chunk_metadata_modification_non_aligned_mem";
    public static final String CHUNK_METADATA_MODIFICATION_NONALIGNED_DISK = "chunk_metadata_modification_non_aligned_disk";
    private Timer chunkMetadataModificationAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer chunkMetadataModificationAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer chunkMetadataModificationNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer chunkMetadataModificationNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String CHUNK_METADATA_FILTER = "chunk_metadata_filter";
    public static final String CHUNK_METADATA_FILTER_ALIGNED_MEM = "chunk_metadata_filter_aligned_mem";
    public static final String CHUNK_METADATA_FILTER_ALIGNED_DISK = "chunk_metadata_filter_aligned_disk";
    public static final String CHUNK_METADATA_FILTER_NONALIGNED_MEM = "chunk_metadata_filter_non_aligned_mem";
    public static final String CHUNK_METADATA_FILTER_NONALIGNED_DISK = "chunk_metadata_filter_non_aligned_disk";
    private Timer chunkMetadataFilterAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer chunkMetadataFilterAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer chunkMetadataFilterNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer chunkMetadataFilterNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String CONSTRUCT_CHUNK_READER = "construct_chunk_reader";
    public static final String CONSTRUCT_CHUNK_READER_ALIGNED_MEM = "construct_chunk_reader_aligned_mem";
    public static final String CONSTRUCT_CHUNK_READER_ALIGNED_DISK = "construct_chunk_reader_aligned_disk";
    public static final String CONSTRUCT_CHUNK_READER_NONALIGNED_MEM = "construct_chunk_reader_non_aligned_mem";
    public static final String CONSTRUCT_CHUNK_READER_NONALIGNED_DISK = "construct_chunk_reader_non_aligned_disk";
    private Timer constructChunkReaderAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer constructChunkReaderAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer constructChunkReaderNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer constructChunkReaderNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String READ_CHUNK = "read_chunk";
    private static final String ALL = "all";
    public static final String READ_CHUNK_ALL = "read_chunk_all";
    public static final String READ_CHUNK_FILE = "read_chunk_file";
    private Timer readChunkAllTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer readChunkFileTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String INIT_CHUNK_READER = "init_chunk_reader";
    public static final String INIT_CHUNK_READER_ALIGNED_MEM = "init_chunk_reader_aligned_mem";
    public static final String INIT_CHUNK_READER_ALIGNED_DISK = "init_chunk_reader_aligned_disk";
    public static final String INIT_CHUNK_READER_NONALIGNED_MEM = "init_chunk_reader_non_aligned_mem";
    public static final String INIT_CHUNK_READER_NONALIGNED_DISK = "init_chunk_reader_non_aligned_disk";
    private Timer initChunkReaderAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer initChunkReaderAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer initChunkReaderNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer initChunkReaderNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String BUILD_TSBLOCK_FROM_PAGE_READER = "build_tsblock_from_page_reader";
    public static final String BUILD_TSBLOCK_FROM_PAGE_READER_ALIGNED_MEM = "build_tsblock_from_page_reader_aligned_mem";
    public static final String BUILD_TSBLOCK_FROM_PAGE_READER_ALIGNED_DISK = "build_tsblock_from_page_reader_aligned_disk";
    public static final String BUILD_TSBLOCK_FROM_PAGE_READER_NONALIGNED_MEM = "build_tsblock_from_page_reader_non_aligned_mem";
    public static final String BUILD_TSBLOCK_FROM_PAGE_READER_NONALIGNED_DISK = "build_tsblock_from_page_reader_non_aligned_disk";
    private Timer buildTsBlockFromPageReaderAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer buildTsBlockFromPageReaderAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer buildTsBlockFromPageReaderNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer buildTsBlockFromPageReaderNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String BUILD_TSBLOCK_FROM_MERGE_READER = "build_tsblock_from_merge_reader";
    public static final String BUILD_TSBLOCK_FROM_MERGE_READER_ALIGNED = "build_tsblock_from_merge_reader_aligned";
    public static final String BUILD_TSBLOCK_FROM_MERGE_READER_NONALIGNED = "build_tsblock_from_merge_reader_non_aligned";
    private Timer buildTsBlockFromMergeReaderAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer buildTsBlockFromMergeReaderNonAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;

    private SeriesScanCostMetricSet() {
    }

    private void bindTimeseriesMetadata(AbstractMetricService metricService) {
        this.loadTimeseriesMetadataAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_TIMESERIES_METADATA, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.loadTimeseriesMetadataAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_TIMESERIES_METADATA, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.loadTimeseriesMetadataNonAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_TIMESERIES_METADATA, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
        this.loadTimeseriesMetadataNonAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_TIMESERIES_METADATA, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
    }

    private void unbindTimeseriesMetadata(AbstractMetricService metricService) {
        this.loadTimeseriesMetadataAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadTimeseriesMetadataAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadTimeseriesMetadataNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadTimeseriesMetadataNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> Arrays.asList(MEM, DISK).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), LOAD_TIMESERIES_METADATA, Tag.TYPE.toString(), type, Tag.FROM.toString(), from})));
    }

    private void bindReadTimeseriesMetadata(AbstractMetricService metricService) {
        this.readTimeseriesMetadataCacheTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), READ_TIMESERIES_METADATA, Tag.TYPE.toString(), NULL, Tag.FROM.toString(), CACHE});
        this.readTimeseriesMetadataFileTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), READ_TIMESERIES_METADATA, Tag.TYPE.toString(), NULL, Tag.FROM.toString(), FILE});
    }

    private void unbindReadTimeseriesMetadata(AbstractMetricService metricService) {
        this.readTimeseriesMetadataCacheTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.readTimeseriesMetadataFileTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(CACHE, FILE).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), READ_TIMESERIES_METADATA, Tag.TYPE.toString(), NULL, Tag.FROM.toString(), from}));
    }

    private void bindTimeseriesMetadataModification(AbstractMetricService metricService) {
        this.timeseriesMetadataModificationAlignedTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), TIMESERIES_METADATA_MODIFICATION, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), NULL});
        this.timeseriesMetadataModificationNonAlignedTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), TIMESERIES_METADATA_MODIFICATION, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), NULL});
    }

    private void unbindTimeseriesMetadataModification(AbstractMetricService metricService) {
        this.timeseriesMetadataModificationAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.timeseriesMetadataModificationNonAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), TIMESERIES_METADATA_MODIFICATION, Tag.TYPE.toString(), type, Tag.FROM.toString(), NULL}));
    }

    private void bindLoadChunkMetadataList(AbstractMetricService metricService) {
        this.loadChunkMetadataListAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_CHUNK_METADATA_LIST, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.loadChunkMetadataListAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_CHUNK_METADATA_LIST, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.loadChunkMetadataListNonAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_CHUNK_METADATA_LIST, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
        this.loadChunkMetadataListNonAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOAD_CHUNK_METADATA_LIST, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
    }

    private void unbindLoadChunkMetadataList(AbstractMetricService metricService) {
        this.loadChunkMetadataListAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadChunkMetadataListAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadChunkMetadataListNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.loadChunkMetadataListNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> Arrays.asList(MEM, DISK).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), LOAD_CHUNK_METADATA_LIST, Tag.TYPE.toString(), type, Tag.FROM.toString(), from})));
    }

    private void bindChunkMetadataModification(AbstractMetricService metricService) {
        this.constructChunkReaderAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_MODIFICATION, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.constructChunkReaderAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_MODIFICATION, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.constructChunkReaderNonAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_MODIFICATION, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
        this.constructChunkReaderNonAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_MODIFICATION, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
    }

    private void unbindChunkMetadataModification(AbstractMetricService metricService) {
        this.chunkMetadataModificationAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.chunkMetadataModificationAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.chunkMetadataModificationNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.chunkMetadataModificationNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> Arrays.asList(MEM, DISK).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), CHUNK_METADATA_MODIFICATION, Tag.TYPE.toString(), type, Tag.FROM.toString(), from})));
    }

    private void bindChunkMetadataFilter(AbstractMetricService metricService) {
        this.chunkMetadataModificationAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_FILTER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.chunkMetadataModificationAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_FILTER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.chunkMetadataModificationNonAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_FILTER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
        this.chunkMetadataModificationNonAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CHUNK_METADATA_FILTER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
    }

    private void unbindChunkMetadataFilter(AbstractMetricService metricService) {
        this.chunkMetadataFilterAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.chunkMetadataFilterAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.chunkMetadataFilterNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.chunkMetadataFilterNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> Arrays.asList(MEM, DISK).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), CHUNK_METADATA_FILTER, Tag.TYPE.toString(), type, Tag.FROM.toString(), from})));
    }

    private void bindConstructChunkReader(AbstractMetricService metricService) {
        this.constructChunkReaderAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.constructChunkReaderAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.constructChunkReaderNonAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
        this.constructChunkReaderNonAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
    }

    private void unbindConstructChunkReader(AbstractMetricService metricService) {
        this.constructChunkReaderAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.constructChunkReaderAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.constructChunkReaderNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.constructChunkReaderNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> Arrays.asList(MEM, DISK).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), CONSTRUCT_CHUNK_READER, Tag.TYPE.toString(), type, Tag.FROM.toString(), from})));
    }

    private void bindReadChunk(AbstractMetricService metricService) {
        this.readChunkAllTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), READ_CHUNK, Tag.TYPE.toString(), NULL, Tag.FROM.toString(), ALL});
        this.readChunkFileTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), READ_CHUNK, Tag.TYPE.toString(), NULL, Tag.FROM.toString(), FILE});
    }

    private void unbindReadChunk(AbstractMetricService metricService) {
        this.readChunkAllTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.readChunkFileTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALL, FILE).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), READ_CHUNK, Tag.TYPE.toString(), NULL, Tag.FROM.toString(), from}));
    }

    private void bindInitChunkReader(AbstractMetricService metricService) {
        this.initChunkReaderAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), INIT_CHUNK_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.initChunkReaderAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), INIT_CHUNK_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.initChunkReaderNonAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), INIT_CHUNK_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
        this.initChunkReaderNonAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), INIT_CHUNK_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
    }

    private void unbindInitChunkReader(AbstractMetricService metricService) {
        this.initChunkReaderAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.initChunkReaderAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.initChunkReaderNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.initChunkReaderNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> Arrays.asList(MEM, DISK).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), INIT_CHUNK_READER, Tag.TYPE.toString(), type, Tag.FROM.toString(), from})));
    }

    private void bindTsBlockFromPageReader(AbstractMetricService metricService) {
        this.buildTsBlockFromPageReaderAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), MEM});
        this.buildTsBlockFromPageReaderAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), ALIGNED, Tag.FROM.toString(), DISK});
        this.buildTsBlockFromPageReaderNonAlignedMemTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), MEM});
        this.buildTsBlockFromPageReaderNonAlignedDiskTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), NON_ALIGNED, Tag.FROM.toString(), DISK});
    }

    private void unbindTsBlockFromPageReader(AbstractMetricService metricService) {
        this.buildTsBlockFromPageReaderAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.buildTsBlockFromPageReaderAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.buildTsBlockFromPageReaderNonAlignedMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.buildTsBlockFromPageReaderNonAlignedDiskTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> Arrays.asList(MEM, DISK).forEach(from -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_PAGE_READER, Tag.TYPE.toString(), type, Tag.FROM.toString(), from})));
    }

    private void bindBuildTsBlockFromMergeReader(AbstractMetricService metricService) {
        this.buildTsBlockFromMergeReaderAlignedTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_MERGE_READER, Tag.FROM.toString(), NULL, Tag.TYPE.toString(), ALIGNED});
        this.buildTsBlockFromMergeReaderNonAlignedTimer = metricService.getOrCreateTimer(Metric.SERIES_SCAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_MERGE_READER, Tag.FROM.toString(), NULL, Tag.TYPE.toString(), NON_ALIGNED});
    }

    private void unbindBuildTsBlockFromMergeReader(AbstractMetricService metricService) {
        this.buildTsBlockFromMergeReaderAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.buildTsBlockFromMergeReaderNonAlignedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(ALIGNED, NON_ALIGNED).forEach(type -> metricService.remove(MetricType.TIMER, Metric.SERIES_SCAN_COST.toString(), new String[]{Tag.STAGE.toString(), BUILD_TSBLOCK_FROM_MERGE_READER, Tag.FROM.toString(), NULL, Tag.TYPE.toString(), type}));
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindTimeseriesMetadata(metricService);
        this.bindReadTimeseriesMetadata(metricService);
        this.bindTimeseriesMetadataModification(metricService);
        this.bindLoadChunkMetadataList(metricService);
        this.bindChunkMetadataModification(metricService);
        this.bindChunkMetadataFilter(metricService);
        this.bindConstructChunkReader(metricService);
        this.bindReadChunk(metricService);
        this.bindInitChunkReader(metricService);
        this.bindTsBlockFromPageReader(metricService);
        this.bindBuildTsBlockFromMergeReader(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindTimeseriesMetadata(metricService);
        this.unbindReadTimeseriesMetadata(metricService);
        this.unbindTimeseriesMetadataModification(metricService);
        this.unbindLoadChunkMetadataList(metricService);
        this.unbindChunkMetadataModification(metricService);
        this.unbindChunkMetadataFilter(metricService);
        this.unbindConstructChunkReader(metricService);
        this.unbindReadChunk(metricService);
        this.unbindInitChunkReader(metricService);
        this.unbindTsBlockFromPageReader(metricService);
        this.unbindBuildTsBlockFromMergeReader(metricService);
    }

    public void recordSeriesScanCost(String type, long cost) {
        switch (type) {
            case "load_timeseries_metadata_aligned_mem": {
                this.loadTimeseriesMetadataAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "load_timeseries_metadata_aligned_disk": {
                this.loadTimeseriesMetadataAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "load_timeseries_metadata_non_aligned_mem": {
                this.loadTimeseriesMetadataNonAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "load_timeseries_metadata_non_aligned_disk": {
                this.loadTimeseriesMetadataNonAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "timeseries_metadata_modification_aligned": {
                this.timeseriesMetadataModificationAlignedTimer.updateNanos(cost);
                break;
            }
            case "timeseries_metadata_modification_non_aligned": {
                this.timeseriesMetadataModificationNonAlignedTimer.updateNanos(cost);
                break;
            }
            case "load_chunk_metadata_list_aligned_mem": {
                this.loadChunkMetadataListAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "load_chunk_metadata_list_aligned_disk": {
                this.loadChunkMetadataListAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "load_chunk_metadata_list_non_aligned_mem": {
                this.loadChunkMetadataListNonAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "load_chunk_metadata_list_non_aligned_disk": {
                this.loadChunkMetadataListNonAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_filter_aligned_mem": {
                this.chunkMetadataFilterAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_filter_aligned_disk": {
                this.chunkMetadataFilterAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_filter_non_aligned_mem": {
                this.chunkMetadataFilterNonAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_filter_non_aligned_disk": {
                this.chunkMetadataFilterNonAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_modification_aligned_mem": {
                this.chunkMetadataModificationAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_modification_aligned_disk": {
                this.chunkMetadataModificationAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_modification_non_aligned_mem": {
                this.chunkMetadataModificationNonAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "chunk_metadata_modification_non_aligned_disk": {
                this.chunkMetadataModificationNonAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "init_chunk_reader_aligned_mem": {
                this.initChunkReaderAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "init_chunk_reader_aligned_disk": {
                this.initChunkReaderAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "init_chunk_reader_non_aligned_mem": {
                this.initChunkReaderNonAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "init_chunk_reader_non_aligned_disk": {
                this.initChunkReaderNonAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "construct_chunk_reader_aligned_mem": {
                this.constructChunkReaderAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "construct_chunk_reader_aligned_disk": {
                this.constructChunkReaderAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "construct_chunk_reader_non_aligned_mem": {
                this.constructChunkReaderNonAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "construct_chunk_reader_non_aligned_disk": {
                this.constructChunkReaderNonAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "build_tsblock_from_page_reader_aligned_mem": {
                this.buildTsBlockFromPageReaderAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "build_tsblock_from_page_reader_aligned_disk": {
                this.buildTsBlockFromPageReaderAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "build_tsblock_from_page_reader_non_aligned_mem": {
                this.buildTsBlockFromPageReaderNonAlignedMemTimer.updateNanos(cost);
                break;
            }
            case "build_tsblock_from_page_reader_non_aligned_disk": {
                this.buildTsBlockFromPageReaderNonAlignedDiskTimer.updateNanos(cost);
                break;
            }
            case "build_tsblock_from_merge_reader_aligned": {
                this.buildTsBlockFromMergeReaderAlignedTimer.updateNanos(cost);
                break;
            }
            case "build_tsblock_from_merge_reader_non_aligned": {
                this.buildTsBlockFromMergeReaderNonAlignedTimer.updateNanos(cost);
                break;
            }
            case "read_timeseries_metadata_cache": {
                this.readTimeseriesMetadataCacheTimer.updateNanos(cost);
                break;
            }
            case "read_timeseries_metadata_file": {
                this.readTimeseriesMetadataFileTimer.updateNanos(cost);
                break;
            }
            case "read_chunk_all": {
                this.readChunkAllTimer.updateNanos(cost);
                break;
            }
            case "read_chunk_file": {
                this.readChunkFileTimer.updateNanos(cost);
                break;
            }
        }
    }

    public static SeriesScanCostMetricSet getInstance() {
        return INSTANCE;
    }
}

