/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.metric;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.mpp.execution.schedule.DriverScheduler;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class DriverSchedulerMetricSet
implements IMetricSet {
    private static final DriverSchedulerMetricSet INSTANCE = new DriverSchedulerMetricSet();
    public static final String READY_QUEUED_TIME = "ready_queued_time";
    public static final String BLOCK_QUEUED_TIME = "block_queued_time";
    public static final String READY_QUEUE_TASK_COUNT = "ready_queue_task_count";
    public static final String BLOCK_QUEUE_TASK_COUNT = "block_queue_task_count";
    private static final String TIMEOUT_QUEUE_SIZE = "timeout_queue_task_count";
    private static final String QUERY_MAP_SIZE = "query_map_size";
    private Timer readyQueuedTimeTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer blockQueuedTimeTimer = DoNothingMetricManager.DO_NOTHING_TIMER;

    private DriverSchedulerMetricSet() {
    }

    public void bindTo(AbstractMetricService metricService) {
        this.readyQueuedTimeTimer = metricService.getOrCreateTimer(Metric.DRIVER_SCHEDULER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), READY_QUEUED_TIME});
        this.blockQueuedTimeTimer = metricService.getOrCreateTimer(Metric.DRIVER_SCHEDULER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), BLOCK_QUEUED_TIME});
        metricService.createAutoGauge(Metric.DRIVER_SCHEDULER.toString(), MetricLevel.IMPORTANT, (Object)DriverScheduler.getInstance(), DriverScheduler::getReadyQueueTaskCount, new String[]{Tag.NAME.toString(), READY_QUEUE_TASK_COUNT});
        metricService.createAutoGauge(Metric.DRIVER_SCHEDULER.toString(), MetricLevel.IMPORTANT, (Object)DriverScheduler.getInstance(), DriverScheduler::getBlockQueueTaskCount, new String[]{Tag.NAME.toString(), BLOCK_QUEUE_TASK_COUNT});
        metricService.createAutoGauge(Metric.DRIVER_SCHEDULER.toString(), MetricLevel.IMPORTANT, (Object)DriverScheduler.getInstance(), DriverScheduler::getTimeoutQueueTaskCount, new String[]{Tag.NAME.toString(), TIMEOUT_QUEUE_SIZE});
        metricService.createAutoGauge(Metric.DRIVER_SCHEDULER.toString(), MetricLevel.IMPORTANT, (Object)DriverScheduler.getInstance(), DriverScheduler::getQueryMapSize, new String[]{Tag.NAME.toString(), QUERY_MAP_SIZE});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.DRIVER_SCHEDULER.toString(), new String[]{Tag.NAME.toString(), TIMEOUT_QUEUE_SIZE});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.DRIVER_SCHEDULER.toString(), new String[]{Tag.NAME.toString(), QUERY_MAP_SIZE});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.readyQueuedTimeTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.blockQueuedTimeTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        metricService.remove(MetricType.TIMER, Metric.DRIVER_SCHEDULER.toString(), new String[]{Tag.NAME.toString(), READY_QUEUED_TIME});
        metricService.remove(MetricType.TIMER, Metric.DRIVER_SCHEDULER.toString(), new String[]{Tag.NAME.toString(), BLOCK_QUEUED_TIME});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.DRIVER_SCHEDULER.toString(), new String[]{Tag.NAME.toString(), READY_QUEUE_TASK_COUNT});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.DRIVER_SCHEDULER.toString(), new String[]{Tag.NAME.toString(), BLOCK_QUEUE_TASK_COUNT});
    }

    public void recordTaskQueueTime(String name, long queueTimeInNanos) {
        switch (name) {
            case "ready_queued_time": {
                this.readyQueuedTimeTimer.updateNanos(queueTimeInNanos);
                break;
            }
            case "block_queued_time": {
                this.blockQueuedTimeTimer.updateNanos(queueTimeInNanos);
                break;
            }
        }
    }

    public static DriverSchedulerMetricSet getInstance() {
        return INSTANCE;
    }
}

