/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule;

import org.apache.iotdb.db.mpp.execution.schedule.AbstractDriverThread;
import org.apache.iotdb.db.mpp.execution.schedule.ITaskScheduler;
import org.apache.iotdb.db.mpp.execution.schedule.ThreadProducer;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IndexedBlockingQueue;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverTaskTimeoutSentinelThread
extends AbstractDriverThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverTaskTimeoutSentinelThread.class);

    public DriverTaskTimeoutSentinelThread(String workerId, ThreadGroup tg, IndexedBlockingQueue<DriverTask> queue, ITaskScheduler scheduler, ThreadProducer producer) {
        super(workerId, tg, queue, scheduler, producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(DriverTask task) throws InterruptedException {
        task.lock();
        try {
            if (task.isEndState()) {
                return;
            }
        }
        finally {
            task.unlock();
        }
        long waitTime = task.getDDL() - System.currentTimeMillis();
        while (waitTime > 0L) {
            Thread.sleep(waitTime);
            waitTime = task.getDDL() - System.currentTimeMillis();
        }
        task.lock();
        try {
            if (task.isEndState()) {
                return;
            }
        }
        finally {
            task.unlock();
        }
        LOGGER.warn("[DriverTaskTimeout] Current time is {}, ddl of task is {}", (Object)System.currentTimeMillis(), (Object)task.getDDL());
        task.setAbortCause("timeout");
        this.scheduler.toAborted(task);
    }
}

