/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class CountMergeOperator
implements ProcessOperator {
    private final PlanNodeId planNodeId;
    private final OperatorContext operatorContext;
    private final TsBlock[] childrenTsBlocks;
    private List<TsBlock> resultTsBlockList;
    private int currentIndex = 0;
    private final List<Operator> children;

    public CountMergeOperator(PlanNodeId planNodeId, OperatorContext operatorContext, List<Operator> children) {
        this.planNodeId = planNodeId;
        this.operatorContext = operatorContext;
        this.children = children;
        this.childrenTsBlocks = new TsBlock[children.size()];
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ArrayList listenableFutureList = new ArrayList(this.children.size());
        for (int i = 0; i < this.children.size(); ++i) {
            ListenableFuture<?> blocked;
            if (this.childrenTsBlocks[i] != null || (blocked = this.children.get(i).isBlocked()).isDone()) continue;
            listenableFutureList.add(blocked);
        }
        return listenableFutureList.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutureList);
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.resultTsBlockList != null) {
            ++this.currentIndex;
            return this.resultTsBlockList.get(this.currentIndex - 1);
        }
        boolean allChildrenReady = true;
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.childrenTsBlocks[i] != null || !this.children.get(i).hasNextWithTimer()) continue;
            TsBlock tsBlock = this.children.get(i).nextWithTimer();
            if (tsBlock == null || tsBlock.isEmpty()) {
                allChildrenReady = false;
                continue;
            }
            this.childrenTsBlocks[i] = tsBlock;
        }
        if (allChildrenReady) {
            this.generateResultTsBlockList();
            ++this.currentIndex;
            return this.resultTsBlockList.get(this.currentIndex - 1);
        }
        return null;
    }

    private void generateResultTsBlockList() {
        long totalCount = 0L;
        for (TsBlock tsBlock : this.childrenTsBlocks) {
            long count = tsBlock.getColumn(0).getLong(0);
            totalCount += count;
        }
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT64));
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeLong(totalCount);
        tsBlockBuilder.declarePosition();
        this.resultTsBlockList = Collections.singletonList(tsBlockBuilder.build());
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.resultTsBlockList == null || this.currentIndex < this.resultTsBlockList.size();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public long calculateMaxPeekMemory() {
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, child.calculateMaxPeekMemory());
        }
        return childrenMaxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        long childrenMaxReturnSize = 0L;
        for (Operator child : this.children) {
            childrenMaxReturnSize = Math.max(childrenMaxReturnSize, child.calculateMaxReturnSize());
        }
        return childrenMaxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long retainedSize = 0L;
        for (Operator child : this.children) {
            retainedSize += child.calculateRetainedSizeAfterCallingNext();
        }
        return retainedSize;
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }
}

