/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.fill.linear;

import java.util.Optional;
import org.apache.iotdb.db.mpp.execution.operator.process.fill.linear.LinearFill;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumn;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumnBuilder;

public class IntLinearFill
extends LinearFill {
    private int previousValue;
    private int nextValue;
    private int nextValueInCurrentColumn;

    @Override
    void fillValue(Column column, int index, Object array) {
        ((int[])array)[index] = column.getInt(index);
    }

    @Override
    void fillValue(Object array, int index) {
        ((int[])array)[index] = this.getFilledValue();
    }

    @Override
    Object createValueArray(int size) {
        return new int[size];
    }

    @Override
    Column createNullValueColumn() {
        return IntColumnBuilder.NULL_VALUE_BLOCK;
    }

    @Override
    Column createFilledValueColumn() {
        int filledValue = this.getFilledValue();
        return new IntColumn(1, Optional.empty(), new int[]{filledValue});
    }

    @Override
    Column createFilledValueColumn(Object array, boolean[] isNull, boolean hasNullValue, int size) {
        if (hasNullValue) {
            return new IntColumn(size, Optional.of(isNull), (int[])array);
        }
        return new IntColumn(size, Optional.empty(), (int[])array);
    }

    @Override
    void updatePreviousValue(Column column, int index) {
        this.previousValue = column.getInt(index);
    }

    @Override
    void updateNextValue(Column nextValueColumn, int index) {
        this.nextValue = nextValueColumn.getInt(index);
    }

    @Override
    void updateNextValueInCurrentColumn(Column nextValueColumn, int index) {
        this.nextValueInCurrentColumn = nextValueColumn.getInt(index);
    }

    @Override
    void updateNextValueInCurrentColumn() {
        this.nextValueInCurrentColumn = this.nextValue;
    }

    private int getFilledValue() {
        return (this.previousValue + this.nextValueInCurrentColumn) / 2;
    }
}

