/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaregion;

import java.io.File;
import java.util.Objects;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.slf4j.Logger;

public class SchemaRegionUtils {
    public static void deleteSchemaRegionFolder(String schemaRegionDirPath, Logger logger) throws MetadataException {
        File schemaRegionDir = SystemFileFactory.INSTANCE.getFile(schemaRegionDirPath);
        File[] sgFiles = schemaRegionDir.listFiles();
        if (sgFiles == null) {
            throw new MetadataException(String.format("Can't get files in schema region dir %s", schemaRegionDirPath));
        }
        for (File file : sgFiles) {
            if (!file.delete()) {
                logger.info("delete schema region file {} failed.", (Object)file.getAbsolutePath());
                throw new MetadataException(String.format("Failed to delete schema region file %s", file.getAbsolutePath()));
            }
            logger.info("delete schema region file {}", (Object)file.getAbsolutePath());
        }
        if (!schemaRegionDir.delete()) {
            logger.info("delete schema region folder {} failed.", (Object)schemaRegionDir.getAbsolutePath());
            throw new MetadataException(String.format("Failed to delete schema region folder %s", schemaRegionDir.getAbsolutePath()));
        }
        logger.info("delete schema region folder {}", (Object)schemaRegionDir.getAbsolutePath());
        File storageGroupDir = schemaRegionDir.getParentFile();
        if (Objects.requireNonNull(storageGroupDir.listFiles()).length == 0) {
            storageGroupDir.delete();
        }
    }
}

