/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.MNodeFactory;
import org.apache.iotdb.db.metadata.mnode.mem.IMemMNode;
import org.apache.iotdb.db.metadata.mnode.schemafile.ICachedMNode;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;

public class MNodeFactoryLoader {
    private final List<String> scanPackages = new ArrayList<String>();
    private String env;
    private volatile IMNodeFactory<ICachedMNode> cachedMNodeIMNodeFactory;
    private volatile IMNodeFactory<IMemMNode> memMNodeIMNodeFactory;

    private MNodeFactoryLoader() {
        this.addScanPackage("org.apache.iotdb.db.metadata.mnode.mem.factory");
        this.addScanPackage("org.apache.iotdb.db.metadata.mnode.schemafile.factory");
        this.setEnv("IoTDB");
    }

    public void addScanPackage(String scanPackage) {
        this.scanPackages.add(scanPackage);
    }

    public void setEnv(String env) {
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMNodeFactory<ICachedMNode> getCachedMNodeIMNodeFactory() {
        if (this.cachedMNodeIMNodeFactory == null) {
            MNodeFactoryLoader mNodeFactoryLoader = this;
            synchronized (mNodeFactoryLoader) {
                if (this.cachedMNodeIMNodeFactory == null) {
                    this.cachedMNodeIMNodeFactory = this.loadMNodeFactory(ICachedMNode.class);
                }
            }
        }
        return this.cachedMNodeIMNodeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMNodeFactory<IMemMNode> getMemMNodeIMNodeFactory() {
        if (this.memMNodeIMNodeFactory == null) {
            MNodeFactoryLoader mNodeFactoryLoader = this;
            synchronized (mNodeFactoryLoader) {
                if (this.memMNodeIMNodeFactory == null) {
                    this.memMNodeIMNodeFactory = this.loadMNodeFactory(IMemMNode.class);
                }
            }
        }
        return this.memMNodeIMNodeFactory;
    }

    private IMNodeFactory loadMNodeFactory(Class<?> nodeType) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackages(this.scanPackages.toArray(new String[0])));
        Set nodeFactorySet = reflections.getTypesAnnotatedWith(MNodeFactory.class);
        for (Class nodeFactory : nodeFactorySet) {
            if (!this.isGenericMatch(nodeFactory, nodeType) || !this.isEnvMatch(nodeFactory, this.env)) continue;
            try {
                return (IMNodeFactory)nodeFactory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (Class nodeFactory : nodeFactorySet) {
            if (!this.isGenericMatch(nodeFactory, nodeType) || !this.isEnvMatch(nodeFactory, "IoTDB")) continue;
            try {
                return (IMNodeFactory)nodeFactory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("No satisfied MNodeFactory found");
    }

    public boolean isGenericMatch(Class<?> factory, Class<?> targetType) {
        Type[] interfaces;
        for (Type type : interfaces = factory.getGenericInterfaces()) {
            Type[] typeArguments;
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type typeArgument : typeArguments = parameterizedType.getActualTypeArguments()) {
                if (!(typeArgument instanceof Class) || !targetType.isAssignableFrom((Class)typeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isEnvMatch(Class<?> factory, String env) {
        MNodeFactory annotationInfo = factory.getAnnotation(MNodeFactory.class);
        return annotationInfo.env().equals(env);
    }

    public static MNodeFactoryLoader getInstance() {
        return MNodeFactoryLoaderHolder.INSTANCE;
    }

    private static class MNodeFactoryLoaderHolder {
        private static final MNodeFactoryLoader INSTANCE = new MNodeFactoryLoader();

        private MNodeFactoryLoaderHolder() {
        }
    }
}

