/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode.mem.info;

import org.apache.iotdb.commons.schema.node.info.IMeasurementInfo;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class MeasurementInfo
implements IMeasurementInfo {
    protected String alias;
    private long offset = -1L;
    private IMeasurementSchema schema;
    private boolean preDeleted = false;
    private static final int ALIAS_BASE_SIZE = 52;

    public MeasurementInfo(IMeasurementSchema schema, String alias) {
        this.schema = schema;
        this.alias = alias;
    }

    public void moveDataToNewMNode(IMeasurementMNode<?> newMNode) {
        newMNode.setSchema(this.schema);
        newMNode.setAlias(this.alias);
        newMNode.setOffset(this.offset);
        newMNode.setPreDeleted(this.preDeleted);
    }

    public IMeasurementSchema getSchema() {
        return this.schema;
    }

    public void setSchema(IMeasurementSchema schema) {
        this.schema = schema;
    }

    public TSDataType getDataType() {
        return this.schema.getType();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public boolean isPreDeleted() {
        return this.preDeleted;
    }

    public void setPreDeleted(boolean preDeleted) {
        this.preDeleted = preDeleted;
    }

    public int estimateSize() {
        return 57 + (this.alias == null ? 0 : 52 + this.alias.length());
    }
}

