/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode.mem.info;

import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.info.IMeasurementInfo;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpressionType;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.TimeSeriesViewOperand;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class LogicalViewInfo
implements IMeasurementInfo {
    private long offset = -1L;
    private boolean preDeleted = false;
    private LogicalViewSchema schema;

    public LogicalViewInfo(LogicalViewSchema schema) {
        this.schema = schema;
    }

    public boolean isAliasSeries() {
        return this.getExpression() != null && this.getExpression().isSourceForAliasSeries();
    }

    public PartialPath getAliasSeriesPath() {
        if (this.isAliasSeries() && this.getExpression().getExpressionType() == ViewExpressionType.TIMESERIES) {
            String pathString = ((TimeSeriesViewOperand)this.getExpression()).getPathString();
            try {
                return new PartialPath(pathString);
            }
            catch (IllegalPathException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public ViewExpression getExpression() {
        return this.schema.getExpression();
    }

    public void setExpression(ViewExpression expression) {
        this.schema.setExpression(expression);
    }

    public IMeasurementSchema getSchema() {
        return this.schema;
    }

    public void setSchema(IMeasurementSchema schema) {
        if (schema.isLogicalView()) {
            this.schema = (LogicalViewSchema)schema;
        }
    }

    public TSDataType getDataType() {
        return null;
    }

    public String getAlias() {
        return null;
    }

    public void setAlias(String alias) {
        throw new UnsupportedOperationException("View doesn't support alias");
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public boolean isPreDeleted() {
        return this.preDeleted;
    }

    public void setPreDeleted(boolean preDeleted) {
        this.preDeleted = preDeleted;
    }

    public int estimateSize() {
        return 113;
    }

    public void moveDataToNewMNode(IMeasurementMNode<?> newMNode) {
        if (newMNode.isLogicalView()) {
            newMNode.setSchema((IMeasurementSchema)this.schema);
            newMNode.setPreDeleted(this.preDeleted);
        }
        throw new RuntimeException(new IllegalArgumentException("Type of newMNode is not LogicalViewMNode! It's " + newMNode.getMNodeType(Boolean.valueOf(false)).toString()));
    }
}

