/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.exception.metadata;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.rpc.TSStatusCode;

public class DatabaseAlreadySetException
extends MetadataException {
    private static final long serialVersionUID = 9110669164701929779L;
    private final boolean hasChild;
    private final String storageGroupPath;

    public DatabaseAlreadySetException(String path) {
        super(DatabaseAlreadySetException.getMessage(path, false), TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode());
        this.storageGroupPath = path;
        this.hasChild = false;
    }

    public DatabaseAlreadySetException(String path, boolean hasChild) {
        super(DatabaseAlreadySetException.getMessage(path, hasChild), TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode());
        this.hasChild = hasChild;
        this.storageGroupPath = path;
    }

    public boolean isHasChild() {
        return this.hasChild;
    }

    public String getStorageGroupPath() {
        return this.storageGroupPath;
    }

    private static String getMessage(String path, boolean hasChild) {
        if (hasChild) {
            return String.format("some children of %s have already been created as database", path);
        }
        return String.format("%s has already been created as database", path);
    }
}

