/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.engine.storagegroup.ILastFlushTimeMap;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceEntry;

public class IDTableLastFlushTimeMap
implements ILastFlushTimeMap {
    long LONG_SIZE = 24L;
    long HASHMAP_NODE_BASIC_SIZE = 14L + this.LONG_SIZE + this.LONG_SIZE;
    IDTable idTable;
    TsFileManager tsFileManager;
    private Map<Long, Long> memCostForEachPartition = new HashMap<Long, Long>();
    private Set<Long> partitionSet = new HashSet<Long>();

    public IDTableLastFlushTimeMap(IDTable idTable, TsFileManager tsFileManager) {
        this.idTable = idTable;
        this.tsFileManager = tsFileManager;
    }

    @Override
    public void setMultiDeviceFlushedTime(long timePartitionId, Map<String, Long> flushedTimeMap) {
        for (Map.Entry<String, Long> entry : flushedTimeMap.entrySet()) {
            if (this.idTable.getDeviceEntry(entry.getKey()).putFlushTimeMap(timePartitionId, entry.getValue()) != null) continue;
            this.memCostForEachPartition.compute(timePartitionId, (k, v) -> v == null ? this.HASHMAP_NODE_BASIC_SIZE : v + this.HASHMAP_NODE_BASIC_SIZE);
        }
    }

    @Override
    public void setOneDeviceFlushedTime(long timePartitionId, String path, long time) {
        if (this.idTable.getDeviceEntry(path).putFlushTimeMap(timePartitionId, time) == null) {
            this.memCostForEachPartition.compute(timePartitionId, (k, v) -> v == null ? this.HASHMAP_NODE_BASIC_SIZE : v + this.HASHMAP_NODE_BASIC_SIZE);
        }
    }

    @Override
    public void setMultiDeviceGlobalFlushedTime(Map<String, Long> globalFlushedTimeMap) {
        for (Map.Entry<String, Long> entry : globalFlushedTimeMap.entrySet()) {
            this.idTable.getDeviceEntry(entry.getKey()).setGlobalFlushTime(entry.getValue());
        }
    }

    @Override
    public void setOneDeviceGlobalFlushedTime(String path, long time) {
        this.idTable.getDeviceEntry(path).setGlobalFlushTime(time);
    }

    @Override
    public void updateFlushedTime(long timePartitionId, String path, long time) {
        if (this.idTable.getDeviceEntry(path).getFlushTime(timePartitionId) == null) {
            this.memCostForEachPartition.compute(timePartitionId, (k, v) -> v == null ? this.HASHMAP_NODE_BASIC_SIZE : v + this.HASHMAP_NODE_BASIC_SIZE);
        }
        this.idTable.getDeviceEntry(path).updateFlushTimeMap(timePartitionId, time);
    }

    @Override
    public void updateGlobalFlushedTime(String path, long time) {
        this.idTable.getDeviceEntry(path).updateGlobalFlushTime(time);
    }

    @Override
    public void updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(long partitionId, String deviceId, long time) {
        throw new UnsupportedOperationException("IDTableFlushTimeManager doesn't support upgrade");
    }

    @Override
    public boolean checkAndCreateFlushedTimePartition(long timePartitionId) {
        return !this.partitionSet.add(timePartitionId);
    }

    @Override
    public void applyNewlyFlushedTimeToFlushedTime() {
        throw new UnsupportedOperationException("IDTableFlushTimeManager doesn't support upgrade");
    }

    @Override
    public void updateLatestFlushTime(long partitionId, Map<String, Long> updateMap) {
        for (Map.Entry<String, Long> entry : updateMap.entrySet()) {
            DeviceEntry deviceEntry = this.idTable.getDeviceEntry(entry.getKey());
            deviceEntry.updateFlushTimeMap(partitionId, entry.getValue());
            if (deviceEntry.getGlobalFlushTime() >= entry.getValue()) continue;
            deviceEntry.setGlobalFlushTime(entry.getValue());
        }
    }

    @Override
    public long getFlushedTime(long timePartitionId, String path) {
        Long flushTime = this.idTable.getDeviceEntry(path).getFlushTime(timePartitionId);
        if (flushTime != null) {
            return flushTime;
        }
        long time = this.recoverFlushTime(timePartitionId, path);
        this.idTable.getDeviceEntry(path).updateFlushTimeMap(timePartitionId, time);
        return time;
    }

    @Override
    public long getGlobalFlushedTime(String path) {
        return this.idTable.getDeviceEntry(path).getGlobalFlushTime();
    }

    @Override
    public void clearFlushedTime() {
        for (DeviceEntry deviceEntry : this.idTable.getAllDeviceEntry()) {
            deviceEntry.clearFlushTime();
        }
    }

    @Override
    public void clearGlobalFlushedTime() {
        for (DeviceEntry deviceEntry : this.idTable.getAllDeviceEntry()) {
            deviceEntry.setGlobalFlushTime(Long.MIN_VALUE);
        }
    }

    @Override
    public void removePartition(long partitionId) {
        for (DeviceEntry deviceEntry : this.idTable.getAllDeviceEntry()) {
            deviceEntry.removePartition(partitionId);
        }
        this.partitionSet.remove(partitionId);
        this.memCostForEachPartition.remove(partitionId);
    }

    private long recoverFlushTime(long partitionId, String devicePath) {
        TsFileResourceList tsFileResourceList = this.tsFileManager.getOrCreateSequenceListByTimePartition(partitionId);
        for (int i = tsFileResourceList.size() - 1; i >= 0; --i) {
            if (!((TsFileResource)tsFileResourceList.get((int)i)).timeIndex.mayContainsDevice(devicePath)) continue;
            return ((TsFileResource)tsFileResourceList.get((int)i)).timeIndex.getEndTime(devicePath);
        }
        this.memCostForEachPartition.compute(partitionId, (k, v) -> v == null ? this.HASHMAP_NODE_BASIC_SIZE : v + this.HASHMAP_NODE_BASIC_SIZE);
        return Long.MIN_VALUE;
    }

    @Override
    public long getMemSize(long partitionId) {
        if (this.memCostForEachPartition.containsKey(partitionId)) {
            return this.memCostForEachPartition.get(partitionId);
        }
        return 0L;
    }
}

