/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.audit.AuditLogOperation;
import org.apache.iotdb.db.audit.AuditLogStorage;
import org.apache.iotdb.db.engine.compaction.execute.performer.constant.CrossCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.execute.performer.constant.InnerSeqCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.execute.performer.constant.InnerUnseqCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.schedule.constant.CompactionPriority;
import org.apache.iotdb.db.engine.compaction.selector.constant.CrossCompactionSelector;
import org.apache.iotdb.db.engine.compaction.selector.constant.InnerSequenceCompactionSelector;
import org.apache.iotdb.db.engine.compaction.selector.constant.InnerUnsequenceCompactionSelector;
import org.apache.iotdb.db.engine.storagegroup.timeindex.TimeIndexLevel;
import org.apache.iotdb.db.exception.LoadConfigurationException;
import org.apache.iotdb.db.service.thrift.impl.ClientRPCServiceImpl;
import org.apache.iotdb.db.service.thrift.impl.NewInfluxDBServiceImpl;
import org.apache.iotdb.db.utils.datastructure.TVListSortAlgorithm;
import org.apache.iotdb.db.wal.utils.WALMode;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.apache.iotdb.tsfile.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfig {
    public static final String WATERMARK_GROUPED_LSB = "GroupBasedLSBMethod";
    public static final String CONFIG_NAME = "iotdb-datanode.properties";
    private static final Logger logger = LoggerFactory.getLogger(IoTDBConfig.class);
    private static final String MULTI_DIR_STRATEGY_PREFIX = "org.apache.iotdb.db.conf.directories.strategy.";
    private static final String[] CLUSTER_ALLOWED_MULTI_DIR_STRATEGIES = new String[]{"SequenceStrategy", "MaxDiskUsableSpaceFirstStrategy"};
    private static final String DEFAULT_MULTI_DIR_STRATEGY = "SequenceStrategy";
    private static final String STORAGE_GROUP_MATCHER = "([a-zA-Z0-9`_.\\-\\u2E80-\\u9FFF]+)";
    public static final Pattern STORAGE_GROUP_PATTERN = Pattern.compile("([a-zA-Z0-9`_.\\-\\u2E80-\\u9FFF]+)");
    private static final String NODE_NAME_MATCHER = "([^\n\t]+)";
    private static final String PARTIAL_NODE_MATCHER = "[.]([^\n\t]+)";
    private static final String NODE_MATCHER = "([.])?([^\n\t]+)([.]([^\n\t]+))*";
    public static final Pattern NODE_PATTERN = Pattern.compile("([.])?([^\n\t]+)([.]([^\n\t]+))*");
    public static final String SYSTEM_DATABASE = "root.__system";
    private boolean enableMQTTService = false;
    private String mqttHost = "127.0.0.1";
    private int mqttPort = 1883;
    private int mqttHandlerPoolSize = 1;
    private String mqttPayloadFormatter = "json";
    private int mqttMaxMessageSize = 0x100000;
    private String rpcAddress = "0.0.0.0";
    private boolean rpcThriftCompressionEnable = false;
    private boolean rpcAdvancedCompressionEnable = false;
    private int rpcPort = 6667;
    private int rpcSelectorThreadCount = 1;
    private int rpcMinConcurrentClientNum = Runtime.getRuntime().availableProcessors();
    private int rpcMaxConcurrentClientNum = 65535;
    private long allocateMemoryForStorageEngine = Runtime.getRuntime().maxMemory() * 3L / 10L;
    private long allocateMemoryForRead = Runtime.getRuntime().maxMemory() * 3L / 10L;
    private long allocateMemoryForSchema = Runtime.getRuntime().maxMemory() / 10L;
    private long allocateMemoryForConsensus = Runtime.getRuntime().maxMemory() / 10L;
    private double bufferedArraysMemoryProportion = 0.6;
    private double flushProportion = 0.4;
    private double rejectProportion = 0.8;
    private double writeProportionForMemtable = 0.76;
    private double compactionProportion = 0.2;
    private double loadTsFileProportion = 0.125;
    private final int maxLoadingDeviceNumber = 10000;
    private double writeMemoryVariationReportProportion = 0.001;
    private int checkPeriodWhenInsertBlocked = 50;
    private int maxWaitingTimeWhenInsertBlockedInMs = 10000;
    private volatile WALMode walMode = WALMode.ASYNC;
    private int maxWalNodesNum = 0;
    private volatile long walAsyncModeFsyncDelayInMs = 1000L;
    private volatile long walSyncModeFsyncDelayInMs = 3L;
    private int walBufferSize = 0x2000000;
    private int walBufferQueueCapacity = 500;
    private volatile long walFileSizeThresholdInByte = 0x1E00000L;
    private volatile long checkpointFileSizeThresholdInByte = 0x300000L;
    private volatile double walMinEffectiveInfoRatio = 0.1;
    private volatile long walMemTableSnapshotThreshold = 0x800000L;
    private volatile int maxWalMemTableSnapshotNum = 1;
    private volatile long deleteWalFilesPeriodInMs = 20000L;
    private int mlogBufferSize = 0x100000;
    private long syncMlogPeriodInMs = 100L;
    private int tlogBufferSize = 0x100000;
    private String systemDir = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "system";
    private String schemaDir = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "system" + File.separator + "schema";
    private String queryDir = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "query";
    private String extDir = "ext";
    private String udfDir = "ext" + File.separator + "udf";
    private String udfTemporaryLibDir = this.udfDir + File.separator + "tmp";
    private String triggerDir = "ext" + File.separator + "trigger";
    private String triggerTemporaryLibDir = this.triggerDir + File.separator + "tmp";
    private String pipeDir = "ext" + File.separator + "pipe";
    private String pipeTemporaryLibDir = this.pipeDir + File.separator + "tmp";
    private String extPipeDir = "ext" + File.separator + "extPipe";
    private String mqttDir = "ext" + File.separator + "mqtt";
    private String[][] tierDataDirs = new String[][]{{IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "data"}};
    private String loadTsFileDir = this.tierDataDirs[0][0] + File.separator + "load";
    private String multiDirStrategyClassName = null;
    private String ratisDataRegionSnapshotDir = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "data" + File.separator + "snapshot";
    private String consensusDir = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "consensus";
    private String dataRegionConsensusDir = this.consensusDir + File.separator + "data_region";
    private String schemaRegionConsensusDir = this.consensusDir + File.separator + "schema_region";
    private String sortTmpDir = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "tmp";
    private int maxMemtableNumber = 0;
    private int batchSize = 100000;
    private int flushThreadCount = Runtime.getRuntime().availableProcessors();
    private int queryThreadCount = Runtime.getRuntime().availableProcessors();
    private int degreeOfParallelism = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private int modeMapSizeThreshold = 10000;
    private int maxAllowedConcurrentQueries = 1000;
    private int windowEvaluationThreadCount = Runtime.getRuntime().availableProcessors();
    private int maxPendingWindowEvaluationTasks = 64;
    private boolean enableMemControl = true;
    private boolean enableIndex = false;
    private int concurrentIndexBuildThread = Runtime.getRuntime().availableProcessors();
    private int defaultIndexWindowRange = 10;
    private String indexRootFolder = "data" + File.separator + "index";
    private long unSeqTsFileSize = 0L;
    private long seqTsFileSize = 0L;
    private long memtableSizeThreshold = 0x40000000L;
    private boolean enableTimedFlushSeqMemtable = true;
    private long seqMemtableFlushInterval = 10800000L;
    private long seqMemtableFlushCheckInterval = 600000L;
    private boolean enableTimedFlushUnseqMemtable = true;
    private long unseqMemtableFlushInterval = 10800000L;
    private long unseqMemtableFlushCheckInterval = 600000L;
    private TVListSortAlgorithm tvListSortAlgorithm = TVListSortAlgorithm.TIM;
    private int avgSeriesPointNumberThreshold = 100000;
    private boolean enableSeqSpaceCompaction = true;
    private boolean enableUnseqSpaceCompaction = true;
    private boolean enableCrossSpaceCompaction = true;
    private boolean enableMLNodeService = false;
    private long sortBufferSize = 0x100000L;
    private InnerSequenceCompactionSelector innerSequenceCompactionSelector = InnerSequenceCompactionSelector.SIZE_TIERED;
    private InnerSeqCompactionPerformer innerSeqCompactionPerformer = InnerSeqCompactionPerformer.READ_CHUNK;
    private InnerUnsequenceCompactionSelector innerUnsequenceCompactionSelector = InnerUnsequenceCompactionSelector.SIZE_TIERED;
    private InnerUnseqCompactionPerformer innerUnseqCompactionPerformer = InnerUnseqCompactionPerformer.FAST;
    private CrossCompactionSelector crossCompactionSelector = CrossCompactionSelector.REWRITE;
    private CrossCompactionPerformer crossCompactionPerformer = CrossCompactionPerformer.FAST;
    private CompactionPriority compactionPriority = CompactionPriority.BALANCE;
    private boolean enableCompactionMemControl = true;
    private double chunkMetadataSizeProportion = 0.1;
    private long targetCompactionFileSize = 0x80000000L;
    private long targetChunkSize = 0x100000L;
    private long targetChunkPointNum = 100000L;
    private long chunkSizeLowerBoundInCompaction = 10240L;
    private long chunkPointNumLowerBoundInCompaction = 1000L;
    private long compactionAcquireWriteLockTimeout = 60000L;
    private int fileLimitPerInnerTask = 30;
    private int fileLimitPerCrossTask = 500;
    private int totalFileLimitForCrossTask = 5000;
    private long maxCrossCompactionCandidateFileSize = 0x140000000L;
    private int minCrossCompactionUnseqFileLevel = 1;
    private long compactionScheduleIntervalInMs = 60000L;
    private long compactionSubmissionIntervalInMs = 60000L;
    private int subCompactionTaskNum = 4;
    private boolean enableCompactionValidation = true;
    private int candidateCompactionTaskQueueSize = 50;
    private boolean metaDataCacheEnable = true;
    private long allocateMemoryForBloomFilterCache = this.allocateMemoryForRead / 1001L;
    private long allocateMemoryForTimeSeriesMetaDataCache = this.allocateMemoryForRead * 200L / 1001L;
    private long allocateMemoryForChunkCache = this.allocateMemoryForRead * 100L / 1001L;
    private long allocateMemoryForCoordinator = this.allocateMemoryForRead * 50L / 1001L;
    private long allocateMemoryForOperators = this.allocateMemoryForRead * 200L / 1001L;
    private long allocateMemoryForDataExchange = this.allocateMemoryForRead * 200L / 1001L;
    private long maxBytesPerFragmentInstance = this.allocateMemoryForDataExchange / (long)this.queryThreadCount;
    private long allocateMemoryForTimeIndex = this.allocateMemoryForRead * 200L / 1001L;
    private long allocateMemoryForTimePartitionInfo = this.allocateMemoryForStorageEngine * 8L / 10L / 20L;
    private long allocateMemoryForWALPipeCache = this.allocateMemoryForConsensus / 10L;
    private boolean enableQueryMemoryEstimation = true;
    private int mRemoteSchemaCacheSize = 100000;
    private String languageVersion = "EN";
    private long cacheFileReaderClearPeriod = 100000L;
    private long queryTimeoutThreshold = 60000L;
    private int sessionTimeoutThreshold = 0;
    private String rpcImplClassName = ClientRPCServiceImpl.class.getName();
    private boolean isClusterMode = false;
    private String clusterName = "defaultCluster";
    private int dataNodeId = -1;
    private String influxdbImplClassName = NewInfluxDBServiceImpl.class.getName();
    private boolean chunkBufferPoolEnable = false;
    private boolean enableAutoCreateSchema = true;
    private TSDataType booleanStringInferType = TSDataType.BOOLEAN;
    private TSDataType integerStringInferType = TSDataType.FLOAT;
    private TSDataType longStringInferType = TSDataType.DOUBLE;
    private TSDataType floatingStringInferType = TSDataType.FLOAT;
    private TSDataType nanStringInferType = TSDataType.DOUBLE;
    private int defaultStorageGroupLevel = 1;
    private TSEncoding defaultBooleanEncoding = TSEncoding.RLE;
    private TSEncoding defaultInt32Encoding = TSEncoding.RLE;
    private TSEncoding defaultInt64Encoding = TSEncoding.RLE;
    private TSEncoding defaultFloatEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultDoubleEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultTextEncoding = TSEncoding.PLAIN;
    private int upgradeThreadCount = 1;
    private int settleThreadNum = 1;
    private long crossCompactionFileSelectionTimeBudget = 30000L;
    private long mergeIntervalSec = 0L;
    private int compactionWriteThroughputMbPerSec = 16;
    private int compactionThreadCount = 10;
    private int continuousQueryThreadNum = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private long continuousQueryMinimumEveryInterval = 1000L;
    private long intoOperationBufferSizeInByte = 0x6400000L;
    private int selectIntoInsertTabletPlanRowLimit = 10000;
    private int intoOperationExecutionThreadCount = 2;
    private FSType tsFileStorageFs = FSType.LOCAL;
    private boolean enableHDFS = false;
    private String coreSitePath = "/etc/hadoop/conf/core-site.xml";
    private String hdfsSitePath = "/etc/hadoop/conf/hdfs-site.xml";
    private String hdfsIp = "localhost";
    private String hdfsPort = "9000";
    private String dfsNameServices = "hdfsnamespace";
    private String dfsHaNamenodes = "nn1,nn2";
    private boolean dfsHaAutomaticFailoverEnabled = true;
    private String dfsClientFailoverProxyProvider = "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider";
    private boolean useKerberos = false;
    private String kerberosKeytabFilePath = "/path";
    private String kerberosPrincipal = "your principal";
    private int concurrentWritingTimePartition = 1;
    private int defaultFillInterval = -1;
    private int primitiveArraySize = 64;
    private TimeIndexLevel timeIndexLevel = TimeIndexLevel.DEVICE_TIME_INDEX;
    private int thriftServerAwaitTimeForStopService = 60;
    private int tagAttributeFlushInterval = 1000;
    private boolean enablePartialInsert = true;
    private boolean enable13DataInsertAdapt = false;
    private int udfInitialByteArrayLengthForMemoryControl = 48;
    private float udfMemoryBudgetInMB = (float)Math.min(30.0, 0.2 * (double)this.allocateMemoryForRead);
    private float udfReaderMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private float udfTransformerMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private float udfCollectorMemoryBudgetInMB = (float)(0.3333333333333333 * (double)this.udfMemoryBudgetInMB);
    private long startUpNanosecond = System.nanoTime();
    private int thriftMaxFrameSize = 0x20000000;
    private int thriftDefaultBufferSize = 1024;
    private int frequencyIntervalInMinute = 1;
    private long slowQueryThreshold = 30000L;
    private int patternMatchingThreshold = 1000000;
    private boolean enableRpcService = true;
    private int ioTaskQueueSizeForFlushing = 10;
    private int dataRegionNum = 1;
    private long recoveryLogIntervalInMs = 5000L;
    private boolean enableDiscardOutOfOrderData = false;
    private String deviceIDTransformationMethod = "Plain";
    private boolean enableIDTable = false;
    private boolean enableIDTableLogFile = false;
    private int cachedMNodeSizeInPBTreeMode = -1;
    private short minimumSegmentInPBTree = 0;
    private int pageCacheSizeInPBTree = 1024;
    private int pbTreeLogSize = 16384;
    private int maxMeasurementNumOfInternalRequest = 10000;
    private String internalAddress = "127.0.0.1";
    private int internalPort = 10730;
    private int mlNodePort = 10780;
    private int dataRegionConsensusPort = 10760;
    private int schemaRegionConsensusPort = 10750;
    private List<TEndPoint> targetConfigNodeList = Collections.singletonList(new TEndPoint("127.0.0.1", 10710));
    private long joinClusterRetryIntervalMs = TimeUnit.SECONDS.toMillis(5L);
    private String dataRegionConsensusProtocolClass = "org.apache.iotdb.consensus.ratis.RatisConsensus";
    private String schemaRegionConsensusProtocolClass = "org.apache.iotdb.consensus.ratis.RatisConsensus";
    private String seriesPartitionExecutorClass = "org.apache.iotdb.commons.partition.executor.hash.BKDRHashExecutor";
    private int seriesPartitionSlotNum = 10000;
    private int mppDataExchangePort = 10740;
    private int mppDataExchangeCorePoolSize = 10;
    private int mppDataExchangeMaxPoolSize = 10;
    private int mppDataExchangeKeepAliveTimeInMs = 1000;
    private int connectionTimeoutInMS = (int)TimeUnit.SECONDS.toMillis(20L);
    private int selectorNumOfClientManager = Runtime.getRuntime().availableProcessors() / 4 > 0 ? Runtime.getRuntime().availableProcessors() / 4 : 1;
    private int coreClientNumForEachNode = 200;
    private int maxClientNumForEachNode = 300;
    private int partitionCacheSize = 1000;
    private int devicePathCacheSize = 500000;
    private int authorCacheSize = 100;
    private int authorCacheExpireTime = 30;
    private int triggerForwardMaxQueueNumber = 8;
    private int triggerForwardMaxSizePerQueue = 2000;
    private int triggerForwardBatchSize = 50;
    private int triggerForwardHTTPPoolSize = 200;
    private int triggerForwardHTTPPOOLMaxPerRoute = 20;
    private int triggerForwardMQTTPoolSize = 4;
    private int retryNumToFindStatefulTrigger = 3;
    private int coordinatorReadExecutorSize = 20;
    private int coordinatorWriteExecutorSize = 50;
    private int[] schemaMemoryProportion = new int[]{5, 4, 1};
    private long allocateMemoryForSchemaRegion = this.allocateMemoryForSchema * 5L / 10L;
    private long allocateMemoryForSchemaCache = this.allocateMemoryForSchema * 4L / 10L;
    private long allocateMemoryForPartitionCache = this.allocateMemoryForSchema / 10L;
    private String dataNodeSchemaCacheEvictionPolicy = "FIFO";
    private String readConsistencyLevel = "strong";
    private int driverTaskExecutionTimeSliceInMs = 100;
    private long throttleThreshold = 0xC80000000L;
    private long cacheWindowTimeInMs = 10000L;
    private long dataRatisConsensusLogAppenderBufferSizeMax = 0x1000000L;
    private long schemaRatisConsensusLogAppenderBufferSizeMax = 0x1000000L;
    private long dataRatisConsensusSnapshotTriggerThreshold = 400000L;
    private long schemaRatisConsensusSnapshotTriggerThreshold = 400000L;
    private boolean dataRatisConsensusLogUnsafeFlushEnable = false;
    private boolean schemaRatisConsensusLogUnsafeFlushEnable = false;
    private int dataRatisConsensusLogForceSyncNum = 128;
    private long dataRatisConsensusLogSegmentSizeMax = 0x1800000L;
    private long schemaRatisConsensusLogSegmentSizeMax = 0x1800000L;
    private long dataRatisConsensusGrpcFlowControlWindow = 0x400000L;
    private long schemaRatisConsensusGrpcFlowControlWindow = 0x400000L;
    private int dataRatisConsensusGrpcLeaderOutstandingAppendsMax = 128;
    private long dataRatisConsensusLeaderElectionTimeoutMinMs = 2000L;
    private long schemaRatisConsensusLeaderElectionTimeoutMinMs = 2000L;
    private long dataRatisConsensusLeaderElectionTimeoutMaxMs = 4000L;
    private long schemaRatisConsensusLeaderElectionTimeoutMaxMs = 4000L;
    private long cqMinEveryIntervalInMs = 1000L;
    private long dataRatisConsensusRequestTimeoutMs = 10000L;
    private long schemaRatisConsensusRequestTimeoutMs = 10000L;
    private int dataRatisConsensusMaxRetryAttempts = 10;
    private int schemaRatisConsensusMaxRetryAttempts = 10;
    private long dataRatisConsensusInitialSleepTimeMs = 100L;
    private long schemaRatisConsensusInitialSleepTimeMs = 100L;
    private long dataRatisConsensusMaxSleepTimeMs = 10000L;
    private long schemaRatisConsensusMaxSleepTimeMs = 10000L;
    private long dataRatisConsensusPreserveWhenPurge = 1000L;
    private long schemaRatisConsensusPreserveWhenPurge = 1000L;
    private long ratisFirstElectionTimeoutMinMs = 50L;
    private long ratisFirstElectionTimeoutMaxMs = 150L;
    private long dataRatisLogMax = 0x500000000L;
    private long schemaRatisLogMax = 0x80000000L;
    private boolean enableAuditLog = false;
    private String clusterSchemaLimitLevel = "timeseries";
    private long clusterSchemaLimitThreshold = -1L;
    private List<AuditLogStorage> auditLogStorage = Arrays.asList(AuditLogStorage.IOTDB, AuditLogStorage.LOGGER);
    private List<AuditLogOperation> auditLogOperation = Arrays.asList(AuditLogOperation.DML, AuditLogOperation.DDL, AuditLogOperation.QUERY);
    private boolean enableAuditLogForNativeInsertApi = true;
    private Properties customizedProperties = new Properties();
    private int maxLogEntriesNumPerBatch = 1024;
    private int maxSizePerBatch = 0x1000000;
    private int maxPendingBatchesNum = 12;
    private double maxMemoryRatioForQueue = 0.6;
    private String pipeReceiveFileDir = this.systemDir + File.separator + "pipe";
    private boolean quotaEnable = false;
    private String RateLimiterType = "FixedIntervalRateLimiter";

    IoTDBConfig() {
    }

    public int getMaxLogEntriesNumPerBatch() {
        return this.maxLogEntriesNumPerBatch;
    }

    public int getMaxSizePerBatch() {
        return this.maxSizePerBatch;
    }

    public int getMaxPendingBatchesNum() {
        return this.maxPendingBatchesNum;
    }

    public double getMaxMemoryRatioForQueue() {
        return this.maxMemoryRatioForQueue;
    }

    public void setMaxLogEntriesNumPerBatch(int maxLogEntriesNumPerBatch) {
        this.maxLogEntriesNumPerBatch = maxLogEntriesNumPerBatch;
    }

    public void setMaxSizePerBatch(int maxSizePerBatch) {
        this.maxSizePerBatch = maxSizePerBatch;
    }

    public void setMaxPendingBatchesNum(int maxPendingBatchesNum) {
        this.maxPendingBatchesNum = maxPendingBatchesNum;
    }

    public void setMaxMemoryRatioForQueue(double maxMemoryRatioForQueue) {
        this.maxMemoryRatioForQueue = maxMemoryRatioForQueue;
    }

    public float getUdfMemoryBudgetInMB() {
        return this.udfMemoryBudgetInMB;
    }

    public void setUdfMemoryBudgetInMB(float udfMemoryBudgetInMB) {
        this.udfMemoryBudgetInMB = udfMemoryBudgetInMB;
    }

    public float getUdfReaderMemoryBudgetInMB() {
        return this.udfReaderMemoryBudgetInMB;
    }

    public void setUdfReaderMemoryBudgetInMB(float udfReaderMemoryBudgetInMB) {
        this.udfReaderMemoryBudgetInMB = udfReaderMemoryBudgetInMB;
    }

    public float getUdfTransformerMemoryBudgetInMB() {
        return this.udfTransformerMemoryBudgetInMB;
    }

    public void setUdfTransformerMemoryBudgetInMB(float udfTransformerMemoryBudgetInMB) {
        this.udfTransformerMemoryBudgetInMB = udfTransformerMemoryBudgetInMB;
    }

    public float getUdfCollectorMemoryBudgetInMB() {
        return this.udfCollectorMemoryBudgetInMB;
    }

    public void setUdfCollectorMemoryBudgetInMB(float udfCollectorMemoryBudgetInMB) {
        this.udfCollectorMemoryBudgetInMB = udfCollectorMemoryBudgetInMB;
    }

    public int getUdfInitialByteArrayLengthForMemoryControl() {
        return this.udfInitialByteArrayLengthForMemoryControl;
    }

    public void setUdfInitialByteArrayLengthForMemoryControl(int udfInitialByteArrayLengthForMemoryControl) {
        this.udfInitialByteArrayLengthForMemoryControl = udfInitialByteArrayLengthForMemoryControl;
    }

    public int getConcurrentWritingTimePartition() {
        return this.concurrentWritingTimePartition;
    }

    public void setConcurrentWritingTimePartition(int concurrentWritingTimePartition) {
        this.concurrentWritingTimePartition = concurrentWritingTimePartition;
    }

    public int getDefaultFillInterval() {
        return this.defaultFillInterval;
    }

    public void setDefaultFillInterval(int defaultFillInterval) {
        this.defaultFillInterval = defaultFillInterval;
    }

    public TimeIndexLevel getTimeIndexLevel() {
        return this.timeIndexLevel;
    }

    public void setTimeIndexLevel(String timeIndexLevel) {
        this.timeIndexLevel = TimeIndexLevel.valueOf(timeIndexLevel);
    }

    public void updatePath() {
        this.formulateFolders();
        this.confirmMultiDirStrategy();
    }

    private void formulateFolders() {
        this.systemDir = this.addDataHomeDir(this.systemDir);
        this.schemaDir = this.addDataHomeDir(this.schemaDir);
        this.loadTsFileDir = this.addDataHomeDir(this.loadTsFileDir);
        this.consensusDir = this.addDataHomeDir(this.consensusDir);
        this.dataRegionConsensusDir = this.addDataHomeDir(this.dataRegionConsensusDir);
        this.ratisDataRegionSnapshotDir = this.addDataHomeDir(this.ratisDataRegionSnapshotDir);
        this.schemaRegionConsensusDir = this.addDataHomeDir(this.schemaRegionConsensusDir);
        this.indexRootFolder = this.addDataHomeDir(this.indexRootFolder);
        this.extDir = this.addDataHomeDir(this.extDir);
        this.udfDir = this.addDataHomeDir(this.udfDir);
        this.udfTemporaryLibDir = this.addDataHomeDir(this.udfTemporaryLibDir);
        this.triggerDir = this.addDataHomeDir(this.triggerDir);
        this.triggerTemporaryLibDir = this.addDataHomeDir(this.triggerTemporaryLibDir);
        this.pipeDir = this.addDataHomeDir(this.pipeDir);
        this.pipeTemporaryLibDir = this.addDataHomeDir(this.pipeTemporaryLibDir);
        this.pipeReceiveFileDir = this.addDataHomeDir(this.pipeReceiveFileDir);
        this.mqttDir = this.addDataHomeDir(this.mqttDir);
        this.extPipeDir = this.addDataHomeDir(this.extPipeDir);
        this.queryDir = this.addDataHomeDir(this.queryDir);
        this.formulateDataDirs(this.tierDataDirs);
    }

    private void formulateDataDirs(String[][] tierDataDirs) {
        for (int i = 0; i < tierDataDirs.length; ++i) {
            block6: for (int j = 0; j < tierDataDirs[i].length; ++j) {
                if (tierDataDirs[i][j].equals("object_storage")) {
                    tierDataDirs[i][j] = FSUtils.getOSDefaultPath((String)this.getObjectStorageBucket(), (int)this.dataNodeId);
                }
                switch (FSUtils.getFSType((String)tierDataDirs[i][j])) {
                    case HDFS: {
                        tierDataDirs[i][j] = this.getHdfsDir() + File.separatorChar + tierDataDirs[i][j];
                        continue block6;
                    }
                    case LOCAL: {
                        tierDataDirs[i][j] = this.addDataHomeDir(tierDataDirs[i][j]);
                        continue block6;
                    }
                    case OBJECT_STORAGE: {
                        tierDataDirs[i][j] = FSUtils.getOSDefaultPath((String)this.getObjectStorageBucket(), (int)this.dataNodeId);
                        continue block6;
                    }
                }
            }
        }
    }

    void reloadDataDirs(String[][] tierDataDirs) throws LoadConfigurationException {
        this.formulateDataDirs(tierDataDirs);
        for (int i = 0; i < this.tierDataDirs.length; ++i) {
            HashSet<String> newDirs = new HashSet<String>(Arrays.asList(tierDataDirs[i]));
            for (String oldDir : this.tierDataDirs[i]) {
                if (newDirs.contains(oldDir)) continue;
                String msg = String.format("%s is removed from data_dirs parameter, please add it back.", oldDir);
                logger.error(msg);
                throw new LoadConfigurationException(msg);
            }
        }
        this.tierDataDirs = tierDataDirs;
    }

    private String addDataHomeDir(String dir) {
        String dataHomeDir = System.getProperty("IOTDB_DATA_HOME", null);
        if (dataHomeDir == null) {
            dataHomeDir = System.getProperty("IOTDB_HOME", null);
        }
        if (dataHomeDir == null) {
            return dir;
        }
        File dataHomeFile = new File(dataHomeDir);
        try {
            dataHomeDir = dataHomeFile.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("Fail to get canonical path of {}", (Object)dataHomeFile, (Object)e);
        }
        return FileUtils.addPrefix2FilePath((String)dataHomeDir, (String)dir);
    }

    void confirmMultiDirStrategy() {
        if (this.getMultiDirStrategyClassName() == null) {
            this.multiDirStrategyClassName = DEFAULT_MULTI_DIR_STRATEGY;
        }
        if (!this.getMultiDirStrategyClassName().contains(".")) {
            this.multiDirStrategyClassName = MULTI_DIR_STRATEGY_PREFIX + this.multiDirStrategyClassName;
        }
        try {
            Class.forName(this.multiDirStrategyClassName);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Cannot find given directory strategy {}, using the default value", (Object)this.getMultiDirStrategyClassName(), (Object)e);
            this.setMultiDirStrategyClassName("org.apache.iotdb.db.conf.directories.strategy.SequenceStrategy");
        }
    }

    private String getHdfsDir() {
        String[] hdfsIps = TSFileDescriptor.getInstance().getConfig().getHdfsIp();
        String hdfsDir = "hdfs://";
        hdfsDir = hdfsIps.length > 1 ? hdfsDir + TSFileDescriptor.getInstance().getConfig().getDfsNameServices() : hdfsDir + hdfsIps[0] + ":" + TSFileDescriptor.getInstance().getConfig().getHdfsPort();
        return hdfsDir;
    }

    public String[] getDataDirs() {
        return (String[])Arrays.stream(this.tierDataDirs).flatMap(Arrays::stream).toArray(String[]::new);
    }

    public String[] getLocalDataDirs() {
        return (String[])Arrays.stream(this.tierDataDirs).flatMap(Arrays::stream).filter(FSUtils::isLocal).toArray(String[]::new);
    }

    public String[][] getTierDataDirs() {
        return this.tierDataDirs;
    }

    public void setTierDataDirs(String[][] tierDataDirs) {
        this.formulateDataDirs(tierDataDirs);
        this.tierDataDirs = tierDataDirs;
        this.setRatisDataRegionSnapshotDir(tierDataDirs[0][0] + File.separator + "snapshot");
        this.setLoadTsFileDir(tierDataDirs[0][0] + File.separator + "load");
    }

    public String getRpcAddress() {
        return this.rpcAddress;
    }

    public void setRpcAddress(String rpcAddress) {
        this.rpcAddress = rpcAddress;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public boolean isEnableDiscardOutOfOrderData() {
        return this.enableDiscardOutOfOrderData;
    }

    public void setEnableDiscardOutOfOrderData(boolean enableDiscardOutOfOrderData) {
        this.enableDiscardOutOfOrderData = enableDiscardOutOfOrderData;
    }

    public String getSystemDir() {
        return this.systemDir;
    }

    void setSystemDir(String systemDir) {
        this.systemDir = systemDir;
    }

    public String getLoadTsFileDir() {
        return this.loadTsFileDir;
    }

    public void setLoadTsFileDir(String loadTsFileDir) {
        this.loadTsFileDir = loadTsFileDir;
    }

    public String getSchemaDir() {
        return this.schemaDir;
    }

    public void setSchemaDir(String schemaDir) {
        this.schemaDir = schemaDir;
    }

    public String getQueryDir() {
        return this.queryDir;
    }

    void setQueryDir(String queryDir) {
        this.queryDir = queryDir;
    }

    public String getRatisDataRegionSnapshotDir() {
        return this.ratisDataRegionSnapshotDir;
    }

    public void setRatisDataRegionSnapshotDir(String ratisDataRegionSnapshotDir) {
        this.ratisDataRegionSnapshotDir = ratisDataRegionSnapshotDir;
    }

    public String getConsensusDir() {
        return this.consensusDir;
    }

    public void setConsensusDir(String consensusDir) {
        this.consensusDir = consensusDir;
        this.setDataRegionConsensusDir(consensusDir + File.separator + "data_region");
        this.setSchemaRegionConsensusDir(consensusDir + File.separator + "schema_region");
    }

    public String getDataRegionConsensusDir() {
        return this.dataRegionConsensusDir;
    }

    public void setDataRegionConsensusDir(String dataRegionConsensusDir) {
        this.dataRegionConsensusDir = dataRegionConsensusDir;
    }

    public String getSchemaRegionConsensusDir() {
        return this.schemaRegionConsensusDir;
    }

    public void setSchemaRegionConsensusDir(String schemaRegionConsensusDir) {
        this.schemaRegionConsensusDir = schemaRegionConsensusDir;
    }

    public String getExtDir() {
        return this.extDir;
    }

    public void setExtDir(String extDir) {
        this.extDir = extDir;
    }

    public String getUdfDir() {
        return this.udfDir;
    }

    public void setUdfDir(String udfDir) {
        this.udfDir = udfDir;
        this.updateUdfTemporaryLibDir();
    }

    public String getUdfTemporaryLibDir() {
        return this.udfTemporaryLibDir;
    }

    public void updateUdfTemporaryLibDir() {
        this.udfTemporaryLibDir = this.udfDir + File.separator + "tmp";
    }

    public String getTriggerDir() {
        return this.triggerDir;
    }

    public void setTriggerDir(String triggerDir) {
        this.triggerDir = triggerDir;
        this.updateTriggerTemporaryLibDir();
    }

    public String getTriggerTemporaryLibDir() {
        return this.triggerTemporaryLibDir;
    }

    public void updateTriggerTemporaryLibDir() {
        this.triggerTemporaryLibDir = this.triggerDir + File.separator + "tmp";
    }

    public String getPipeLibDir() {
        return this.pipeDir;
    }

    public void setPipeLibDir(String pipeDir) {
        this.pipeDir = pipeDir;
        this.updatePipeTemporaryLibDir();
    }

    public String getPipeTemporaryLibDir() {
        return this.pipeTemporaryLibDir;
    }

    public void updatePipeTemporaryLibDir() {
        this.pipeTemporaryLibDir = this.pipeDir + File.separator + "tmp";
    }

    public String getMqttDir() {
        return this.mqttDir;
    }

    public void setMqttDir(String mqttDir) {
        this.mqttDir = mqttDir;
    }

    public String getMultiDirStrategyClassName() {
        return this.multiDirStrategyClassName;
    }

    void setMultiDirStrategyClassName(String multiDirStrategyClassName) {
        this.multiDirStrategyClassName = multiDirStrategyClassName;
    }

    public void checkMultiDirStrategyClassName() {
        if (this.isClusterMode) {
            for (String multiDirStrategy : CLUSTER_ALLOWED_MULTI_DIR_STRATEGIES) {
                if (!this.multiDirStrategyClassName.equals(multiDirStrategy) && !this.multiDirStrategyClassName.equals(MULTI_DIR_STRATEGY_PREFIX + multiDirStrategy)) continue;
                return;
            }
            String msg = String.format("Cannot set multi_dir_strategy to %s, because cluster mode only allows %s.", this.multiDirStrategyClassName, Arrays.toString(CLUSTER_ALLOWED_MULTI_DIR_STRATEGIES));
            logger.error(msg);
            throw new RuntimeException(msg);
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getMaxMemtableNumber() {
        return this.maxMemtableNumber;
    }

    public void setMaxMemtableNumber(int maxMemtableNumber) {
        this.maxMemtableNumber = maxMemtableNumber;
    }

    public int getFlushThreadCount() {
        return this.flushThreadCount;
    }

    void setFlushThreadCount(int flushThreadCount) {
        this.flushThreadCount = flushThreadCount;
    }

    public int getQueryThreadCount() {
        return this.queryThreadCount;
    }

    public void setQueryThreadCount(int queryThreadCount) {
        this.queryThreadCount = queryThreadCount;
    }

    public void setDegreeOfParallelism(int degreeOfParallelism) {
        if (degreeOfParallelism > 0) {
            this.degreeOfParallelism = degreeOfParallelism;
        }
    }

    public int getDegreeOfParallelism() {
        return this.degreeOfParallelism;
    }

    public int getMaxAllowedConcurrentQueries() {
        return this.maxAllowedConcurrentQueries;
    }

    public void setMaxAllowedConcurrentQueries(int maxAllowedConcurrentQueries) {
        this.maxAllowedConcurrentQueries = maxAllowedConcurrentQueries;
    }

    public long getMaxBytesPerFragmentInstance() {
        return this.maxBytesPerFragmentInstance;
    }

    public void setMaxBytesPerFragmentInstance(long maxBytesPerFragmentInstance) {
        this.maxBytesPerFragmentInstance = maxBytesPerFragmentInstance;
    }

    public int getWindowEvaluationThreadCount() {
        return this.windowEvaluationThreadCount;
    }

    public void setWindowEvaluationThreadCount(int windowEvaluationThreadCount) {
        this.windowEvaluationThreadCount = windowEvaluationThreadCount;
    }

    public int getMaxPendingWindowEvaluationTasks() {
        return this.maxPendingWindowEvaluationTasks;
    }

    public void setMaxPendingWindowEvaluationTasks(int maxPendingWindowEvaluationTasks) {
        this.maxPendingWindowEvaluationTasks = maxPendingWindowEvaluationTasks;
    }

    public long getSeqTsFileSize() {
        return this.seqTsFileSize;
    }

    public void setSeqTsFileSize(long seqTsFileSize) {
        this.seqTsFileSize = seqTsFileSize;
    }

    public long getUnSeqTsFileSize() {
        return this.unSeqTsFileSize;
    }

    public void setUnSeqTsFileSize(long unSeqTsFileSize) {
        this.unSeqTsFileSize = unSeqTsFileSize;
    }

    public int getRpcSelectorThreadCount() {
        return this.rpcSelectorThreadCount;
    }

    public void setRpcSelectorThreadCount(int rpcSelectorThreadCount) {
        this.rpcSelectorThreadCount = rpcSelectorThreadCount;
    }

    public int getRpcMinConcurrentClientNum() {
        return this.rpcMinConcurrentClientNum;
    }

    public void setRpcMinConcurrentClientNum(int rpcMinConcurrentClientNum) {
        this.rpcMinConcurrentClientNum = rpcMinConcurrentClientNum;
    }

    public int getRpcMaxConcurrentClientNum() {
        return this.rpcMaxConcurrentClientNum;
    }

    void setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
        this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
    }

    public int getmRemoteSchemaCacheSize() {
        return this.mRemoteSchemaCacheSize;
    }

    public void setmRemoteSchemaCacheSize(int mRemoteSchemaCacheSize) {
        this.mRemoteSchemaCacheSize = mRemoteSchemaCacheSize;
    }

    String getLanguageVersion() {
        return this.languageVersion;
    }

    void setLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
    }

    public String getIoTDBVersion() {
        return IoTDBConstant.VERSION;
    }

    public String getIoTDBMajorVersion() {
        return IoTDBConstant.MAJOR_VERSION;
    }

    public String getIoTDBMajorVersion(String version) {
        return "UNKNOWN".equals(version) ? "UNKNOWN" : version.split("\\.")[0] + "." + version.split("\\.")[1];
    }

    public long getCacheFileReaderClearPeriod() {
        return this.cacheFileReaderClearPeriod;
    }

    public void setCacheFileReaderClearPeriod(long cacheFileReaderClearPeriod) {
        this.cacheFileReaderClearPeriod = cacheFileReaderClearPeriod;
    }

    public long getQueryTimeoutThreshold() {
        return this.queryTimeoutThreshold;
    }

    public void setQueryTimeoutThreshold(long queryTimeoutThreshold) {
        this.queryTimeoutThreshold = queryTimeoutThreshold;
    }

    public int getSessionTimeoutThreshold() {
        return this.sessionTimeoutThreshold;
    }

    public void setSessionTimeoutThreshold(int sessionTimeoutThreshold) {
        this.sessionTimeoutThreshold = sessionTimeoutThreshold;
    }

    public String getRpcImplClassName() {
        return this.rpcImplClassName;
    }

    public String getInfluxDBImplClassName() {
        return this.influxdbImplClassName;
    }

    public void setRpcImplClassName(String rpcImplClassName) {
        this.rpcImplClassName = rpcImplClassName;
    }

    public WALMode getWalMode() {
        return this.walMode;
    }

    public void setWalMode(WALMode walMode) {
        this.walMode = walMode;
    }

    public int getMaxWalNodesNum() {
        return this.maxWalNodesNum;
    }

    void setMaxWalNodesNum(int maxWalNodesNum) {
        this.maxWalNodesNum = maxWalNodesNum;
    }

    public long getWalAsyncModeFsyncDelayInMs() {
        return this.walAsyncModeFsyncDelayInMs;
    }

    void setWalAsyncModeFsyncDelayInMs(long walAsyncModeFsyncDelayInMs) {
        this.walAsyncModeFsyncDelayInMs = walAsyncModeFsyncDelayInMs;
    }

    public long getWalSyncModeFsyncDelayInMs() {
        return this.walSyncModeFsyncDelayInMs;
    }

    public void setWalSyncModeFsyncDelayInMs(long walSyncModeFsyncDelayInMs) {
        this.walSyncModeFsyncDelayInMs = walSyncModeFsyncDelayInMs;
    }

    public int getWalBufferSize() {
        return this.walBufferSize;
    }

    public void setWalBufferSize(int walBufferSize) {
        this.walBufferSize = walBufferSize;
    }

    public int getWalBufferQueueCapacity() {
        return this.walBufferQueueCapacity;
    }

    void setWalBufferQueueCapacity(int walBufferQueueCapacity) {
        this.walBufferQueueCapacity = walBufferQueueCapacity;
    }

    public long getWalFileSizeThresholdInByte() {
        return this.walFileSizeThresholdInByte;
    }

    void setWalFileSizeThresholdInByte(long walFileSizeThresholdInByte) {
        this.walFileSizeThresholdInByte = walFileSizeThresholdInByte;
    }

    public long getCheckpointFileSizeThresholdInByte() {
        return this.checkpointFileSizeThresholdInByte;
    }

    public void setCheckpointFileSizeThresholdInByte(long checkpointFileSizeThresholdInByte) {
        this.checkpointFileSizeThresholdInByte = checkpointFileSizeThresholdInByte;
    }

    public double getWalMinEffectiveInfoRatio() {
        return this.walMinEffectiveInfoRatio;
    }

    void setWalMinEffectiveInfoRatio(double walMinEffectiveInfoRatio) {
        this.walMinEffectiveInfoRatio = walMinEffectiveInfoRatio;
    }

    public long getWalMemTableSnapshotThreshold() {
        return this.walMemTableSnapshotThreshold;
    }

    void setWalMemTableSnapshotThreshold(long walMemTableSnapshotThreshold) {
        this.walMemTableSnapshotThreshold = walMemTableSnapshotThreshold;
    }

    public int getMaxWalMemTableSnapshotNum() {
        return this.maxWalMemTableSnapshotNum;
    }

    void setMaxWalMemTableSnapshotNum(int maxWalMemTableSnapshotNum) {
        this.maxWalMemTableSnapshotNum = maxWalMemTableSnapshotNum;
    }

    public long getDeleteWalFilesPeriodInMs() {
        return this.deleteWalFilesPeriodInMs;
    }

    void setDeleteWalFilesPeriodInMs(long deleteWalFilesPeriodInMs) {
        this.deleteWalFilesPeriodInMs = deleteWalFilesPeriodInMs;
    }

    public boolean isChunkBufferPoolEnable() {
        return this.chunkBufferPoolEnable;
    }

    void setChunkBufferPoolEnable(boolean chunkBufferPoolEnable) {
        this.chunkBufferPoolEnable = chunkBufferPoolEnable;
    }

    public long getMergeIntervalSec() {
        return this.mergeIntervalSec;
    }

    void setMergeIntervalSec(long mergeIntervalSec) {
        this.mergeIntervalSec = mergeIntervalSec;
    }

    public double getBufferedArraysMemoryProportion() {
        return this.bufferedArraysMemoryProportion;
    }

    public void setBufferedArraysMemoryProportion(double bufferedArraysMemoryProportion) {
        this.bufferedArraysMemoryProportion = bufferedArraysMemoryProportion;
    }

    public double getFlushProportion() {
        return this.flushProportion;
    }

    public void setFlushProportion(double flushProportion) {
        this.flushProportion = flushProportion;
    }

    public double getRejectProportion() {
        return this.rejectProportion;
    }

    public void setRejectProportion(double rejectProportion) {
        this.rejectProportion = rejectProportion;
    }

    public double getWriteMemoryVariationReportProportion() {
        return this.writeMemoryVariationReportProportion;
    }

    public void setWriteMemoryVariationReportProportion(double writeMemoryVariationReportProportion) {
        this.writeMemoryVariationReportProportion = writeMemoryVariationReportProportion;
    }

    public long getAllocateMemoryForStorageEngine() {
        return this.allocateMemoryForStorageEngine;
    }

    public void setAllocateMemoryForStorageEngine(long allocateMemoryForStorageEngine) {
        this.allocateMemoryForStorageEngine = allocateMemoryForStorageEngine;
    }

    public long getAllocateMemoryForSchema() {
        return this.allocateMemoryForSchema;
    }

    public void setAllocateMemoryForSchema(long allocateMemoryForSchema) {
        this.allocateMemoryForSchema = allocateMemoryForSchema;
        this.allocateMemoryForSchemaRegion = allocateMemoryForSchema * 5L / 10L;
        this.allocateMemoryForSchemaCache = allocateMemoryForSchema * 4L / 10L;
        this.allocateMemoryForPartitionCache = allocateMemoryForSchema / 10L;
    }

    public long getAllocateMemoryForConsensus() {
        return this.allocateMemoryForConsensus;
    }

    public void setAllocateMemoryForConsensus(long allocateMemoryForConsensus) {
        this.allocateMemoryForConsensus = allocateMemoryForConsensus;
        this.allocateMemoryForWALPipeCache = allocateMemoryForConsensus / 10L;
    }

    public long getAllocateMemoryForRead() {
        return this.allocateMemoryForRead;
    }

    void setAllocateMemoryForRead(long allocateMemoryForRead) {
        this.allocateMemoryForRead = allocateMemoryForRead;
        this.allocateMemoryForBloomFilterCache = allocateMemoryForRead / 1001L;
        this.allocateMemoryForTimeSeriesMetaDataCache = allocateMemoryForRead * 200L / 1001L;
        this.allocateMemoryForChunkCache = allocateMemoryForRead * 100L / 1001L;
        this.allocateMemoryForCoordinator = allocateMemoryForRead * 50L / 1001L;
        this.allocateMemoryForOperators = allocateMemoryForRead * 200L / 1001L;
        this.allocateMemoryForDataExchange = allocateMemoryForRead * 200L / 1001L;
        this.allocateMemoryForTimeIndex = allocateMemoryForRead * 200L / 1001L;
    }

    public long getAllocateMemoryForFree() {
        return Runtime.getRuntime().maxMemory() - this.allocateMemoryForStorageEngine - this.allocateMemoryForRead - this.allocateMemoryForSchema;
    }

    public boolean isEnablePartialInsert() {
        return this.enablePartialInsert;
    }

    public void setEnablePartialInsert(boolean enablePartialInsert) {
        this.enablePartialInsert = enablePartialInsert;
    }

    public boolean isEnable13DataInsertAdapt() {
        return this.enable13DataInsertAdapt;
    }

    public void setEnable13DataInsertAdapt(boolean enable13DataInsertAdapt) {
        this.enable13DataInsertAdapt = enable13DataInsertAdapt;
    }

    public int getCompactionThreadCount() {
        return this.compactionThreadCount;
    }

    public void setCompactionThreadCount(int compactionThreadCount) {
        this.compactionThreadCount = compactionThreadCount;
    }

    public int getContinuousQueryThreadNum() {
        return this.continuousQueryThreadNum;
    }

    public void setContinuousQueryThreadNum(int continuousQueryThreadNum) {
        this.continuousQueryThreadNum = continuousQueryThreadNum;
    }

    public long getContinuousQueryMinimumEveryInterval() {
        return this.continuousQueryMinimumEveryInterval;
    }

    public void setContinuousQueryMinimumEveryInterval(long minimumEveryInterval) {
        this.continuousQueryMinimumEveryInterval = minimumEveryInterval;
    }

    public long getIntoOperationBufferSizeInByte() {
        return this.intoOperationBufferSizeInByte;
    }

    public void setIntoOperationBufferSizeInByte(long intoOperationBufferSizeInByte) {
        this.intoOperationBufferSizeInByte = intoOperationBufferSizeInByte;
    }

    public int getSelectIntoInsertTabletPlanRowLimit() {
        return this.selectIntoInsertTabletPlanRowLimit;
    }

    public void setSelectIntoInsertTabletPlanRowLimit(int selectIntoInsertTabletPlanRowLimit) {
        this.selectIntoInsertTabletPlanRowLimit = selectIntoInsertTabletPlanRowLimit;
    }

    public int getIntoOperationExecutionThreadCount() {
        return this.intoOperationExecutionThreadCount;
    }

    public void setIntoOperationExecutionThreadCount(int intoOperationExecutionThreadCount) {
        this.intoOperationExecutionThreadCount = intoOperationExecutionThreadCount;
    }

    public int getCompactionWriteThroughputMbPerSec() {
        return this.compactionWriteThroughputMbPerSec;
    }

    public void setCompactionWriteThroughputMbPerSec(int compactionWriteThroughputMbPerSec) {
        this.compactionWriteThroughputMbPerSec = compactionWriteThroughputMbPerSec;
    }

    public boolean isEnableMemControl() {
        return this.enableMemControl;
    }

    public void setEnableMemControl(boolean enableMemControl) {
        this.enableMemControl = enableMemControl;
    }

    public long getMemtableSizeThreshold() {
        return this.memtableSizeThreshold;
    }

    public void setMemtableSizeThreshold(long memtableSizeThreshold) {
        this.memtableSizeThreshold = memtableSizeThreshold;
    }

    public boolean isEnableTimedFlushSeqMemtable() {
        return this.enableTimedFlushSeqMemtable;
    }

    public void setEnableTimedFlushSeqMemtable(boolean enableTimedFlushSeqMemtable) {
        this.enableTimedFlushSeqMemtable = enableTimedFlushSeqMemtable;
    }

    public long getSeqMemtableFlushInterval() {
        return this.seqMemtableFlushInterval;
    }

    public void setSeqMemtableFlushInterval(long seqMemtableFlushInterval) {
        this.seqMemtableFlushInterval = seqMemtableFlushInterval;
    }

    public long getSeqMemtableFlushCheckInterval() {
        return this.seqMemtableFlushCheckInterval;
    }

    public void setSeqMemtableFlushCheckInterval(long seqMemtableFlushCheckInterval) {
        this.seqMemtableFlushCheckInterval = seqMemtableFlushCheckInterval;
    }

    public boolean isEnableTimedFlushUnseqMemtable() {
        return this.enableTimedFlushUnseqMemtable;
    }

    public void setEnableTimedFlushUnseqMemtable(boolean enableTimedFlushUnseqMemtable) {
        this.enableTimedFlushUnseqMemtable = enableTimedFlushUnseqMemtable;
    }

    public long getUnseqMemtableFlushInterval() {
        return this.unseqMemtableFlushInterval;
    }

    public void setUnseqMemtableFlushInterval(long unseqMemtableFlushInterval) {
        this.unseqMemtableFlushInterval = unseqMemtableFlushInterval;
    }

    public long getUnseqMemtableFlushCheckInterval() {
        return this.unseqMemtableFlushCheckInterval;
    }

    public void setUnseqMemtableFlushCheckInterval(long unseqMemtableFlushCheckInterval) {
        this.unseqMemtableFlushCheckInterval = unseqMemtableFlushCheckInterval;
    }

    public TVListSortAlgorithm getTvListSortAlgorithm() {
        return this.tvListSortAlgorithm;
    }

    public void setTvListSortAlgorithm(TVListSortAlgorithm tvListSortAlgorithm) {
        this.tvListSortAlgorithm = tvListSortAlgorithm;
    }

    public int getAvgSeriesPointNumberThreshold() {
        return this.avgSeriesPointNumberThreshold;
    }

    public void setAvgSeriesPointNumberThreshold(int avgSeriesPointNumberThreshold) {
        this.avgSeriesPointNumberThreshold = avgSeriesPointNumberThreshold;
    }

    public long getCrossCompactionFileSelectionTimeBudget() {
        return this.crossCompactionFileSelectionTimeBudget;
    }

    void setCrossCompactionFileSelectionTimeBudget(long crossCompactionFileSelectionTimeBudget) {
        this.crossCompactionFileSelectionTimeBudget = crossCompactionFileSelectionTimeBudget;
    }

    public boolean isRpcThriftCompressionEnable() {
        return this.rpcThriftCompressionEnable;
    }

    public void setRpcThriftCompressionEnable(boolean rpcThriftCompressionEnable) {
        this.rpcThriftCompressionEnable = rpcThriftCompressionEnable;
    }

    public boolean isMetaDataCacheEnable() {
        return this.metaDataCacheEnable;
    }

    public void setMetaDataCacheEnable(boolean metaDataCacheEnable) {
        this.metaDataCacheEnable = metaDataCacheEnable;
    }

    public long getAllocateMemoryForBloomFilterCache() {
        return this.allocateMemoryForBloomFilterCache;
    }

    public void setAllocateMemoryForBloomFilterCache(long allocateMemoryForBloomFilterCache) {
        this.allocateMemoryForBloomFilterCache = allocateMemoryForBloomFilterCache;
    }

    public long getAllocateMemoryForTimeSeriesMetaDataCache() {
        return this.allocateMemoryForTimeSeriesMetaDataCache;
    }

    public void setAllocateMemoryForTimeSeriesMetaDataCache(long allocateMemoryForTimeSeriesMetaDataCache) {
        this.allocateMemoryForTimeSeriesMetaDataCache = allocateMemoryForTimeSeriesMetaDataCache;
    }

    public long getAllocateMemoryForChunkCache() {
        return this.allocateMemoryForChunkCache;
    }

    public void setAllocateMemoryForChunkCache(long allocateMemoryForChunkCache) {
        this.allocateMemoryForChunkCache = allocateMemoryForChunkCache;
    }

    public long getAllocateMemoryForCoordinator() {
        return this.allocateMemoryForCoordinator;
    }

    public void setAllocateMemoryForCoordinator(long allocateMemoryForCoordinator) {
        this.allocateMemoryForCoordinator = allocateMemoryForCoordinator;
    }

    public long getAllocateMemoryForOperators() {
        return this.allocateMemoryForOperators;
    }

    public void setAllocateMemoryForOperators(long allocateMemoryForOperators) {
        this.allocateMemoryForOperators = allocateMemoryForOperators;
    }

    public long getAllocateMemoryForDataExchange() {
        return this.allocateMemoryForDataExchange;
    }

    public void setAllocateMemoryForDataExchange(long allocateMemoryForDataExchange) {
        this.allocateMemoryForDataExchange = allocateMemoryForDataExchange;
    }

    public long getAllocateMemoryForTimeIndex() {
        return this.allocateMemoryForTimeIndex;
    }

    public void setAllocateMemoryForTimeIndex(long allocateMemoryForTimeIndex) {
        this.allocateMemoryForTimeIndex = allocateMemoryForTimeIndex;
    }

    public long getAllocateMemoryForTimePartitionInfo() {
        return this.allocateMemoryForTimePartitionInfo;
    }

    public void setAllocateMemoryForTimePartitionInfo(long allocateMemoryForTimePartitionInfo) {
        this.allocateMemoryForTimePartitionInfo = allocateMemoryForTimePartitionInfo;
    }

    public long getAllocateMemoryForWALPipeCache() {
        return this.allocateMemoryForWALPipeCache;
    }

    public void setAllocateMemoryForWALPipeCache(long allocateMemoryForWALPipeCache) {
        this.allocateMemoryForWALPipeCache = allocateMemoryForWALPipeCache;
    }

    public boolean isEnableQueryMemoryEstimation() {
        return this.enableQueryMemoryEstimation;
    }

    public void setEnableQueryMemoryEstimation(boolean enableQueryMemoryEstimation) {
        this.enableQueryMemoryEstimation = enableQueryMemoryEstimation;
    }

    public boolean isAutoCreateSchemaEnabled() {
        return this.enableAutoCreateSchema;
    }

    public void setAutoCreateSchemaEnabled(boolean enableAutoCreateSchema) {
        this.enableAutoCreateSchema = enableAutoCreateSchema;
    }

    public TSDataType getBooleanStringInferType() {
        return this.booleanStringInferType;
    }

    public void setBooleanStringInferType(TSDataType booleanStringInferType) {
        this.booleanStringInferType = booleanStringInferType;
    }

    public TSDataType getIntegerStringInferType() {
        return this.integerStringInferType;
    }

    public void setIntegerStringInferType(TSDataType integerStringInferType) {
        this.integerStringInferType = integerStringInferType;
    }

    public void setLongStringInferType(TSDataType longStringInferType) {
        this.longStringInferType = longStringInferType;
    }

    public TSDataType getLongStringInferType() {
        return this.longStringInferType;
    }

    public TSDataType getFloatingStringInferType() {
        return this.floatingStringInferType;
    }

    public void setFloatingStringInferType(TSDataType floatingNumberStringInferType) {
        this.floatingStringInferType = floatingNumberStringInferType;
    }

    public TSDataType getNanStringInferType() {
        return this.nanStringInferType;
    }

    public void setNanStringInferType(TSDataType nanStringInferType) {
        if (nanStringInferType != TSDataType.DOUBLE && nanStringInferType != TSDataType.FLOAT && nanStringInferType != TSDataType.TEXT) {
            throw new IllegalArgumentException("Config Property nan_string_infer_type can only be FLOAT, DOUBLE or TEXT but is " + nanStringInferType);
        }
        this.nanStringInferType = nanStringInferType;
    }

    public int getDefaultStorageGroupLevel() {
        return this.defaultStorageGroupLevel;
    }

    void setDefaultStorageGroupLevel(int defaultStorageGroupLevel) {
        this.defaultStorageGroupLevel = defaultStorageGroupLevel;
    }

    public TSEncoding getDefaultBooleanEncoding() {
        return this.defaultBooleanEncoding;
    }

    public void setDefaultBooleanEncoding(TSEncoding defaultBooleanEncoding) {
        this.defaultBooleanEncoding = defaultBooleanEncoding;
    }

    void setDefaultBooleanEncoding(String defaultBooleanEncoding) {
        this.defaultBooleanEncoding = TSEncoding.valueOf((String)defaultBooleanEncoding);
    }

    public TSEncoding getDefaultInt32Encoding() {
        return this.defaultInt32Encoding;
    }

    public void setDefaultInt32Encoding(TSEncoding defaultInt32Encoding) {
        this.defaultInt32Encoding = defaultInt32Encoding;
    }

    void setDefaultInt32Encoding(String defaultInt32Encoding) {
        this.defaultInt32Encoding = TSEncoding.valueOf((String)defaultInt32Encoding);
    }

    public TSEncoding getDefaultInt64Encoding() {
        return this.defaultInt64Encoding;
    }

    public void setDefaultInt64Encoding(TSEncoding defaultInt64Encoding) {
        this.defaultInt64Encoding = defaultInt64Encoding;
    }

    void setDefaultInt64Encoding(String defaultInt64Encoding) {
        this.defaultInt64Encoding = TSEncoding.valueOf((String)defaultInt64Encoding);
    }

    public TSEncoding getDefaultFloatEncoding() {
        return this.defaultFloatEncoding;
    }

    public void setDefaultFloatEncoding(TSEncoding defaultFloatEncoding) {
        this.defaultFloatEncoding = defaultFloatEncoding;
    }

    void setDefaultFloatEncoding(String defaultFloatEncoding) {
        this.defaultFloatEncoding = TSEncoding.valueOf((String)defaultFloatEncoding);
    }

    public TSEncoding getDefaultDoubleEncoding() {
        return this.defaultDoubleEncoding;
    }

    public void setDefaultDoubleEncoding(TSEncoding defaultDoubleEncoding) {
        this.defaultDoubleEncoding = defaultDoubleEncoding;
    }

    void setDefaultDoubleEncoding(String defaultDoubleEncoding) {
        this.defaultDoubleEncoding = TSEncoding.valueOf((String)defaultDoubleEncoding);
    }

    public TSEncoding getDefaultTextEncoding() {
        return this.defaultTextEncoding;
    }

    public void setDefaultTextEncoding(TSEncoding defaultTextEncoding) {
        this.defaultTextEncoding = defaultTextEncoding;
    }

    void setDefaultTextEncoding(String defaultTextEncoding) {
        this.defaultTextEncoding = TSEncoding.valueOf((String)defaultTextEncoding);
    }

    FSType getTsFileStorageFs() {
        return this.tsFileStorageFs;
    }

    void setTsFileStorageFs(String tsFileStorageFs) {
        this.tsFileStorageFs = FSType.valueOf((String)tsFileStorageFs);
    }

    public boolean isEnableHDFS() {
        return this.enableHDFS;
    }

    public void setEnableHDFS(boolean enableHDFS) {
        this.enableHDFS = enableHDFS;
    }

    String getCoreSitePath() {
        return this.coreSitePath;
    }

    void setCoreSitePath(String coreSitePath) {
        this.coreSitePath = coreSitePath;
    }

    String getHdfsSitePath() {
        return this.hdfsSitePath;
    }

    void setHdfsSitePath(String hdfsSitePath) {
        this.hdfsSitePath = hdfsSitePath;
    }

    public String[] getHdfsIp() {
        return this.hdfsIp.split(",");
    }

    String getRawHDFSIp() {
        return this.hdfsIp;
    }

    void setHdfsIp(String[] hdfsIp) {
        this.hdfsIp = String.join((CharSequence)",", hdfsIp);
    }

    String getHdfsPort() {
        return this.hdfsPort;
    }

    void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public int getUpgradeThreadCount() {
        return this.upgradeThreadCount;
    }

    public int getSettleThreadNum() {
        return this.settleThreadNum;
    }

    void setUpgradeThreadCount(int upgradeThreadCount) {
        this.upgradeThreadCount = upgradeThreadCount;
    }

    String getDfsNameServices() {
        return this.dfsNameServices;
    }

    void setDfsNameServices(String dfsNameServices) {
        this.dfsNameServices = dfsNameServices;
    }

    public String[] getDfsHaNamenodes() {
        return this.dfsHaNamenodes.split(",");
    }

    String getRawDfsHaNamenodes() {
        return this.dfsHaNamenodes;
    }

    void setDfsHaNamenodes(String[] dfsHaNamenodes) {
        this.dfsHaNamenodes = String.join((CharSequence)",", dfsHaNamenodes);
    }

    boolean isDfsHaAutomaticFailoverEnabled() {
        return this.dfsHaAutomaticFailoverEnabled;
    }

    void setDfsHaAutomaticFailoverEnabled(boolean dfsHaAutomaticFailoverEnabled) {
        this.dfsHaAutomaticFailoverEnabled = dfsHaAutomaticFailoverEnabled;
    }

    String getDfsClientFailoverProxyProvider() {
        return this.dfsClientFailoverProxyProvider;
    }

    void setDfsClientFailoverProxyProvider(String dfsClientFailoverProxyProvider) {
        this.dfsClientFailoverProxyProvider = dfsClientFailoverProxyProvider;
    }

    boolean isUseKerberos() {
        return this.useKerberos;
    }

    void setUseKerberos(boolean useKerberos) {
        this.useKerberos = useKerberos;
    }

    String getKerberosKeytabFilePath() {
        return this.kerberosKeytabFilePath;
    }

    void setKerberosKeytabFilePath(String kerberosKeytabFilePath) {
        this.kerberosKeytabFilePath = kerberosKeytabFilePath;
    }

    String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public int getThriftServerAwaitTimeForStopService() {
        return this.thriftServerAwaitTimeForStopService;
    }

    public void setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
        this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
    }

    public boolean isEnableMQTTService() {
        return this.enableMQTTService;
    }

    public void setEnableMQTTService(boolean enableMQTTService) {
        this.enableMQTTService = enableMQTTService;
    }

    public String getMqttHost() {
        return this.mqttHost;
    }

    public void setMqttHost(String mqttHost) {
        this.mqttHost = mqttHost;
    }

    public int getMqttPort() {
        return this.mqttPort;
    }

    public void setMqttPort(int mqttPort) {
        this.mqttPort = mqttPort;
    }

    public int getMqttHandlerPoolSize() {
        return this.mqttHandlerPoolSize;
    }

    public void setMqttHandlerPoolSize(int mqttHandlerPoolSize) {
        this.mqttHandlerPoolSize = mqttHandlerPoolSize;
    }

    public String getMqttPayloadFormatter() {
        return this.mqttPayloadFormatter;
    }

    public void setMqttPayloadFormatter(String mqttPayloadFormatter) {
        this.mqttPayloadFormatter = mqttPayloadFormatter;
    }

    public int getMqttMaxMessageSize() {
        return this.mqttMaxMessageSize;
    }

    public void setMqttMaxMessageSize(int mqttMaxMessageSize) {
        this.mqttMaxMessageSize = mqttMaxMessageSize;
    }

    public int getTagAttributeFlushInterval() {
        return this.tagAttributeFlushInterval;
    }

    public void setTagAttributeFlushInterval(int tagAttributeFlushInterval) {
        this.tagAttributeFlushInterval = tagAttributeFlushInterval;
    }

    public int getPrimitiveArraySize() {
        return this.primitiveArraySize;
    }

    public void setPrimitiveArraySize(int primitiveArraySize) {
        this.primitiveArraySize = primitiveArraySize;
    }

    public long getStartUpNanosecond() {
        return this.startUpNanosecond;
    }

    public int getThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }

    public void setThriftMaxFrameSize(int thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        RpcTransportFactory.setThriftMaxFrameSize((int)this.thriftMaxFrameSize);
    }

    public int getThriftDefaultBufferSize() {
        return this.thriftDefaultBufferSize;
    }

    public void setThriftDefaultBufferSize(int thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        RpcTransportFactory.setDefaultBufferCapacity((int)this.thriftDefaultBufferSize);
    }

    public int getCheckPeriodWhenInsertBlocked() {
        return this.checkPeriodWhenInsertBlocked;
    }

    public void setCheckPeriodWhenInsertBlocked(int checkPeriodWhenInsertBlocked) {
        this.checkPeriodWhenInsertBlocked = checkPeriodWhenInsertBlocked;
    }

    public int getMaxWaitingTimeWhenInsertBlocked() {
        return this.maxWaitingTimeWhenInsertBlockedInMs;
    }

    public void setMaxWaitingTimeWhenInsertBlocked(int maxWaitingTimeWhenInsertBlocked) {
        this.maxWaitingTimeWhenInsertBlockedInMs = maxWaitingTimeWhenInsertBlocked;
    }

    public int getFrequencyIntervalInMinute() {
        return this.frequencyIntervalInMinute;
    }

    public void setFrequencyIntervalInMinute(int frequencyIntervalInMinute) {
        this.frequencyIntervalInMinute = frequencyIntervalInMinute;
    }

    public long getSlowQueryThreshold() {
        return this.slowQueryThreshold;
    }

    public void setSlowQueryThreshold(long slowQueryThreshold) {
        this.slowQueryThreshold = slowQueryThreshold;
    }

    public boolean isEnableIndex() {
        return this.enableIndex;
    }

    public void setEnableIndex(boolean enableIndex) {
        this.enableIndex = enableIndex;
    }

    void setConcurrentIndexBuildThread(int concurrentIndexBuildThread) {
        this.concurrentIndexBuildThread = concurrentIndexBuildThread;
    }

    public int getConcurrentIndexBuildThread() {
        return this.concurrentIndexBuildThread;
    }

    public String getIndexRootFolder() {
        return this.indexRootFolder;
    }

    public void setIndexRootFolder(String indexRootFolder) {
        this.indexRootFolder = indexRootFolder;
    }

    public int getDefaultIndexWindowRange() {
        return this.defaultIndexWindowRange;
    }

    public void setDefaultIndexWindowRange(int defaultIndexWindowRange) {
        this.defaultIndexWindowRange = defaultIndexWindowRange;
    }

    public int getDataRegionNum() {
        return this.dataRegionNum;
    }

    public void setDataRegionNum(int dataRegionNum) {
        this.dataRegionNum = dataRegionNum;
    }

    public long getRecoveryLogIntervalInMs() {
        return this.recoveryLogIntervalInMs;
    }

    public void setRecoveryLogIntervalInMs(long recoveryLogIntervalInMs) {
        this.recoveryLogIntervalInMs = recoveryLogIntervalInMs;
    }

    public boolean isRpcAdvancedCompressionEnable() {
        return this.rpcAdvancedCompressionEnable;
    }

    public void setRpcAdvancedCompressionEnable(boolean rpcAdvancedCompressionEnable) {
        this.rpcAdvancedCompressionEnable = rpcAdvancedCompressionEnable;
        RpcTransportFactory.setUseSnappy((boolean)this.rpcAdvancedCompressionEnable);
    }

    public int getMlogBufferSize() {
        return this.mlogBufferSize;
    }

    public void setMlogBufferSize(int mlogBufferSize) {
        this.mlogBufferSize = mlogBufferSize;
    }

    public long getSyncMlogPeriodInMs() {
        return this.syncMlogPeriodInMs;
    }

    public void setSyncMlogPeriodInMs(long syncMlogPeriodInMs) {
        this.syncMlogPeriodInMs = syncMlogPeriodInMs;
    }

    public int getTlogBufferSize() {
        return this.tlogBufferSize;
    }

    public void setTlogBufferSize(int tlogBufferSize) {
        this.tlogBufferSize = tlogBufferSize;
    }

    public boolean isEnableRpcService() {
        return this.enableRpcService;
    }

    public void setEnableRpcService(boolean enableRpcService) {
        this.enableRpcService = enableRpcService;
    }

    public int getIoTaskQueueSizeForFlushing() {
        return this.ioTaskQueueSizeForFlushing;
    }

    public void setIoTaskQueueSizeForFlushing(int ioTaskQueueSizeForFlushing) {
        this.ioTaskQueueSizeForFlushing = ioTaskQueueSizeForFlushing;
    }

    public boolean isEnableSeqSpaceCompaction() {
        return this.enableSeqSpaceCompaction;
    }

    public void setEnableSeqSpaceCompaction(boolean enableSeqSpaceCompaction) {
        this.enableSeqSpaceCompaction = enableSeqSpaceCompaction;
    }

    public boolean isEnableUnseqSpaceCompaction() {
        return this.enableUnseqSpaceCompaction;
    }

    public void setEnableUnseqSpaceCompaction(boolean enableUnseqSpaceCompaction) {
        this.enableUnseqSpaceCompaction = enableUnseqSpaceCompaction;
    }

    public boolean isEnableCrossSpaceCompaction() {
        return this.enableCrossSpaceCompaction;
    }

    public void setEnableCrossSpaceCompaction(boolean enableCrossSpaceCompaction) {
        this.enableCrossSpaceCompaction = enableCrossSpaceCompaction;
    }

    public boolean isEnableMLNodeService() {
        return this.enableMLNodeService;
    }

    public void setEnableMLNodeService(boolean enableMLNodeService) {
        this.enableMLNodeService = enableMLNodeService;
    }

    public InnerSequenceCompactionSelector getInnerSequenceCompactionSelector() {
        return this.innerSequenceCompactionSelector;
    }

    public void setInnerSequenceCompactionSelector(InnerSequenceCompactionSelector innerSequenceCompactionSelector) {
        this.innerSequenceCompactionSelector = innerSequenceCompactionSelector;
    }

    public InnerUnsequenceCompactionSelector getInnerUnsequenceCompactionSelector() {
        return this.innerUnsequenceCompactionSelector;
    }

    public void setInnerUnsequenceCompactionSelector(InnerUnsequenceCompactionSelector innerUnsequenceCompactionSelector) {
        this.innerUnsequenceCompactionSelector = innerUnsequenceCompactionSelector;
    }

    public InnerSeqCompactionPerformer getInnerSeqCompactionPerformer() {
        return this.innerSeqCompactionPerformer;
    }

    public void setInnerSeqCompactionPerformer(InnerSeqCompactionPerformer innerSeqCompactionPerformer) {
        this.innerSeqCompactionPerformer = innerSeqCompactionPerformer;
    }

    public InnerUnseqCompactionPerformer getInnerUnseqCompactionPerformer() {
        return this.innerUnseqCompactionPerformer;
    }

    public void setInnerUnseqCompactionPerformer(InnerUnseqCompactionPerformer innerUnseqCompactionPerformer) {
        this.innerUnseqCompactionPerformer = innerUnseqCompactionPerformer;
    }

    public CrossCompactionSelector getCrossCompactionSelector() {
        return this.crossCompactionSelector;
    }

    public void setCrossCompactionSelector(CrossCompactionSelector crossCompactionSelector) {
        this.crossCompactionSelector = crossCompactionSelector;
    }

    public CrossCompactionPerformer getCrossCompactionPerformer() {
        return this.crossCompactionPerformer;
    }

    public void setCrossCompactionPerformer(CrossCompactionPerformer crossCompactionPerformer) {
        this.crossCompactionPerformer = crossCompactionPerformer;
    }

    public CompactionPriority getCompactionPriority() {
        return this.compactionPriority;
    }

    public void setCompactionPriority(CompactionPriority compactionPriority) {
        this.compactionPriority = compactionPriority;
    }

    public boolean isEnableCompactionMemControl() {
        return this.enableCompactionMemControl;
    }

    public void setEnableCompactionMemControl(boolean enableCompactionMemControl) {
        this.enableCompactionMemControl = enableCompactionMemControl;
    }

    public long getTargetCompactionFileSize() {
        return this.targetCompactionFileSize;
    }

    public void setTargetCompactionFileSize(long targetCompactionFileSize) {
        this.targetCompactionFileSize = targetCompactionFileSize;
    }

    public long getTargetChunkSize() {
        return this.targetChunkSize;
    }

    public void setTargetChunkSize(long targetChunkSize) {
        this.targetChunkSize = targetChunkSize;
    }

    public long getChunkSizeLowerBoundInCompaction() {
        return this.chunkSizeLowerBoundInCompaction;
    }

    public void setChunkSizeLowerBoundInCompaction(long chunkSizeLowerBoundInCompaction) {
        this.chunkSizeLowerBoundInCompaction = chunkSizeLowerBoundInCompaction;
    }

    public long getTargetChunkPointNum() {
        return this.targetChunkPointNum;
    }

    public void setTargetChunkPointNum(long targetChunkPointNum) {
        this.targetChunkPointNum = targetChunkPointNum;
    }

    public long getChunkPointNumLowerBoundInCompaction() {
        return this.chunkPointNumLowerBoundInCompaction;
    }

    public void setChunkPointNumLowerBoundInCompaction(long chunkPointNumLowerBoundInCompaction) {
        this.chunkPointNumLowerBoundInCompaction = chunkPointNumLowerBoundInCompaction;
    }

    public long getCompactionAcquireWriteLockTimeout() {
        return this.compactionAcquireWriteLockTimeout;
    }

    public void setCompactionAcquireWriteLockTimeout(long compactionAcquireWriteLockTimeout) {
        this.compactionAcquireWriteLockTimeout = compactionAcquireWriteLockTimeout;
    }

    public long getCompactionScheduleIntervalInMs() {
        return this.compactionScheduleIntervalInMs;
    }

    public void setCompactionScheduleIntervalInMs(long compactionScheduleIntervalInMs) {
        this.compactionScheduleIntervalInMs = compactionScheduleIntervalInMs;
    }

    public int getFileLimitPerInnerTask() {
        return this.fileLimitPerInnerTask;
    }

    public void setFileLimitPerInnerTask(int fileLimitPerInnerTask) {
        this.fileLimitPerInnerTask = fileLimitPerInnerTask;
    }

    public int getFileLimitPerCrossTask() {
        return this.fileLimitPerCrossTask;
    }

    public int getTotalFileLimitForCrossTask() {
        return this.totalFileLimitForCrossTask;
    }

    public void setFileLimitPerCrossTask(int fileLimitPerCrossTask) {
        this.fileLimitPerCrossTask = fileLimitPerCrossTask;
    }

    public long getMaxCrossCompactionCandidateFileSize() {
        return this.maxCrossCompactionCandidateFileSize;
    }

    public void setMaxCrossCompactionCandidateFileSize(long maxCrossCompactionCandidateFileSize) {
        this.maxCrossCompactionCandidateFileSize = maxCrossCompactionCandidateFileSize;
    }

    public int getMinCrossCompactionUnseqFileLevel() {
        return this.minCrossCompactionUnseqFileLevel;
    }

    public void setMinCrossCompactionUnseqFileLevel(int minCrossCompactionUnseqFileLevel) {
        this.minCrossCompactionUnseqFileLevel = minCrossCompactionUnseqFileLevel;
    }

    public long getCompactionSubmissionIntervalInMs() {
        return this.compactionSubmissionIntervalInMs;
    }

    public void setCompactionSubmissionIntervalInMs(long interval) {
        this.compactionSubmissionIntervalInMs = interval;
    }

    public int getSubCompactionTaskNum() {
        return this.subCompactionTaskNum;
    }

    public void setSubCompactionTaskNum(int subCompactionTaskNum) {
        this.subCompactionTaskNum = subCompactionTaskNum;
    }

    public String getDeviceIDTransformationMethod() {
        return this.deviceIDTransformationMethod;
    }

    public void setDeviceIDTransformationMethod(String deviceIDTransformationMethod) {
        this.deviceIDTransformationMethod = deviceIDTransformationMethod;
    }

    public boolean isEnableIDTable() {
        return this.enableIDTable;
    }

    public void setEnableIDTable(boolean enableIDTable) {
        this.enableIDTable = enableIDTable;
    }

    public boolean isEnableIDTableLogFile() {
        return this.enableIDTableLogFile;
    }

    public void setEnableIDTableLogFile(boolean enableIDTableLogFile) {
        this.enableIDTableLogFile = enableIDTableLogFile;
    }

    public int getCachedMNodeSizeInPBTreeMode() {
        return this.cachedMNodeSizeInPBTreeMode;
    }

    public void setCachedMNodeSizeInPBTreeMode(int cachedMNodeSizeInPBTreeMode) {
        this.cachedMNodeSizeInPBTreeMode = cachedMNodeSizeInPBTreeMode;
    }

    public short getMinimumSegmentInPBTree() {
        return this.minimumSegmentInPBTree;
    }

    public void setMinimumSegmentInPBTree(short minimumSegmentInPBTree) {
        this.minimumSegmentInPBTree = minimumSegmentInPBTree;
    }

    public int getPageCacheSizeInPBTree() {
        return this.pageCacheSizeInPBTree;
    }

    public void setPageCacheSizeInPBTree(int pageCacheSizeInPBTree) {
        this.pageCacheSizeInPBTree = pageCacheSizeInPBTree;
    }

    public int getPBTreeLogSize() {
        return this.pbTreeLogSize;
    }

    public void setPBTreeLogSize(int pbTreeLogSize) {
        this.pbTreeLogSize = pbTreeLogSize;
    }

    public int getMaxMeasurementNumOfInternalRequest() {
        return this.maxMeasurementNumOfInternalRequest;
    }

    public void setMaxMeasurementNumOfInternalRequest(int maxMeasurementNumOfInternalRequest) {
        this.maxMeasurementNumOfInternalRequest = maxMeasurementNumOfInternalRequest;
    }

    public String getInternalAddress() {
        return this.internalAddress;
    }

    public void setInternalAddress(String internalAddress) {
        this.internalAddress = internalAddress;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public void setInternalPort(int internalPort) {
        this.internalPort = internalPort;
    }

    public int getMLNodePort() {
        return this.mlNodePort;
    }

    public void setMLNodePort(int mlNodePort) {
        this.mlNodePort = mlNodePort;
    }

    public int getDataRegionConsensusPort() {
        return this.dataRegionConsensusPort;
    }

    public void setDataRegionConsensusPort(int dataRegionConsensusPort) {
        this.dataRegionConsensusPort = dataRegionConsensusPort;
    }

    public int getSchemaRegionConsensusPort() {
        return this.schemaRegionConsensusPort;
    }

    public void setSchemaRegionConsensusPort(int schemaRegionConsensusPort) {
        this.schemaRegionConsensusPort = schemaRegionConsensusPort;
    }

    public List<TEndPoint> getTargetConfigNodeList() {
        return this.targetConfigNodeList;
    }

    public void setTargetConfigNodeList(List<TEndPoint> targetConfigNodeList) {
        this.targetConfigNodeList = targetConfigNodeList;
    }

    public long getJoinClusterRetryIntervalMs() {
        return this.joinClusterRetryIntervalMs;
    }

    public void setJoinClusterRetryIntervalMs(long joinClusterRetryIntervalMs) {
        this.joinClusterRetryIntervalMs = joinClusterRetryIntervalMs;
    }

    public String getDataRegionConsensusProtocolClass() {
        return this.dataRegionConsensusProtocolClass;
    }

    public void setDataRegionConsensusProtocolClass(String dataRegionConsensusProtocolClass) {
        this.dataRegionConsensusProtocolClass = dataRegionConsensusProtocolClass;
    }

    public String getSchemaRegionConsensusProtocolClass() {
        return this.schemaRegionConsensusProtocolClass;
    }

    public void setSchemaRegionConsensusProtocolClass(String schemaRegionConsensusProtocolClass) {
        this.schemaRegionConsensusProtocolClass = schemaRegionConsensusProtocolClass;
    }

    public String getSeriesPartitionExecutorClass() {
        return this.seriesPartitionExecutorClass;
    }

    public void setSeriesPartitionExecutorClass(String seriesPartitionExecutorClass) {
        this.seriesPartitionExecutorClass = seriesPartitionExecutorClass;
    }

    public int getSeriesPartitionSlotNum() {
        return this.seriesPartitionSlotNum;
    }

    public void setSeriesPartitionSlotNum(int seriesPartitionSlotNum) {
        this.seriesPartitionSlotNum = seriesPartitionSlotNum;
    }

    public int getMppDataExchangePort() {
        return this.mppDataExchangePort;
    }

    public void setMppDataExchangePort(int mppDataExchangePort) {
        this.mppDataExchangePort = mppDataExchangePort;
    }

    public int getMppDataExchangeCorePoolSize() {
        return this.mppDataExchangeCorePoolSize;
    }

    public void setMppDataExchangeCorePoolSize(int mppDataExchangeCorePoolSize) {
        this.mppDataExchangeCorePoolSize = mppDataExchangeCorePoolSize;
    }

    public int getMppDataExchangeMaxPoolSize() {
        return this.mppDataExchangeMaxPoolSize;
    }

    public void setMppDataExchangeMaxPoolSize(int mppDataExchangeMaxPoolSize) {
        this.mppDataExchangeMaxPoolSize = mppDataExchangeMaxPoolSize;
    }

    public int getMppDataExchangeKeepAliveTimeInMs() {
        return this.mppDataExchangeKeepAliveTimeInMs;
    }

    public void setMppDataExchangeKeepAliveTimeInMs(int mppDataExchangeKeepAliveTimeInMs) {
        this.mppDataExchangeKeepAliveTimeInMs = mppDataExchangeKeepAliveTimeInMs;
    }

    public int getConnectionTimeoutInMS() {
        return this.connectionTimeoutInMS;
    }

    public void setConnectionTimeoutInMS(int connectionTimeoutInMS) {
        this.connectionTimeoutInMS = connectionTimeoutInMS;
    }

    public int getMaxClientNumForEachNode() {
        return this.maxClientNumForEachNode;
    }

    public void setMaxClientNumForEachNode(int maxClientNumForEachNode) {
        this.maxClientNumForEachNode = maxClientNumForEachNode;
    }

    public int getCoreClientNumForEachNode() {
        return this.coreClientNumForEachNode;
    }

    public void setCoreClientNumForEachNode(int coreClientNumForEachNode) {
        this.coreClientNumForEachNode = coreClientNumForEachNode;
    }

    public int getSelectorNumOfClientManager() {
        return this.selectorNumOfClientManager;
    }

    public void setSelectorNumOfClientManager(int selectorNumOfClientManager) {
        this.selectorNumOfClientManager = selectorNumOfClientManager;
    }

    public boolean isClusterMode() {
        return this.isClusterMode;
    }

    public void setClusterMode(boolean isClusterMode) {
        this.isClusterMode = isClusterMode;
        this.checkMultiDirStrategyClassName();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public int getDataNodeId() {
        return this.dataNodeId;
    }

    public void setDataNodeId(int dataNodeId) {
        this.dataNodeId = dataNodeId;
    }

    public int getPartitionCacheSize() {
        return this.partitionCacheSize;
    }

    public String getExtPipeDir() {
        return this.extPipeDir;
    }

    public void setExtPipeDir(String extPipeDir) {
        this.extPipeDir = extPipeDir;
    }

    public void setPartitionCacheSize(int partitionCacheSize) {
        this.partitionCacheSize = partitionCacheSize;
    }

    public int getDevicePathCacheSize() {
        return this.devicePathCacheSize;
    }

    public void setDevicePathCacheSize(int devicePathCacheSize) {
        this.devicePathCacheSize = devicePathCacheSize;
    }

    public int getAuthorCacheSize() {
        return this.authorCacheSize;
    }

    public void setAuthorCacheSize(int authorCacheSize) {
        this.authorCacheSize = authorCacheSize;
    }

    public int getAuthorCacheExpireTime() {
        return this.authorCacheExpireTime;
    }

    public void setAuthorCacheExpireTime(int authorCacheExpireTime) {
        this.authorCacheExpireTime = authorCacheExpireTime;
    }

    public int getTriggerForwardMaxQueueNumber() {
        return this.triggerForwardMaxQueueNumber;
    }

    public void setTriggerForwardMaxQueueNumber(int triggerForwardMaxQueueNumber) {
        this.triggerForwardMaxQueueNumber = triggerForwardMaxQueueNumber;
    }

    public int getTriggerForwardMaxSizePerQueue() {
        return this.triggerForwardMaxSizePerQueue;
    }

    public void setTriggerForwardMaxSizePerQueue(int triggerForwardMaxSizePerQueue) {
        this.triggerForwardMaxSizePerQueue = triggerForwardMaxSizePerQueue;
    }

    public int getTriggerForwardBatchSize() {
        return this.triggerForwardBatchSize;
    }

    public void setTriggerForwardBatchSize(int triggerForwardBatchSize) {
        this.triggerForwardBatchSize = triggerForwardBatchSize;
    }

    public int getTriggerForwardHTTPPoolSize() {
        return this.triggerForwardHTTPPoolSize;
    }

    public void setTriggerForwardHTTPPoolSize(int triggerForwardHTTPPoolSize) {
        this.triggerForwardHTTPPoolSize = triggerForwardHTTPPoolSize;
    }

    public int getTriggerForwardHTTPPOOLMaxPerRoute() {
        return this.triggerForwardHTTPPOOLMaxPerRoute;
    }

    public void setTriggerForwardHTTPPOOLMaxPerRoute(int triggerForwardHTTPPOOLMaxPerRoute) {
        this.triggerForwardHTTPPOOLMaxPerRoute = triggerForwardHTTPPOOLMaxPerRoute;
    }

    public int getTriggerForwardMQTTPoolSize() {
        return this.triggerForwardMQTTPoolSize;
    }

    public void setTriggerForwardMQTTPoolSize(int triggerForwardMQTTPoolSize) {
        this.triggerForwardMQTTPoolSize = triggerForwardMQTTPoolSize;
    }

    public int getRetryNumToFindStatefulTrigger() {
        return this.retryNumToFindStatefulTrigger;
    }

    public void setRetryNumToFindStatefulTrigger(int retryNumToFindStatefulTrigger) {
        this.retryNumToFindStatefulTrigger = retryNumToFindStatefulTrigger;
    }

    public int getCoordinatorReadExecutorSize() {
        return this.coordinatorReadExecutorSize;
    }

    public void setCoordinatorReadExecutorSize(int coordinatorReadExecutorSize) {
        this.coordinatorReadExecutorSize = coordinatorReadExecutorSize;
    }

    public int getCoordinatorWriteExecutorSize() {
        return this.coordinatorWriteExecutorSize;
    }

    public void setCoordinatorWriteExecutorSize(int coordinatorWriteExecutorSize) {
        this.coordinatorWriteExecutorSize = coordinatorWriteExecutorSize;
    }

    public TEndPoint getAddressAndPort() {
        return new TEndPoint(this.rpcAddress, this.rpcPort);
    }

    public int[] getSchemaMemoryProportion() {
        return this.schemaMemoryProportion;
    }

    public void setSchemaMemoryProportion(int[] schemaMemoryProportion) {
        this.schemaMemoryProportion = schemaMemoryProportion;
    }

    public long getAllocateMemoryForSchemaRegion() {
        return this.allocateMemoryForSchemaRegion;
    }

    public void setAllocateMemoryForSchemaRegion(long allocateMemoryForSchemaRegion) {
        this.allocateMemoryForSchemaRegion = allocateMemoryForSchemaRegion;
    }

    public long getAllocateMemoryForSchemaCache() {
        return this.allocateMemoryForSchemaCache;
    }

    public void setAllocateMemoryForSchemaCache(long allocateMemoryForSchemaCache) {
        this.allocateMemoryForSchemaCache = allocateMemoryForSchemaCache;
    }

    public long getAllocateMemoryForPartitionCache() {
        return this.allocateMemoryForPartitionCache;
    }

    public void setAllocateMemoryForPartitionCache(long allocateMemoryForPartitionCache) {
        this.allocateMemoryForPartitionCache = allocateMemoryForPartitionCache;
    }

    public String getDataNodeSchemaCacheEvictionPolicy() {
        return this.dataNodeSchemaCacheEvictionPolicy;
    }

    public void setDataNodeSchemaCacheEvictionPolicy(String dataNodeSchemaCacheEvictionPolicy) {
        this.dataNodeSchemaCacheEvictionPolicy = dataNodeSchemaCacheEvictionPolicy;
    }

    public String getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(String readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public int getDriverTaskExecutionTimeSliceInMs() {
        return this.driverTaskExecutionTimeSliceInMs;
    }

    public void setDriverTaskExecutionTimeSliceInMs(int driverTaskExecutionTimeSliceInMs) {
        this.driverTaskExecutionTimeSliceInMs = driverTaskExecutionTimeSliceInMs;
    }

    public double getWriteProportionForMemtable() {
        return this.writeProportionForMemtable;
    }

    public void setWriteProportionForMemtable(double writeProportionForMemtable) {
        this.writeProportionForMemtable = writeProportionForMemtable;
    }

    public double getCompactionProportion() {
        return this.compactionProportion;
    }

    public double getLoadTsFileProportion() {
        return this.loadTsFileProportion;
    }

    public int getMaxLoadingDeviceNumber() {
        return 10000;
    }

    public static String getEnvironmentVariables() {
        return "\n\tIOTDB_HOME=" + System.getProperty("IOTDB_HOME", "null") + ";\n\t" + "IOTDB_CONF" + "=" + System.getProperty("IOTDB_CONF", "null") + ";\n\t" + "IOTDB_DATA_HOME" + "=" + System.getProperty("IOTDB_DATA_HOME", "null") + ";";
    }

    public void setCompactionProportion(double compactionProportion) {
        this.compactionProportion = compactionProportion;
    }

    public long getThrottleThreshold() {
        return this.throttleThreshold;
    }

    public void setThrottleThreshold(long throttleThreshold) {
        this.throttleThreshold = throttleThreshold;
    }

    public double getChunkMetadataSizeProportion() {
        return this.chunkMetadataSizeProportion;
    }

    public void setChunkMetadataSizeProportion(double chunkMetadataSizeProportion) {
        this.chunkMetadataSizeProportion = chunkMetadataSizeProportion;
    }

    public long getCacheWindowTimeInMs() {
        return this.cacheWindowTimeInMs;
    }

    public void setCacheWindowTimeInMs(long cacheWindowTimeInMs) {
        this.cacheWindowTimeInMs = cacheWindowTimeInMs;
    }

    public long getDataRatisConsensusLogAppenderBufferSizeMax() {
        return this.dataRatisConsensusLogAppenderBufferSizeMax;
    }

    public void setDataRatisConsensusLogAppenderBufferSizeMax(long dataRatisConsensusLogAppenderBufferSizeMax) {
        this.dataRatisConsensusLogAppenderBufferSizeMax = dataRatisConsensusLogAppenderBufferSizeMax;
    }

    public String getConfigMessage() {
        StringBuilder configMessage = new StringBuilder();
        String[] notShowArray = new String[]{"NODE_NAME_MATCHER", "PARTIAL_NODE_MATCHER", "STORAGE_GROUP_MATCHER", "STORAGE_GROUP_PATTERN", "NODE_MATCHER", "NODE_PATTERN"};
        List<String> notShowStrings = Arrays.asList(notShowArray);
        for (Field configField : IoTDBConfig.class.getDeclaredFields()) {
            try {
                String configContent;
                String[][] configList;
                String configFieldString = configField.getName();
                if (notShowStrings.contains(configFieldString)) continue;
                String configType = configField.getGenericType().getTypeName();
                if (configType.contains("java.lang.String[][]")) {
                    configList = (String[][])configField.get(this);
                    StringBuilder builder = new StringBuilder();
                    for (String[] strings : configList) {
                        builder.append(Arrays.asList(strings)).append(";");
                    }
                    configContent = builder.toString();
                } else if (configType.contains("java.lang.String[]")) {
                    configList = (String[])configField.get(this);
                    configContent = Arrays.asList(configList).toString();
                } else {
                    configContent = configField.get(this).toString();
                }
                configMessage.append("\n\t").append(configField.getName()).append("=").append(configContent).append(";");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return configMessage.toString();
    }

    public long getDataRatisConsensusSnapshotTriggerThreshold() {
        return this.dataRatisConsensusSnapshotTriggerThreshold;
    }

    public void setDataRatisConsensusSnapshotTriggerThreshold(long dataRatisConsensusSnapshotTriggerThreshold) {
        this.dataRatisConsensusSnapshotTriggerThreshold = dataRatisConsensusSnapshotTriggerThreshold;
    }

    public boolean isDataRatisConsensusLogUnsafeFlushEnable() {
        return this.dataRatisConsensusLogUnsafeFlushEnable;
    }

    public void setDataRatisConsensusLogUnsafeFlushEnable(boolean dataRatisConsensusLogUnsafeFlushEnable) {
        this.dataRatisConsensusLogUnsafeFlushEnable = dataRatisConsensusLogUnsafeFlushEnable;
    }

    public int getDataRatisConsensusLogForceSyncNum() {
        return this.dataRatisConsensusLogForceSyncNum;
    }

    public void setDataRatisConsensusLogForceSyncNum(int dataRatisConsensusLogForceSyncNum) {
        this.dataRatisConsensusLogForceSyncNum = dataRatisConsensusLogForceSyncNum;
    }

    public long getDataRatisConsensusLogSegmentSizeMax() {
        return this.dataRatisConsensusLogSegmentSizeMax;
    }

    public void setDataRatisConsensusLogSegmentSizeMax(long dataRatisConsensusLogSegmentSizeMax) {
        this.dataRatisConsensusLogSegmentSizeMax = dataRatisConsensusLogSegmentSizeMax;
    }

    public long getDataRatisConsensusGrpcFlowControlWindow() {
        return this.dataRatisConsensusGrpcFlowControlWindow;
    }

    public void setDataRatisConsensusGrpcFlowControlWindow(long dataRatisConsensusGrpcFlowControlWindow) {
        this.dataRatisConsensusGrpcFlowControlWindow = dataRatisConsensusGrpcFlowControlWindow;
    }

    public int getDataRatisConsensusGrpcLeaderOutstandingAppendsMax() {
        return this.dataRatisConsensusGrpcLeaderOutstandingAppendsMax;
    }

    public void setDataRatisConsensusGrpcLeaderOutstandingAppendsMax(int dataRatisConsensusGrpcLeaderOutstandingAppendsMax) {
        this.dataRatisConsensusGrpcLeaderOutstandingAppendsMax = dataRatisConsensusGrpcLeaderOutstandingAppendsMax;
    }

    public long getDataRatisConsensusLeaderElectionTimeoutMinMs() {
        return this.dataRatisConsensusLeaderElectionTimeoutMinMs;
    }

    public void setDataRatisConsensusLeaderElectionTimeoutMinMs(long dataRatisConsensusLeaderElectionTimeoutMinMs) {
        this.dataRatisConsensusLeaderElectionTimeoutMinMs = dataRatisConsensusLeaderElectionTimeoutMinMs;
    }

    public long getDataRatisConsensusLeaderElectionTimeoutMaxMs() {
        return this.dataRatisConsensusLeaderElectionTimeoutMaxMs;
    }

    public void setDataRatisConsensusLeaderElectionTimeoutMaxMs(long dataRatisConsensusLeaderElectionTimeoutMaxMs) {
        this.dataRatisConsensusLeaderElectionTimeoutMaxMs = dataRatisConsensusLeaderElectionTimeoutMaxMs;
    }

    public long getSchemaRatisConsensusLogAppenderBufferSizeMax() {
        return this.schemaRatisConsensusLogAppenderBufferSizeMax;
    }

    public void setSchemaRatisConsensusLogAppenderBufferSizeMax(long schemaRatisConsensusLogAppenderBufferSizeMax) {
        this.schemaRatisConsensusLogAppenderBufferSizeMax = schemaRatisConsensusLogAppenderBufferSizeMax;
    }

    public long getSchemaRatisConsensusSnapshotTriggerThreshold() {
        return this.schemaRatisConsensusSnapshotTriggerThreshold;
    }

    public void setSchemaRatisConsensusSnapshotTriggerThreshold(long schemaRatisConsensusSnapshotTriggerThreshold) {
        this.schemaRatisConsensusSnapshotTriggerThreshold = schemaRatisConsensusSnapshotTriggerThreshold;
    }

    public boolean isSchemaRatisConsensusLogUnsafeFlushEnable() {
        return this.schemaRatisConsensusLogUnsafeFlushEnable;
    }

    public void setSchemaRatisConsensusLogUnsafeFlushEnable(boolean schemaRatisConsensusLogUnsafeFlushEnable) {
        this.schemaRatisConsensusLogUnsafeFlushEnable = schemaRatisConsensusLogUnsafeFlushEnable;
    }

    public long getSchemaRatisConsensusLogSegmentSizeMax() {
        return this.schemaRatisConsensusLogSegmentSizeMax;
    }

    public void setSchemaRatisConsensusLogSegmentSizeMax(long schemaRatisConsensusLogSegmentSizeMax) {
        this.schemaRatisConsensusLogSegmentSizeMax = schemaRatisConsensusLogSegmentSizeMax;
    }

    public long getSchemaRatisConsensusGrpcFlowControlWindow() {
        return this.schemaRatisConsensusGrpcFlowControlWindow;
    }

    public void setSchemaRatisConsensusGrpcFlowControlWindow(long schemaRatisConsensusGrpcFlowControlWindow) {
        this.schemaRatisConsensusGrpcFlowControlWindow = schemaRatisConsensusGrpcFlowControlWindow;
    }

    public long getSchemaRatisConsensusLeaderElectionTimeoutMinMs() {
        return this.schemaRatisConsensusLeaderElectionTimeoutMinMs;
    }

    public void setSchemaRatisConsensusLeaderElectionTimeoutMinMs(long schemaRatisConsensusLeaderElectionTimeoutMinMs) {
        this.schemaRatisConsensusLeaderElectionTimeoutMinMs = schemaRatisConsensusLeaderElectionTimeoutMinMs;
    }

    public long getSchemaRatisConsensusLeaderElectionTimeoutMaxMs() {
        return this.schemaRatisConsensusLeaderElectionTimeoutMaxMs;
    }

    public void setSchemaRatisConsensusLeaderElectionTimeoutMaxMs(long schemaRatisConsensusLeaderElectionTimeoutMaxMs) {
        this.schemaRatisConsensusLeaderElectionTimeoutMaxMs = schemaRatisConsensusLeaderElectionTimeoutMaxMs;
    }

    public long getCqMinEveryIntervalInMs() {
        return this.cqMinEveryIntervalInMs;
    }

    public void setCqMinEveryIntervalInMs(long cqMinEveryIntervalInMs) {
        this.cqMinEveryIntervalInMs = cqMinEveryIntervalInMs;
    }

    public double getUsableCompactionMemoryProportion() {
        return 1.0 - this.chunkMetadataSizeProportion;
    }

    public int getPatternMatchingThreshold() {
        return this.patternMatchingThreshold;
    }

    public void setPatternMatchingThreshold(int patternMatchingThreshold) {
        this.patternMatchingThreshold = patternMatchingThreshold;
    }

    public long getDataRatisConsensusRequestTimeoutMs() {
        return this.dataRatisConsensusRequestTimeoutMs;
    }

    public void setDataRatisConsensusRequestTimeoutMs(long dataRatisConsensusRequestTimeoutMs) {
        this.dataRatisConsensusRequestTimeoutMs = dataRatisConsensusRequestTimeoutMs;
    }

    public long getSchemaRatisConsensusRequestTimeoutMs() {
        return this.schemaRatisConsensusRequestTimeoutMs;
    }

    public void setSchemaRatisConsensusRequestTimeoutMs(long schemaRatisConsensusRequestTimeoutMs) {
        this.schemaRatisConsensusRequestTimeoutMs = schemaRatisConsensusRequestTimeoutMs;
    }

    public int getDataRatisConsensusMaxRetryAttempts() {
        return this.dataRatisConsensusMaxRetryAttempts;
    }

    public void setDataRatisConsensusMaxRetryAttempts(int dataRatisConsensusMaxRetryAttempts) {
        this.dataRatisConsensusMaxRetryAttempts = dataRatisConsensusMaxRetryAttempts;
    }

    public int getSchemaRatisConsensusMaxRetryAttempts() {
        return this.schemaRatisConsensusMaxRetryAttempts;
    }

    public void setSchemaRatisConsensusMaxRetryAttempts(int schemaRatisConsensusMaxRetryAttempts) {
        this.schemaRatisConsensusMaxRetryAttempts = schemaRatisConsensusMaxRetryAttempts;
    }

    public long getDataRatisConsensusInitialSleepTimeMs() {
        return this.dataRatisConsensusInitialSleepTimeMs;
    }

    public void setDataRatisConsensusInitialSleepTimeMs(long dataRatisConsensusInitialSleepTimeMs) {
        this.dataRatisConsensusInitialSleepTimeMs = dataRatisConsensusInitialSleepTimeMs;
    }

    public long getSchemaRatisConsensusInitialSleepTimeMs() {
        return this.schemaRatisConsensusInitialSleepTimeMs;
    }

    public void setSchemaRatisConsensusInitialSleepTimeMs(long schemaRatisConsensusInitialSleepTimeMs) {
        this.schemaRatisConsensusInitialSleepTimeMs = schemaRatisConsensusInitialSleepTimeMs;
    }

    public long getDataRatisConsensusMaxSleepTimeMs() {
        return this.dataRatisConsensusMaxSleepTimeMs;
    }

    public void setDataRatisConsensusMaxSleepTimeMs(long dataRatisConsensusMaxSleepTimeMs) {
        this.dataRatisConsensusMaxSleepTimeMs = dataRatisConsensusMaxSleepTimeMs;
    }

    public long getSchemaRatisConsensusMaxSleepTimeMs() {
        return this.schemaRatisConsensusMaxSleepTimeMs;
    }

    public void setSchemaRatisConsensusMaxSleepTimeMs(long schemaRatisConsensusMaxSleepTimeMs) {
        this.schemaRatisConsensusMaxSleepTimeMs = schemaRatisConsensusMaxSleepTimeMs;
    }

    public Properties getCustomizedProperties() {
        return this.customizedProperties;
    }

    public void setCustomizedProperties(Properties customizedProperties) {
        this.customizedProperties = customizedProperties;
    }

    public long getDataRatisConsensusPreserveWhenPurge() {
        return this.dataRatisConsensusPreserveWhenPurge;
    }

    public void setDataRatisConsensusPreserveWhenPurge(long dataRatisConsensusPreserveWhenPurge) {
        this.dataRatisConsensusPreserveWhenPurge = dataRatisConsensusPreserveWhenPurge;
    }

    public long getSchemaRatisConsensusPreserveWhenPurge() {
        return this.schemaRatisConsensusPreserveWhenPurge;
    }

    public void setSchemaRatisConsensusPreserveWhenPurge(long schemaRatisConsensusPreserveWhenPurge) {
        this.schemaRatisConsensusPreserveWhenPurge = schemaRatisConsensusPreserveWhenPurge;
    }

    public long getRatisFirstElectionTimeoutMinMs() {
        return this.ratisFirstElectionTimeoutMinMs;
    }

    public void setRatisFirstElectionTimeoutMinMs(long ratisFirstElectionTimeoutMinMs) {
        this.ratisFirstElectionTimeoutMinMs = ratisFirstElectionTimeoutMinMs;
    }

    public long getRatisFirstElectionTimeoutMaxMs() {
        return this.ratisFirstElectionTimeoutMaxMs;
    }

    public void setRatisFirstElectionTimeoutMaxMs(long ratisFirstElectionTimeoutMaxMs) {
        this.ratisFirstElectionTimeoutMaxMs = ratisFirstElectionTimeoutMaxMs;
    }

    public long getDataRatisLogMax() {
        return this.dataRatisLogMax;
    }

    public void setDataRatisLogMax(long dataRatisLogMax) {
        this.dataRatisLogMax = dataRatisLogMax;
    }

    public long getSchemaRatisLogMax() {
        return this.schemaRatisLogMax;
    }

    public void setSchemaRatisLogMax(long schemaRatisLogMax) {
        this.schemaRatisLogMax = schemaRatisLogMax;
    }

    public boolean isEnableCompactionValidation() {
        return this.enableCompactionValidation;
    }

    public void setEnableCompactionValidation(boolean enableCompactionValidation) {
        this.enableCompactionValidation = enableCompactionValidation;
    }

    public int getCandidateCompactionTaskQueueSize() {
        return this.candidateCompactionTaskQueueSize;
    }

    public void setCandidateCompactionTaskQueueSize(int candidateCompactionTaskQueueSize) {
        this.candidateCompactionTaskQueueSize = candidateCompactionTaskQueueSize;
    }

    public boolean isEnableAuditLog() {
        return this.enableAuditLog;
    }

    public void setEnableAuditLog(boolean enableAuditLog) {
        this.enableAuditLog = enableAuditLog;
    }

    public List<AuditLogStorage> getAuditLogStorage() {
        return this.auditLogStorage;
    }

    public void setAuditLogStorage(List<AuditLogStorage> auditLogStorage) {
        this.auditLogStorage = auditLogStorage;
    }

    public List<AuditLogOperation> getAuditLogOperation() {
        return this.auditLogOperation;
    }

    public void setAuditLogOperation(List<AuditLogOperation> auditLogOperation) {
        this.auditLogOperation = auditLogOperation;
    }

    public boolean isEnableAuditLogForNativeInsertApi() {
        return this.enableAuditLogForNativeInsertApi;
    }

    public void setEnableAuditLogForNativeInsertApi(boolean enableAuditLogForNativeInsertApi) {
        this.enableAuditLogForNativeInsertApi = enableAuditLogForNativeInsertApi;
    }

    public void setModeMapSizeThreshold(int modeMapSizeThreshold) {
        this.modeMapSizeThreshold = modeMapSizeThreshold;
    }

    public int getModeMapSizeThreshold() {
        return this.modeMapSizeThreshold;
    }

    public void setPipeReceiverFileDir(String pipeReceiveFileDir) {
        this.pipeReceiveFileDir = pipeReceiveFileDir;
    }

    public String getPipeReceiverFileDir() {
        return this.pipeReceiveFileDir;
    }

    public boolean isQuotaEnable() {
        return this.quotaEnable;
    }

    public void setQuotaEnable(boolean quotaEnable) {
        this.quotaEnable = quotaEnable;
    }

    public String getRateLimiterType() {
        return this.RateLimiterType;
    }

    public void setRateLimiterType(String rateLimiterType) {
        this.RateLimiterType = rateLimiterType;
    }

    public void setSortBufferSize(long sortBufferSize) {
        this.sortBufferSize = sortBufferSize;
    }

    public long getSortBufferSize() {
        return this.sortBufferSize;
    }

    public void setSortTmpDir(String sortTmpDir) {
        this.sortTmpDir = sortTmpDir;
    }

    public String getSortTmpDir() {
        return this.sortTmpDir;
    }

    public String getClusterSchemaLimitLevel() {
        return this.clusterSchemaLimitLevel;
    }

    public void setClusterSchemaLimitLevel(String clusterSchemaLimitLevel) {
        this.clusterSchemaLimitLevel = clusterSchemaLimitLevel;
    }

    public long getClusterSchemaLimitThreshold() {
        return this.clusterSchemaLimitThreshold;
    }

    public void setClusterSchemaLimitThreshold(long clusterSchemaLimitThreshold) {
        this.clusterSchemaLimitThreshold = clusterSchemaLimitThreshold;
    }

    public String getObjectStorageBucket() {
        throw new UnsupportedOperationException("object storage is not supported yet");
    }
}

